/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.types;

import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.upi.routing.UpiRoutingNaming;
import org.json.JSONException;
import org.json.JSONObject;

public class TargetParameters {
    public static final String PARAM_ROTATION = "rotation";
    public static final String PARAM_FIELD = "field";
    public static final String PARAM_COMPLETED = "goodta";
    public static final String PARAM_FAILED = "badta";
    public static final String PARAM_LASTSEEN = "lastseen";
    public static final String PARAM_BAT_PASSIVE = "batpas";
    public static final String PARAM_BAT_UPDATE = "batupd";
    public static final String PARAM_LATENCY = "latency";
    public static final String PARAM_REQ_LATENCY = "req_latency";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_COMMENT = "comment";
    public static final String PARAM_BATTERY_LEVEL = "battery_level";
    public static final String PARAM_RADIO_LEVEL = "radio_level";
    private String name = "";
    private int rotation = 0;
    private int screen_update_method = 0;
    private int req_wakeup = 0;
    private String comment = "";
    private int field = 0;
    private int good_ta = 0;
    private int bad_ta = 0;
    private int last_seen = 0;
    private int wakeup = 0;
    private int battery_passive = 0;
    private int battery_active = 0;
    private int type = 0;

    public TargetParameters() {
    }

    public TargetParameters(String string) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            return;
        }
        this.fromJSON(jSONObject);
    }

    public TargetParameters(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public void copyFrom(TargetParameters targetParameters) {
        this.field = targetParameters.field;
        this.good_ta = targetParameters.good_ta;
        this.bad_ta = targetParameters.bad_ta;
        this.last_seen = targetParameters.last_seen;
        this.wakeup = targetParameters.wakeup;
        this.req_wakeup = targetParameters.req_wakeup;
        this.battery_passive = targetParameters.battery_passive;
        this.battery_active = targetParameters.battery_active;
        this.type = targetParameters.type;
        this.comment = targetParameters.comment;
    }

    public void fullCopyFrom(TargetParameters targetParameters) {
        this.copyFrom(targetParameters);
        this.name = targetParameters.name;
        this.rotation = targetParameters.rotation;
        this.screen_update_method = targetParameters.screen_update_method;
        this.req_wakeup = targetParameters.req_wakeup;
        this.comment = targetParameters.comment;
    }

    private void fromJSON(JSONObject jSONObject) {
        try {
            this.name = jSONObject.getString(UpiRoutingNaming.UpiRoutingTargetParams.NAME.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.rotation = jSONObject.getInt(PARAM_ROTATION);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.screen_update_method = jSONObject.getInt(UpiRoutingNaming.UpiRoutingTargetParams.SCREEN_UPDATE_METHOD.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.comment = jSONObject.getString(PARAM_COMMENT);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.field = jSONObject.getInt(PARAM_FIELD);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.good_ta = jSONObject.getInt(PARAM_COMPLETED);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.bad_ta = jSONObject.getInt(PARAM_FAILED);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.last_seen = jSONObject.getInt(PARAM_LASTSEEN);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.wakeup = jSONObject.getInt(PARAM_LATENCY);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.req_wakeup = jSONObject.getInt(PARAM_REQ_LATENCY);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.battery_passive = jSONObject.getInt(PARAM_BAT_PASSIVE);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.battery_active = jSONObject.getInt(PARAM_BAT_UPDATE);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.type = jSONObject.getInt(PARAM_TYPE);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(UpiRoutingNaming.UpiRoutingTargetParams.NAME.toString(), (Object)this.name);
        jSONObject.put(PARAM_ROTATION, this.rotation);
        jSONObject.put(UpiRoutingNaming.UpiRoutingTargetParams.SCREEN_UPDATE_METHOD.toString(), this.screen_update_method);
        jSONObject.put(PARAM_BATTERY_LEVEL, this.getBatteryLevel());
        jSONObject.put(PARAM_RADIO_LEVEL, this.getRadioLevel());
        jSONObject.put(PARAM_REQ_LATENCY, this.req_wakeup);
        jSONObject.put(PARAM_COMMENT, (Object)this.comment);
        jSONObject.put(PARAM_FIELD, this.field);
        jSONObject.put(PARAM_COMPLETED, this.good_ta);
        jSONObject.put(PARAM_FAILED, this.bad_ta);
        jSONObject.put(PARAM_LASTSEEN, this.last_seen);
        jSONObject.put(PARAM_LATENCY, this.wakeup);
        jSONObject.put(PARAM_BAT_PASSIVE, this.battery_passive);
        jSONObject.put(PARAM_BAT_UPDATE, this.battery_active);
        jSONObject.put(PARAM_TYPE, this.type);
        return jSONObject;
    }

    public int getField() {
        return this.field;
    }

    public void setField(int n) {
        this.field = n;
    }

    public int getGoodTransmissions() {
        return this.good_ta;
    }

    public void setGoodTransmissions(int n) {
        this.good_ta = n;
    }

    public int getBadTransmissions() {
        return this.bad_ta;
    }

    public void setBadTransmissions(int n) {
        this.bad_ta = n;
    }

    public int getLastSeen() {
        return this.last_seen;
    }

    public void setLastSeen(int n) {
        this.last_seen = n;
    }

    public int getWakeup() {
        return this.wakeup;
    }

    public void setWakeup(int n) {
        this.wakeup = n;
    }

    public int getRequiredWakeup() {
        return this.req_wakeup;
    }

    public void setRequiredWakeup(int n) {
        this.req_wakeup = n;
    }

    public int getBatteryPassive() {
        return this.battery_passive;
    }

    public void setBatteryPassive(int n) {
        this.battery_passive = n;
    }

    public int getBatteryActive() {
        return this.battery_active;
    }

    public void setBatteryActive(int n) {
        this.battery_active = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String toString() {
        try {
            return this.toJSON().toString(4);
        }
        catch (JSONException jSONException) {
            return "{}";
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.bad_ta;
        n = 31 * n + this.battery_active;
        n = 31 * n + this.battery_passive;
        n = 31 * n + (this.comment == null ? 0 : this.comment.hashCode());
        n = 31 * n + this.field;
        n = 31 * n + this.good_ta;
        n = 31 * n + this.last_seen;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + this.req_wakeup;
        n = 31 * n + this.rotation;
        n = 31 * n + this.screen_update_method;
        n = 31 * n + this.type;
        n = 31 * n + this.wakeup;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TargetParameters targetParameters = (TargetParameters)object;
        if (this.bad_ta != targetParameters.bad_ta) {
            return false;
        }
        if (this.battery_active != targetParameters.battery_active) {
            return false;
        }
        if (this.battery_passive != targetParameters.battery_passive) {
            return false;
        }
        if (this.comment == null ? targetParameters.comment != null : !this.comment.equals(targetParameters.comment)) {
            return false;
        }
        if (this.field != targetParameters.field) {
            return false;
        }
        if (this.good_ta != targetParameters.good_ta) {
            return false;
        }
        if (this.last_seen != targetParameters.last_seen) {
            return false;
        }
        if (this.name == null ? targetParameters.name != null : !this.name.equals(targetParameters.name)) {
            return false;
        }
        if (this.req_wakeup != targetParameters.req_wakeup) {
            return false;
        }
        if (this.rotation != targetParameters.rotation) {
            return false;
        }
        if (this.screen_update_method != targetParameters.screen_update_method) {
            return false;
        }
        if (this.type != targetParameters.type) {
            return false;
        }
        return this.wakeup == targetParameters.wakeup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        this.rotation = n;
    }

    public int getScreenUpdateMethod() {
        return this.screen_update_method;
    }

    public void setScreenUpdateMethod(int n) {
        this.screen_update_method = n;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public int getRadioLevel() {
        int n = (int)((float)(this.field + 10) / -79.0f * 100.0f);
        n = 100 - Math.min(100, Math.max(n, 0));
        return n;
    }

    public int getBatteryLevel() {
        int n;
        int n2;
        if (this.battery_passive == 0 && this.battery_active == 0) {
            return -1;
        }
        Display display = new Display(this.type);
        switch (display.getType()) {
            case TYPE_057: {
                n2 = 3200;
                n = 2000;
                break;
            }
            case TYPE_060: 
            case TYPE_097: 
            case TYPE_060_PLUS: {
                n2 = 3200;
                n = 2500;
                break;
            }
            default: {
                return -1;
            }
        }
        int[] nArray = new int[]{this.battery_passive, this.battery_active};
        int n3 = 100;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n4 == 0) continue;
            if (n4 > n2) {
                n4 = n2;
            } else if (n4 < n) {
                n4 = n;
            }
            int n5 = (n4 -= n) * 100 / (n2 - n);
            if (n5 >= n3) continue;
            n3 = n5;
        }
        return n3;
    }
}

