/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.templates.TemplateInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class EventProcessorTemplateManager {
    private final Map<String, File> file_cache = new HashMap<String, File>();
    private final Map<String, Long> mtime_cache = new HashMap<String, Long>();
    private final Map<String, TemplateInfo> tpl_cache = new HashMap<String, TemplateInfo>();

    EventProcessorTemplateManager() {
    }

    public TemplateInfo getTemplate(String string) {
        if (!this.file_cache.containsKey(string)) {
            this.file_cache.put(string, new WpFile(string, WpFile.WpFileType.TEMPLATE_FILE).getJavaFile());
            this.mtime_cache.put(string, 0L);
        }
        long l = this.file_cache.get(string).lastModified();
        if (this.mtime_cache.get(string) != l) {
            this.mtime_cache.put(string, l);
            WpFile wpFile = new WpFile(string, WpFile.WpFileType.TEMPLATE_FILE);
            if (wpFile.exists()) {
                try {
                    TemplateInfo templateInfo = new TemplateInfo(wpFile.getResolvedFileName());
                    this.tpl_cache.put(string, templateInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.tpl_cache.get(string);
    }
}

