/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.core.Schadchen;
import de.wilke.wizepanel.eventmanager.Cfg;
import de.wilke.wizepanel.eventmanager.EventProcessor;
import de.wilke.wizepanel.eventmanager.cache.CacheResult;
import de.wilke.wizepanel.eventmanager.cache.EventCache;
import de.wilke.wizepanel.eventmanager.content.CalendarContent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.jms.session.WpSession;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.sessions.ResourceBuilder;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fortuna.ical4j.model.DateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventScheduler
extends Thread {
    private static final Logger m_logger = LogManager.getLogger(EventScheduler.class);
    private final EventCache _events = new EventCache();
    private final Map<String, CalendarContent> _content = new ConcurrentHashMap<String, CalendarContent>();
    private final EventProcessor many_faces;
    private int future_days = WpUpiServerStaticFactory.getServerLocator().getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.WP_SERVER_EM_FUTURE_DAYS);
    private boolean running = true;

    public EventScheduler() {
        this.many_faces = new EventProcessor();
        m_logger.info("future_days: {}", (Object)this.future_days);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                m_logger.debug("Running");
                Map<String, List<CacheResult>> map = this.getNextEventsMapAsSources(this.future_days);
                this.many_faces.execute(this, this._content, map);
                try {
                    Thread.sleep(Cfg.getSystemLatency() * 1000);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable throwable) {
                m_logger.fatal("RAGNAROK", throwable);
            }
        }
    }

    public void send_session(WpSession wpSession) {
        m_logger.info("New session: {}", wpSession.getEvent() != null ? wpSession.getEvent().getTargetStationName() : null);
        if (wpSession != null) {
            ResourceBuilder.instance.add(wpSession);
        }
    }

    public synchronized void setAdapterEvents(String string, List<CalendarEvent> list) {
        m_logger.info("New adapter events: {} #{} events", (Object)string, list == null ? "DEL" : Integer.valueOf(list.size()));
        this._events.removeByAdapter(string);
        if (list != null) {
            for (CalendarEvent calendarEvent : list) {
                this._events.add(calendarEvent);
            }
        }
        this.wakeup();
    }

    public void setAdapterContent(String string, CalendarContent calendarContent) {
        m_logger.info("New target content: {} #{} placeholders", (Object)calendarContent.target_name, calendarContent.data == null ? "DEL" : Integer.valueOf(calendarContent.data.size()));
        this._content.put(string + "#" + calendarContent.target_name, calendarContent);
        this.wakeup();
    }

    public synchronized void removeAdapterStuff(String string) {
        this._events.removeByAdapter(string);
        Iterator<String> iterator = this._content.keySet().iterator();
        while (iterator.hasNext()) {
            CalendarContent calendarContent = this._content.get(iterator.next());
            if (!calendarContent.adapter_name.equals(string)) continue;
            iterator.remove();
        }
        this.wakeup();
    }

    public synchronized void addEvent(CalendarEvent calendarEvent) {
        this._events.add(calendarEvent);
        this.wakeup();
    }

    private Map<String, List<CacheResult>> getNextEventsMapAsSources(int n) {
        HashMap<String, List<CacheResult>> hashMap = new HashMap<String, List<CacheResult>>();
        for (CacheResult cacheResult : this.getNextEvents(n)) {
            String string = cacheResult.getEvent().getAdapterName() + "#" + cacheResult.getEvent().getTargetName();
            if (hashMap.get(string) == null) {
                hashMap.put(string, new LinkedList());
            }
            ((List)hashMap.get(string)).add(cacheResult);
        }
        return hashMap;
    }

    public synchronized List<CacheResult> getNextEvents(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return this._events.getRecurrences(new DateTime(calendar.getTime()));
    }

    public synchronized void removeByUID(String string) {
        m_logger.debug("Removing file from cache: {}", (Object)string);
        this._events.removeByUID(string);
        this.wakeup();
    }

    public void clearHistory(UpiTargetItem upiTargetItem) {
        this.many_faces.clearHistory(upiTargetItem);
        this.wakeup();
    }

    public Schadchen getSchadchen() {
        return this.many_faces.getSchadchen();
    }

    public void wakeup() {
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void kill() {
        this.running = false;
        this.wakeup();
    }
}

