/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.eventmanager.cache.CacheResult;
import de.wilke.wizepanel.templates.TemplateInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

class ManyFacesLegacyConst {
    public static final String PLACEHOLDER_NOW_SUBJECT = "NOW_SUBJECT";
    public static final String PLACEHOLDER_NOW_START_OLD = "NOW_START";
    public static final String PLACEHOLDER_NOW_END = "NOW_END";
    public static final String PLACEHOLDER_NOW_CREATOR = "NOW_CREATOR";
    public static final String PLACEHOLDER_NEXT_SUBJECT = "NEXT_SUBJECT";
    public static final String PLACEHOLDER_NEXT_START_OLD = "NEXT_START";
    public static final String PLACEHOLDER_NEXT_START_END = "NEXT_START_END";
    public static final String PLACEHOLDER_NEXT_END = "NEXT_END";
    public static final String PLACEHOLDER_NEXT_CREATOR = "NEXT_CREATOR";

    ManyFacesLegacyConst() {
    }

    public static String create_time(Date date) {
        return SimpleDateFormat.getTimeInstance().format(date).substring(0, 5);
    }

    public static void add_legacy_placeholders(Map<String, String> map, List<CacheResult> list, CacheResult cacheResult, CacheResult cacheResult2, TemplateInfo templateInfo) {
        if (cacheResult != null) {
            map.put("DTSTART", cacheResult.getEventTime().getStart().toString());
            map.put("DTEND", cacheResult.getEventTime().getEnd().toString());
            map.put("SUMMARY", cacheResult.getEvent().getSummary());
            map.put("DESCRIPTION", cacheResult.getEvent().getDescription());
            map.put("CREATOR", cacheResult.getEvent().getOrganizerName());
            String string = cacheResult.getEvent().getLocation();
            if (string != null) {
                map.put("LOCATION", string);
            }
            map.put(PLACEHOLDER_NOW_SUBJECT, cacheResult.getEvent().getSummary());
            map.put(PLACEHOLDER_NOW_START_OLD, ManyFacesLegacyConst.create_time((Date)cacheResult.getEventTime().getStart()) + " - " + ManyFacesLegacyConst.create_time((Date)cacheResult.getEventTime().getEnd()));
            map.put(PLACEHOLDER_NOW_CREATOR, cacheResult.getEvent().getPlaceholder(PLACEHOLDER_NOW_CREATOR, cacheResult.getEvent().getOrganizerName()));
        }
        if (cacheResult2 != null) {
            map.put(PLACEHOLDER_NEXT_SUBJECT, cacheResult2.getEvent().getSummary());
            map.put(PLACEHOLDER_NEXT_START_OLD, ManyFacesLegacyConst.create_time((Date)cacheResult2.getEventTime().getStart()) + " - " + ManyFacesLegacyConst.create_time((Date)cacheResult2.getEventTime().getEnd()));
            map.put(PLACEHOLDER_NEXT_CREATOR, cacheResult2.getEvent().getOrganizerName());
        }
        for (int i = 1; list != null && i < list.size() && i < templateInfo.numberOfEvents(); ++i) {
            CacheResult cacheResult3 = list.get(i);
            if (cacheResult3 == null) continue;
            map.put("NEXT_SUBJECT[" + (i - 1) + "]", cacheResult3.getEvent().getSummary());
            map.put("NEXT_START[" + (i - 1) + "]", cacheResult3.getEventTime().getStart().toString());
            map.put("NEXT_START_END[" + (i - 1) + "]", ManyFacesLegacyConst.create_time((Date)cacheResult3.getEventTime().getStart()) + " - " + ManyFacesLegacyConst.create_time((Date)cacheResult3.getEventTime().getEnd()));
            map.put("NEXT_END[" + (i - 1) + "]", cacheResult3.getEventTime().getEnd().toString());
            map.put("NEXT_CREATOR[" + (i - 1) + "]", cacheResult3.getEvent().getOrganizerName());
        }
    }
}

