/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.core.Schadchen;
import de.wilke.wizepanel.core.locator.IWpLocatorPropertyType;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.CleanupTask;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.SpoolTask;
import de.wilke.wizepanel.eventmanager.cache.CacheResult;
import de.wilke.wizepanel.sessions.Communicator;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WPEventManager {
    private final Logger m_logger = LogManager.getLogger(WPEventManager.class);
    private final Timer m_spool_timer;
    private final Timer m_cleanup_timer;
    private final SpoolTask spool_task;
    private final EventScheduler scheduler;

    public WPEventManager() {
        long l = WpSystemLocator.getLocator().getInt((IWpLocatorPropertyType)WpSystemLocator.WpSystemLocatorPropType.CLEANUP_DONE_ICS_FILE);
        long l2 = WpSystemLocator.getLocator().getInt((IWpLocatorPropertyType)WpSystemLocator.WpSystemLocatorPropType.CLEANUP_FINAL_IMAGES);
        this.m_logger.info("Starting/Creating: cleanup task (default: " + l + ", final images: " + l2 + ")");
        if (l > 0L) {
            this.m_cleanup_timer = new Timer("WP-EM-CleanupTask");
            this.m_cleanup_timer.scheduleAtFixedRate((TimerTask)new CleanupTask(l, l2), 0L, 3600000L);
        } else {
            this.m_cleanup_timer = null;
        }
        this.scheduler = new EventScheduler();
        this.scheduler.start();
        this.spool_task = new SpoolTask(this.scheduler);
        this.m_logger.info("Starting/Creating: spool task");
        this.m_spool_timer = new Timer("WP-EM-SpoolTask");
        this.m_spool_timer.scheduleAtFixedRate((TimerTask)this.spool_task, 0L, 10000L);
    }

    public void stop() {
        this.m_logger.info("Stopping");
        this.m_spool_timer.cancel();
        if (this.m_cleanup_timer != null) {
            this.m_cleanup_timer.cancel();
        }
        this.scheduler.kill();
    }

    public EventScheduler getScheduler() {
        return this.scheduler;
    }

    public List<CacheResult> getNextEvents(int n) {
        return this.getScheduler().getNextEvents(n);
    }

    public void resendEvents(UpiTargetItem upiTargetItem) {
        Communicator.instance.clearHistory(upiTargetItem);
        this.getScheduler().clearHistory(upiTargetItem);
        this.getScheduler().wakeup();
    }

    public Schadchen getSchadchen() {
        return this.getScheduler().getSchadchen();
    }
}

