/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.asc_timetables;

import de.wilke.wizepanel.eventmanager.adapters.asc_timetables.AscLesson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AscServerReply {
    private static final Logger logger = LogManager.getLogger(AscServerReply.class);
    private final Map<String, List<AscLesson>> lessons = new HashMap<String, List<AscLesson>>();
    private final Map<String, String> classes = new HashMap<String, String>();
    private final Map<String, String> teachers = new HashMap<String, String>();
    private final Map<String, String> subjects = new HashMap<String, String>();
    private final Map<String, String> classrooms = new HashMap<String, String>();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public int get(String object, Date date, int n) throws Exception {
        String string = sdf.format(date);
        object = (String)object + "/connect_dailyplan.php?cmd=getdailyplan&date=" + string;
        logger.debug("Connecting to: " + (String)object);
        String string2 = this.get_xml((String)object);
        int n2 = string2.hashCode();
        if (n != n2) {
            this.parse(string2, string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get_xml(String string) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Content-type", "text/xml; charset=utf-8");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(10000);
            StringBuilder stringBuilder = new StringBuilder();
            try (Object object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                String string2;
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string2);
                }
            }
            if (httpURLConnection.getResponseCode() != 200) {
                throw new Exception("ERROR: " + httpURLConnection.getResponseCode());
            }
            object = stringBuilder.toString();
            return object;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public List<AscLesson> lessons(String string) {
        return this.lessons.get(string);
    }

    public Map<String, String> rooms() {
        return this.classrooms;
    }

    private void parse(String string, String string2) throws Exception {
        logger.debug("Parsing...[" + string2 + "]: " + string);
        try {
            Object object;
            NodeList nodeList;
            NodeList nodeList2;
            NodeList nodeList3;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList4 = document.getElementsByTagName("class");
            if (nodeList4.getLength() > 0) {
                for (int i = 0; i < nodeList4.getLength(); ++i) {
                    NamedNodeMap namedNodeMap = nodeList4.item(i).getAttributes();
                    this.classes.put(namedNodeMap.getNamedItem("id").getTextContent(), namedNodeMap.getNamedItem("name").getTextContent());
                }
            }
            if ((nodeList3 = document.getElementsByTagName("teacher")).getLength() > 0) {
                for (int i = 0; i < nodeList3.getLength(); ++i) {
                    NamedNodeMap namedNodeMap = nodeList3.item(i).getAttributes();
                    this.teachers.put(namedNodeMap.getNamedItem("id").getTextContent(), namedNodeMap.getNamedItem("lastname").getTextContent());
                }
            }
            if ((nodeList2 = document.getElementsByTagName("subject")).getLength() > 0) {
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    NamedNodeMap namedNodeMap = nodeList2.item(i).getAttributes();
                    this.subjects.put(namedNodeMap.getNamedItem("id").getTextContent(), namedNodeMap.getNamedItem("name").getTextContent());
                }
            }
            if ((nodeList = document.getElementsByTagName("classroom")).getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object = nodeList.item(i).getAttributes();
                    String string3 = object.getNamedItem("id").getTextContent();
                    this.classrooms.put(string3, object.getNamedItem("name").getTextContent());
                    this.lessons.put(string3, new LinkedList());
                }
            }
            Date date = new Date();
            object = document.getElementsByTagName("item");
            if (object.getLength() > 0) {
                for (int i = 0; i < object.getLength(); ++i) {
                    NamedNodeMap namedNodeMap = object.item(i).getAttributes();
                    this.create_lessons(namedNodeMap, string2, date);
                }
            }
        }
        catch (DOMException dOMException) {
            throw new Exception(string);
        }
        catch (SAXException sAXException) {
            throw new Exception(string);
        }
    }

    private void create_lessons(NamedNodeMap namedNodeMap, String string, Date date) {
        String[] stringArray;
        for (String string2 : stringArray = namedNodeMap.getNamedItem("classroomids").getTextContent().split(",")) {
            AscLesson ascLesson = new AscLesson(this.classes, this.teachers, this.subjects, this.classrooms.get(string2), namedNodeMap, string);
            if (ascLesson.getEnd().before(date)) continue;
            this.lessons.get(string2).add(ascLesson);
        }
    }
}

