/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.convergence;

import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.WilkeSimpleEventsAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarUtils;
import de.wilke.wizepanel.simple_events.SimpleEventsServer;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.logging.log4j.Logger;

public class ConvergenceTask
extends AdapterJob {
    private final WilkeSimpleEventsAdapter adapter;
    private String historyDuration;
    EventScheduler scheduler;
    private long last_hashcode = 0L;

    public ConvergenceTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.scheduler = eventScheduler;
        this.adapter = (WilkeSimpleEventsAdapter)abstractAdapterConfiguration;
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        if (this.adapter.targets() == null || this.adapter.targets().size() == 0) {
            this.stop();
        }
    }

    @Override
    public void singleRun() {
        LinkedList<String> linkedList = new LinkedList<String>();
        long l = SimpleEventsServer.getServer().getEvents(this.last_hashcode, linkedList);
        if (l == this.last_hashcode) {
            return;
        }
        this.last_hashcode = l;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(this.historyDuration));
        LinkedList<CalendarEvent> linkedList2 = new LinkedList<CalendarEvent>();
        for (String string : linkedList) {
            Object object;
            CalendarEvent calendarEvent = CalendarUtils.create_event(string, this);
            if (calendarEvent == null) continue;
            String string2 = this.adapter.getName() + calendarEvent.getUID();
            calendarEvent.setUID(string2);
            if (calendarEvent.isExpired(calendar.getTime())) {
                SimpleEventsServer.getServer().delEvent(string2);
                continue;
            }
            calendarEvent.setAdapterName(this.adapter.getName());
            if (!calendarEvent.getPlaceholders().containsKey("SE_TARGET")) {
                calendarEvent.getPlaceholders().put("SE_TARGET", calendarEvent.getTargetName());
            }
            if (this.adapter.targets().contains(calendarEvent.getTargetName())) {
                linkedList2.add(calendarEvent);
            }
            if (!this.adapter.onlyMainTargets()) {
                object = SimpleEventsServer.getServer().getAllSubrooms(calendarEvent.getTargetName());
                Iterator<String> iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    if (!this.adapter.targets().contains(string3)) continue;
                    CalendarEvent calendarEvent2 = new CalendarEvent(calendarEvent);
                    calendarEvent2.setTargetName(string3);
                    calendarEvent2.setUID(string2 + string3);
                    calendarEvent2.setIsSimpleEventsNonMain();
                    linkedList2.add(calendarEvent2);
                }
            }
            if (!this.adapter.targets().contains("_Overview")) continue;
            object = new CalendarEvent(calendarEvent);
            ((CalendarEvent)object).setTargetName("_Overview");
            ((CalendarEvent)object).setUID(string2 + "_Overview");
            ((CalendarEvent)object).setIsSimpleEventsNonMain();
            linkedList2.add((CalendarEvent)object);
        }
        this.setAdapterEvents(linkedList2);
    }
}

