/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.csv;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.CsvAdapter;
import de.wilke.wizepanel.core.adapters.types.CsvAdapterFormat;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.csv.CsvUtils;
import de.wilke.wizepanel.eventmanager.adapters.csv.HashedCsvFile;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Logger;

public class CsvTask
extends AdapterJob {
    private final CsvAdapterFormat m_fmt;
    private String url = null;
    private int url_lash_hash = 0;
    private WpFile m_csv;
    private long copy_last_modified = 0L;
    private String m_hash_salt;
    private final CsvAdapter cfg;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String last_day_check = "";

    public CsvTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.cfg = (CsvAdapter)abstractAdapterConfiguration;
        this.m_fmt = this.cfg.getFormat();
        if (WpFileUtils.isWeb((String)this.cfg.getCsvFile())) {
            this.url = this.cfg.getCsvFile();
            this.m_hash_salt = this.m_fmt.toString() + this.url + this.cfg.getName();
            logger.info("{} | {} | {}", (Object)this.cfg.getEncoding(), (Object)this.m_fmt.toString(), (Object)this.url);
        } else {
            this.m_csv = new WpFile(this.cfg.getCsvFile(), WpFile.WpFileType.RESOURCE_CSV_WATCH_FILE);
            this.m_hash_salt = this.m_fmt.toString() + this.m_csv.getOriginalFileName() + this.cfg.getName();
            logger.info("{} | {} | {}", (Object)this.cfg.getEncoding(), (Object)this.m_fmt.toString(), (Object)this.m_csv.getResolvedFileName());
        }
    }

    @Override
    public void singleRun() {
        try {
            if (this.url == null) {
                if (this.m_csv != null) {
                    this.file_mode();
                }
            } else {
                this.url_mode();
            }
        }
        catch (Exception exception) {
            this.logger.fatal("Oops", (Throwable)exception);
        }
    }

    private void file_mode() throws Exception {
        boolean bl;
        if (!this.m_csv.getJavaFile().exists()) {
            this.addAdapterError("File does not exist: " + this.m_csv.getOriginalFileName());
            return;
        }
        String string = this.sdf.format(new Date());
        boolean bl2 = bl = this.copy_last_modified != this.m_csv.getJavaFile().lastModified() || !this.last_day_check.equals(string);
        if (!bl) {
            return;
        }
        String string2 = CsvUtils.get_file(this.m_csv.getResolvedFileName(), Charset.forName(this.cfg.getEncoding()), this.m_fmt.getCsvEnclosure());
        if (string2 == null) {
            this.addAdapterError("Could not open file: " + this.m_csv.getResolvedFileName());
            return;
        }
        this.action(string2);
        this.copy_last_modified = this.m_csv.getJavaFile().lastModified();
        this.last_day_check = string;
    }

    private void url_mode() throws Exception {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String string = this.getRequestingProtocol().toLowerCase();
                    String string2 = System.getProperty(string + ".proxyHost", System.getProperty("http.proxyHost"));
                    String string3 = System.getProperty(string + ".proxyPort", System.getProperty("http.proxyPort"));
                    String string4 = System.getProperty(string + ".proxyUser");
                    String string5 = System.getProperty(string + ".proxyPassword");
                    if (this.getRequestingHost().equalsIgnoreCase(string2) && Integer.parseInt(string3) == this.getRequestingPort()) {
                        return new PasswordAuthentication(string4, string5.toCharArray());
                    }
                }
                return null;
            }
        });
        String string = CsvUtils.get_file(this.url, Charset.forName(this.cfg.getEncoding()), this.m_fmt.getCsvEnclosure());
        if (string == null) {
            this.addAdapterError("Could not read address: " + this.url);
            return;
        }
        int n = string.hashCode();
        if (n == this.url_lash_hash) {
            return;
        }
        this.action(string);
        this.url_lash_hash = n;
    }

    private void action(String string) throws Exception {
        HashedCsvFile hashedCsvFile = new HashedCsvFile(this.cfg, string, this.m_fmt, this.m_hash_salt, this.cfg.range().getRangeDate());
        this.setAdapterEvents(hashedCsvFile.generateAddAll());
    }
}

