/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.dea_ems.types;

import de.wilke.wizepanel.core.WpTimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Booking {
    private String id = "";
    private String reservation_id = "";
    private String status = "";
    private String subject = "";
    private Date start;
    private Date end;
    private String location = "";
    private String contact = "";
    private String event_type = "";
    private String change_key = "";
    private String room_id = "";
    private Map<String, String> placeholders = new HashMap<String, String>();

    public Booking(NodeList nodeList) {
        this.placeholders.put("RoomDescription", "");
        this.placeholders.put("GroupName", "");
        this.placeholders.put("GroupTypeDescription", "");
        this.placeholders.put("Room", "");
        this.placeholders.put("Building", "");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("BookingID")) {
                this.id = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("ReservationID")) {
                this.reservation_id = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("EventName")) {
                this.subject = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("TimeEventStart")) {
                this.start = WpTimeUtils.str2date((String)node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("TimeEventEnd")) {
                this.end = WpTimeUtils.str2date((String)node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("Room")) {
                this.location = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("RoomID")) {
                this.room_id = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("AddedBy")) {
                this.contact = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("DateChanged")) {
                this.change_key = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("StatusTypeID")) {
                this.status = node.getTextContent();
                continue;
            }
            if (node.getNodeName().equals("EventTypeDescription")) {
                this.event_type = node.getTextContent();
                continue;
            }
            if (!this.placeholders.containsKey(node.getNodeName())) continue;
            this.placeholders.put(node.getNodeName(), node.getTextContent());
        }
    }

    public String id() {
        return "dea-ems-" + this.id + "-" + this.reservation_id;
    }

    public String subject() {
        return this.subject;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public String location() {
        return this.location;
    }

    public String contact() {
        return this.contact;
    }

    public String eventType() {
        return this.event_type;
    }

    public int getReminderMinutesBeforeStart() {
        return 0;
    }

    public String getChangeKey() {
        return this.change_key;
    }

    public String roomID() {
        return this.room_id;
    }

    public String toString() {
        return "[" + this.id() + " | " + this.subject() + " | " + this.getStart() + "-" + this.getEnd() + " | " + this.event_type + "]";
    }

    public Map<String, String> customPlaceholders() {
        return this.placeholders;
    }

    public boolean isBooked() {
        return this.status.equals("-14");
    }
}

