/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.dea_ems.types;

import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.Booking;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.EMSResponse;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GetAllRoomBookingsResponse
extends EMSResponse {
    private final String room_id;
    private final Date from;
    private final Date to;
    private List<Booking> bookings;

    public GetAllRoomBookingsResponse(String string, Date date, Date date2) {
        super("GetAllRoomBookingsResponse");
        this.room_id = string;
        this.from = date;
        this.to = date2;
    }

    @Override
    protected String createRequest(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("    <GetAllRoomBookings xmlns=\"http://DEA.EMS.API.Web.Service/\">");
        stringBuilder.append("      <UserName>" + string + "</UserName>");
        stringBuilder.append("      <Password>" + string2 + "</Password>");
        stringBuilder.append("      <StartDate>" + this.date2str(this.from) + "</StartDate>");
        stringBuilder.append("      <EndDate>" + this.date2str(this.to) + "</EndDate>");
        stringBuilder.append("      <RoomID>" + this.room_id + "</RoomID>");
        stringBuilder.append("      <ViewComboRoomComponents>false</ViewComboRoomComponents>");
        stringBuilder.append("    </GetAllRoomBookings>");
        return stringBuilder.toString();
    }

    @Override
    protected boolean parse(String string) {
        this.bookings = new LinkedList<Booking>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList = document.getElementsByTagName("Data");
            if (nodeList.getLength() == 0) {
                return true;
            }
            Date date = new Date();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                Booking booking = new Booking(node.getChildNodes());
                if (booking.getEnd().before(date)) {
                    LogManager.getLogger(GetAllRoomBookingsResponse.class).debug("Fetched expired booking. Ignoring.");
                    continue;
                }
                if (!booking.isBooked()) continue;
                this.bookings.add(booking);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public List<Booking> bookings() {
        return this.bookings;
    }
}

