/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.energysaver;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.EnergySaverAdapter;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.util.Calendar;
import org.apache.logging.log4j.Logger;

public class EnergySaverTask
extends AdapterJob {
    private final EnergySaverAdapter adapter;
    private boolean in_period = true;

    public EnergySaverTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.adapter = (EnergySaverAdapter)abstractAdapterConfiguration;
    }

    @Override
    public void singleRun() {
        int n = Calendar.getInstance().get(11);
        this.check(n);
    }

    private void check(int n) {
        boolean bl;
        int n2 = this.adapter.getTimeFrom();
        int n3 = this.adapter.getTimeTo();
        if (n3 < n2) {
            n3 += 24;
        }
        if (n < this.adapter.getTimeFrom()) {
            n += 24;
        }
        boolean bl2 = bl = n >= n2 && n < n3;
        if (this.in_period && !bl) {
            this.logger.info("WakeUp");
            this.send_(-1);
            this.in_period = false;
        } else if (bl) {
            if (!this.in_period) {
                this.logger.info("GotoSleep");
                this.send_(this.adapter.sleepTime());
                this.in_period = true;
            } else if (n3 - n <= 1) {
                this.staggerWakeup();
            }
        }
    }

    private void send_(int n) {
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        for (String string : this.adapter.rooms()) {
            UpiTargetItem upiTargetItem = upiRoutingHandler.getTargetByName(string);
            if (upiTargetItem == null) continue;
            UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterByTargetId(upiTargetItem.getId());
            int n2 = n == -1 ? upiTargetItem.getParams().getRequiredWakeup() : n;
            try {
                DispatcherPool.getPool().sendWakeUpTime(upiRouterItem.getId(), Integer.parseInt(upiTargetItem.getId()), n2, false);
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                this.logger.error("Bad", (Throwable)wizePanelExceptions);
            }
        }
    }

    private void staggerWakeup() {
        int n = Calendar.getInstance().get(12);
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        for (String string : this.adapter.rooms()) {
            UpiTargetItem upiTargetItem = upiRoutingHandler.getTargetByName(string);
            if (upiTargetItem == null || upiTargetItem.getParams().getWakeup() / 60 <= 60 - n) continue;
            int n2 = upiTargetItem.getParams().getWakeup() / 2;
            if (n2 < upiTargetItem.getParams().getRequiredWakeup()) {
                n2 = upiTargetItem.getParams().getRequiredWakeup();
            }
            UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterByTargetId(upiTargetItem.getId());
            try {
                DispatcherPool.getPool().sendWakeUpTime(upiRouterItem.getId(), Integer.parseInt(upiTargetItem.getId()), n2, false);
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                this.logger.error("Bad", (Throwable)wizePanelExceptions);
            }
        }
    }
}

