/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.http_general;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.HttpGeneralAdapter;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.content.CalendarContent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpGeneralTask
extends AdapterJob {
    private final HttpGeneralAdapter cfg;
    private final List<String> rooms;

    public HttpGeneralTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.cfg = (HttpGeneralAdapter)abstractAdapterConfiguration;
        this.rooms = abstractAdapterConfiguration.targets();
    }

    @Override
    public void singleRun() {
        String string;
        BufferedReader bufferedReader;
        URL uRL;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            uRL = new URL(this.cfg.server());
            URLConnection uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            this.addAdapterError(MessageFormat.format("Could not connect to the server: {0}", exception.getMessage()));
            return;
        }
        try {
            uRL = new JSONArray(stringBuilder.toString());
            this.logger.debug("INPUT: " + stringBuilder);
            for (int i = 0; i < uRL.length(); ++i) {
                bufferedReader = uRL.getJSONObject(i);
                string = null;
                if (bufferedReader.has("target_name")) {
                    string = bufferedReader.getString("target_name");
                } else if (bufferedReader.has("name")) {
                    string = bufferedReader.getString("name");
                }
                if (string == null) {
                    this.addAdapterWarning("No target specified");
                    continue;
                }
                if (!this.rooms.contains(string)) {
                    this.addAdapterWarning("Target not specified in adapter: " + string);
                    continue;
                }
                JSONObject jSONObject = bufferedReader.getJSONObject("placeholders");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String string2 : JSONObject.getNames((JSONObject)jSONObject)) {
                    hashMap.put(string2, PrettyPrinter.stripHTML((String)jSONObject.getString(string2)));
                }
                this.setAdapterContent(new CalendarContent(string, this.cfg.getName(), hashMap));
            }
        }
        catch (JSONException jSONException) {
            this.addAdapterError(MessageFormat.format("Could not parse server reply: {0}", jSONException.getMessage()));
        }
    }
}

