/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.icalendar;

import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.ICalendarAdapter;
import de.wilke.wizepanel.core.adapters.types.ICalendarAdapterFormat;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarFile;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.Logger;

public class ICalendarTask
extends AdapterJob {
    private static final String FILE_EXT = ".ics";
    private final ICalendarAdapter m_adapter;
    private final ICalendarAdapterFormat m_fmt;
    private final Set<String> rooms = new HashSet<String>();
    private File watch_dir;
    private int last_dir_checksum = 0;
    private HashMap<String, CalendarFile> fileMap = new HashMap();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String last_day_check = "";

    public ICalendarTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_adapter = (ICalendarAdapter)abstractAdapterConfiguration;
        this.rooms.addAll(this.m_adapter.targets());
        this.m_fmt = this.m_adapter.getFormat();
        try {
            this.watch_dir = new File(this.m_adapter.getWatchDir());
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.getMessage());
            this.watch_dir = null;
        }
    }

    @Override
    public void singleRun() {
        Comparable<Date> comparable;
        Comparable<File> comparable22;
        if (this.watch_dir == null) {
            this.addAdapterWarning("Directory not set.");
            return;
        }
        if (!this.watch_dir.exists() || !this.watch_dir.isDirectory()) {
            this.addAdapterWarning("Directory does not exist: " + this.m_adapter.getWatchDir());
            return;
        }
        File[] fileArray = this.watch_dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(ICalendarTask.FILE_EXT);
            }
        });
        if (fileArray == null) {
            return;
        }
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        if (fileArray.length != 0) {
            for (Comparable<File> comparable22 : fileArray) {
                hashCodeBuilder.append((Object)comparable22.getName()).append(comparable22.length()).append(comparable22.lastModified());
            }
        }
        String string = this.sdf.format(new Date());
        if (hashCodeBuilder.toHashCode() == this.last_dir_checksum && string.equals(this.last_day_check)) {
            return;
        }
        this.last_dir_checksum = hashCodeBuilder.toHashCode();
        this.last_day_check = string;
        LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
        LinkedList<CalendarEvent> linkedList2 = new LinkedList<CalendarEvent>();
        comparable22 = null;
        if (this.m_adapter.deleteAfterDays() != -1) {
            if (this.m_adapter.deleteAfterDays() == 0) {
                comparable22 = new Date();
            } else {
                comparable = Calendar.getInstance();
                ((Calendar)comparable).add(5, -this.m_adapter.deleteAfterDays());
                comparable22 = ((Calendar)comparable).getTime();
            }
        }
        comparable = this.m_adapter.range().getRangeDate();
        Set<String> set = this.fileMap.keySet();
        for (File file : fileArray) {
            linkedList2.clear();
            if (this.fileMap.containsKey(file.getName())) {
                set.remove(file.getName());
                if (this.fileMap.get(file.getName()).getLastModified() == file.lastModified()) {
                    linkedList.addAll(this.fileMap.get(file.getName()).getEvents());
                    continue;
                }
            }
            try {
                CalendarFile calendarFile = new CalendarFile(file, Charset.forName(this.m_adapter.getEncoding()), false);
                int n = 0;
                for (CalendarEvent calendarEvent : calendarFile.getEvents()) {
                    if (calendarEvent.status_cancel() || calendarEvent.req_attendee_cancelled()) continue;
                    if (calendarEvent.getLocation() == null || calendarEvent.getLocation().isEmpty()) {
                        if (!this.rooms.contains("EVENTS")) continue;
                        calendarEvent.setLocation("EVENTS");
                    }
                    if (this.rooms.contains(calendarEvent.getLocation())) {
                        if (comparable22 != null && calendarEvent.isExpired((Date)comparable22)) {
                            ++n;
                            continue;
                        }
                        if (comparable == null || calendarEvent.startsBefore((Date)comparable)) {
                            calendarEvent.setAdapterName(this.m_adapter.getName());
                            calendarEvent.setTargetName(calendarEvent.getLocation());
                            if (this.m_adapter.defaultAlarm() != 0) {
                                calendarEvent.setReminderTime(this.m_adapter.defaultAlarm() * 60);
                            }
                            linkedList2.add(calendarEvent);
                            continue;
                        }
                        this.addAdapterWarning(MessageFormat.format("{0}: Too far away", file.getName()));
                        continue;
                    }
                    if (this.m_fmt.getLocationSeparatorEscaped() != "" && this.m_fmt.getLocationSeparatorEscaped() != null) {
                        String[] stringArray = calendarEvent.getLocation().split(this.m_fmt.getLocationSeparatorEscaped());
                        if (comparable22 == null || !calendarEvent.isExpired((Date)comparable22)) {
                            if (stringArray.length <= 1) continue;
                            for (String string2 : stringArray) {
                                if (string2 == "" || !this.rooms.contains(string2)) continue;
                                if (comparable == null || calendarEvent.startsBefore((Date)comparable)) {
                                    CalendarEvent calendarEvent2 = new CalendarEvent(calendarEvent);
                                    calendarEvent2.setAdapterName(this.m_adapter.getName());
                                    calendarEvent2.setLocation(string2);
                                    calendarEvent2.setUID(string2 + calendarEvent2.getUID());
                                    calendarEvent2.setTargetName(string2);
                                    if (this.m_adapter.defaultAlarm() != 0) {
                                        calendarEvent2.setReminderTime(this.m_adapter.defaultAlarm() * 60);
                                    }
                                    linkedList2.add(calendarEvent2);
                                    hashCodeBuilder.append((Object)calendarEvent2.getUID()).append(calendarEvent2.getLastModified().getTime());
                                    continue;
                                }
                                this.addAdapterWarning(MessageFormat.format("{0}: Too far away", file.getName()));
                            }
                            continue;
                        }
                        ++n;
                        continue;
                    }
                    ++n;
                    this.addAdapterWarning("Ignoring location: " + calendarEvent.getLocation());
                }
                if (n == calendarFile.getEventCount()) {
                    this.logger.debug(MessageFormat.format("Deleting file: {0}", file.getName()));
                    this.fileMap.remove(file.getName());
                    set.remove(file.getName());
                    file.delete();
                    continue;
                }
                calendarFile.set_events(linkedList2);
                this.fileMap.put(file.getName(), calendarFile);
                linkedList.addAll(linkedList2);
            }
            catch (Exception exception) {
                this.addAdapterError(MessageFormat.format("{0}: {1}", file.getName(), exception.getMessage()));
            }
        }
        if (set.size() > 0) {
            // empty if block
        }
        this.setAdapterEvents(linkedList);
    }
}

