/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews;

import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarEvent;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarFolder;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSItemBase;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class EWSResponse {
    private static final String XML_RESPONSE_CODE = "m:ResponseCode";
    private static final String XML_MESSAGE_TEXT = "m:MessageText";
    private static final String NO_ERROR = "NoError";
    private String errorString = "NoError";
    private String responseMessage = null;
    private String responseCode = null;
    private final List<EWSItemBase> m_items = new ArrayList<EWSItemBase>();
    private final List<EWSItemBase> m_valid_items = new ArrayList<EWSItemBase>();

    public EWSResponse() {
        this.m_valid_items.add(new EWSCalendarEvent());
        this.m_valid_items.add(new EWSCalendarFolder());
    }

    public EWSResponse(String string) {
        this();
        this.parseXML(string);
    }

    public EWSResponse(String string, int n, String string2) {
        this();
        this.errorString = string;
        this.responseCode = String.valueOf(n);
        this.responseMessage = string2;
    }

    public boolean hasError() {
        return !this.responseCode.equals(NO_ERROR);
    }

    private EWSResponse parseXML(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
            DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
            Node node = document.getFirstChild();
            NodeIterator nodeIterator = documentTraversal.createNodeIterator(node, 1, new NodeFilter(){

                @Override
                public short acceptNode(Node node) {
                    if (node.getNodeName().equals(EWSResponse.XML_RESPONSE_CODE) || node.getNodeName().equals(EWSResponse.XML_MESSAGE_TEXT)) {
                        return 1;
                    }
                    for (EWSItemBase eWSItemBase : EWSResponse.this.m_valid_items) {
                        if (!eWSItemBase.isMe(node)) continue;
                        return 1;
                    }
                    return 3;
                }
            }, true);
            Element element = null;
            while ((element = (Element)nodeIterator.nextNode()) != null) {
                if (element.getNodeName().equals(XML_RESPONSE_CODE)) {
                    this.responseCode = element.getTextContent();
                    continue;
                }
                if (element.getNodeName().equals(XML_MESSAGE_TEXT)) {
                    this.responseMessage = element.getTextContent();
                    continue;
                }
                for (EWSItemBase eWSItemBase : this.m_valid_items) {
                    if (!eWSItemBase.isMe(element)) continue;
                    this.parseNode(element);
                }
            }
        }
        catch (Exception exception) {
            this.setVarsFromException(exception);
        }
        return null;
    }

    private void parseNode(Element element) {
        DocumentTraversal documentTraversal = (DocumentTraversal)((Object)element.getOwnerDocument());
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(element, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                for (EWSItemBase eWSItemBase : EWSResponse.this.m_valid_items) {
                    if (!eWSItemBase.isMine(node.getNodeName())) continue;
                    return 1;
                }
                return 3;
            }
        }, true);
        Element element2 = null;
        EWSItemBase eWSItemBase = null;
        block0: while ((element2 = (Element)nodeIterator.nextNode()) != null) {
            for (EWSItemBase eWSItemBase2 : this.m_valid_items) {
                if (!eWSItemBase2.isMe(element) || !eWSItemBase2.doSwallow(element2)) continue;
                eWSItemBase = eWSItemBase2;
                continue block0;
            }
        }
        if (eWSItemBase != null) {
            this.m_items.add(eWSItemBase.shallowCopy());
        }
    }

    private void setVarsFromException(Exception exception) {
        this.errorString = exception.getClass().getName();
        this.responseCode = exception.getMessage();
        this.responseMessage = exception.getStackTrace().toString();
    }

    protected void setErrorString(String string) {
        this.errorString = string;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public List<EWSItemBase> getItems() {
        return this.m_items;
    }

    public boolean equals(Object object) {
        if (object instanceof EWSResponse) {
            EWSResponse eWSResponse = (EWSResponse)object;
            if (eWSResponse.getItems().size() == this.m_items.size()) {
                for (EWSItemBase eWSItemBase : this.m_items) {
                    if (eWSResponse.getItems().contains(eWSItemBase)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.equals(object);
    }
}

