/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews;

import de.wilke.wizepanel.eventmanager.adapters.ms_ews.EWSResponse;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.ExchangeUtils;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.SOAPRequest;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarEvent;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSItemBase;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSUTCTime;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExchangeService {
    private static final Logger m_logger = LogManager.getLogger(ExchangeService.class);
    private final String host;
    private final String username;
    private final String password;
    private final Map<String, EWSResponse> last_folder_items = new HashMap<String, EWSResponse>();
    private final Map<String, List<EWSCalendarEvent>> cached_folder_reply = new HashMap<String, List<EWSCalendarEvent>>();
    private final Map<Integer, EWSResponse> response_cache = new HashMap<Integer, EWSResponse>();

    public ExchangeService(String string, String string2, String string3) {
        this.host = string;
        this.username = string2;
        this.password = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EWSResponse makeRequest(SOAPRequest sOAPRequest) throws MalformedURLException, ProtocolException, IOException {
        this.setAuthenticator();
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        URL uRL = new URL(this.host);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-type", "text/xml; charset=utf-8");
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setUseCaches(false);
        m_logger.debug("REQUEST: " + this.formatXML(sOAPRequest.getMessage(), false));
        try (Object object = new PrintWriter((Writer)new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8"), true);){
            ((PrintWriter)object).print(sOAPRequest.getMessage());
            ((PrintWriter)object).flush();
        }
        try {
            Object object;
            if (httpURLConnection.getResponseCode() != 200) {
                object = String.format("Connection error: %1$s - %2$s", httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage());
                m_logger.error((String)object);
                throw new ProtocolException((String)object);
            }
            object = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));){
                while ((object = bufferedReader.readLine()) != null) {
                    ((StringBuilder)object).append((String)object);
                }
            }
            int n = ((StringBuilder)object).toString().hashCode();
            if (this.response_cache.containsKey(n)) {
                m_logger.debug("REPLY: NOT CHANGED");
                object = this.response_cache.get(n);
                return object;
            }
            object = new EWSResponse(((StringBuilder)object).toString());
            if (((EWSResponse)object).hasError()) {
                throw new ProtocolException(((EWSResponse)object).getResponseCode() + " [" + ((EWSResponse)object).getResponseMessage() + "]");
            }
            this.response_cache.put(n, (EWSResponse)object);
            m_logger.debug("REPLY: " + this.formatXML(((StringBuilder)object).toString(), false));
            Object object2 = object;
            return object2;
        }
        finally {
            httpURLConnection.disconnect();
            httpURLConnection.getInputStream().close();
        }
    }

    private void setAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String string = this.getRequestingProtocol().toLowerCase();
                    String string2 = System.getProperty(string + ".proxyHost", System.getProperty("http.proxyHost"));
                    String string3 = System.getProperty(string + ".proxyPort", System.getProperty("http.proxyPort"));
                    String string4 = System.getProperty(string + ".proxyUser");
                    String string5 = System.getProperty(string + ".proxyPassword");
                    if (this.getRequestingHost().equalsIgnoreCase(string2) && Integer.parseInt(string3) == this.getRequestingPort()) {
                        return new PasswordAuthentication(string4, string5.toCharArray());
                    }
                } else {
                    return new PasswordAuthentication(ExchangeService.this.username, ExchangeService.this.password.toCharArray());
                }
                return null;
            }
        });
    }

    public String getDomain() {
        try {
            return new URL(this.host).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String formatXML(String string, boolean bl) {
        if (bl) {
            String[] stringArray = string.replaceAll("><", ">\n<").split("\\n");
            Object object = "";
            Object object2 = "";
            for (String string2 : stringArray) {
                boolean bl2 = false;
                if (bl && string2.contains("</") && ((String)object2).length() > 0) {
                    object2 = ((String)object2).substring(1);
                    bl2 = true;
                }
                object = (String)object + (String)object2 + string2 + "\n";
                if (!bl || bl2 || string2.contains("/>")) continue;
                object2 = (String)object2 + "\t";
            }
            return object;
        }
        return string;
    }

    public List<EWSCalendarEvent> get_events(String string, EWSUTCTime eWSUTCTime, EWSUTCTime eWSUTCTime2) throws Exception {
        try {
            return this.get_events_SP1_raw(this, string, eWSUTCTime, eWSUTCTime2);
        }
        catch (Exception exception) {
            m_logger.error("Bad", (Throwable)exception);
            throw new Exception(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    private List<EWSCalendarEvent> get_events_SP1_raw(ExchangeService exchangeService, String string, EWSUTCTime eWSUTCTime, EWSUTCTime eWSUTCTime2) throws MalformedURLException, ProtocolException, IOException {
        eWSUTCTime2 = eWSUTCTime2.addMillis(60000L);
        SOAPRequest sOAPRequest = new SOAPRequest(ExchangeUtils.get_find_items_SP1_request(string, true, eWSUTCTime, eWSUTCTime2, true), true);
        EWSResponse eWSResponse = exchangeService.makeRequest(sOAPRequest);
        if (this.last_folder_items.containsKey(string) && this.last_folder_items.get(string).equals(eWSResponse)) {
            return this.cached_folder_reply.get(string);
        }
        ArrayList<EWSCalendarEvent> arrayList = new ArrayList<EWSCalendarEvent>();
        for (EWSItemBase eWSItemBase : eWSResponse.getItems()) {
            EWSCalendarEvent eWSCalendarEvent = (EWSCalendarEvent)eWSItemBase;
            SOAPRequest sOAPRequest2 = new SOAPRequest(ExchangeUtils.get_getitem_SP1_request(eWSCalendarEvent.getId(), eWSCalendarEvent.getChangeKey(), true), true);
            EWSResponse eWSResponse2 = exchangeService.makeRequest(sOAPRequest2);
            for (EWSItemBase eWSItemBase2 : eWSResponse2.getItems()) {
                EWSCalendarEvent eWSCalendarEvent2 = (EWSCalendarEvent)eWSItemBase2;
                arrayList.add(eWSCalendarEvent2);
            }
        }
        this.last_folder_items.put(string, eWSResponse);
        this.cached_folder_reply.put(string, arrayList);
        return arrayList;
    }
}

