/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews;

import de.wilke.wizepanel.eventmanager.adapters.ms_ews.EWSResponse;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.ExchangeService;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.SOAPRequest;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarEvent;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarFolder;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSItemBase;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSUTCTime;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ExchangeUtils {
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    private static final Logger m_logger = LogManager.getLogger(ExchangeUtils.class);

    ExchangeUtils() {
    }

    private static String get_findfolder_request(FolderType folderType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<FindFolder Traversal=\"Deep\" xmlns=\"http://schemas.microsoft.com/exchange/services/2006/messages\">\n");
        stringBuilder.append("<FolderShape>\n");
        stringBuilder.append("\t<t:BaseShape>IdOnly</t:BaseShape>\n");
        stringBuilder.append("\t<t:AdditionalProperties>\n");
        stringBuilder.append("\t\t<t:FieldURI FieldURI=\"folder:DisplayName\" />\n");
        stringBuilder.append("\t</t:AdditionalProperties>\n");
        stringBuilder.append("</FolderShape>\n");
        stringBuilder.append("<ParentFolderIds>\n");
        stringBuilder.append("\t<t:DistinguishedFolderId Id=\"" + folderType.getXML() + "\"/>\n");
        stringBuilder.append("</ParentFolderIds>\n");
        stringBuilder.append("</FindFolder>\n");
        return stringBuilder.toString();
    }

    public static void print_debug_events(List<EWSCalendarEvent> list) {
        if (list == null) {
            System.out.println((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"#events: null"})));
        } else {
            System.out.println("#events: " + list.size());
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (EWSCalendarEvent object : list) {
                int n = 0;
                if (hashMap.containsKey(object.getId())) {
                    n = (Integer)hashMap.get(object.getId());
                }
                hashMap.put(object.getId(), n + 1);
                System.out.println("+ " + object.getId());
                System.out.println("  - " + object.getSubject());
                System.out.println("  - " + object.getLocation());
                System.out.println("  - " + object.getBody());
                System.out.println("  - " + object.getStart());
                System.out.println("  - " + object.getEnd());
            }
            System.out.println();
            System.out.println("Summary:");
            for (String string : hashMap.keySet()) {
                System.out.println(" + [#" + hashMap.get(string) + "] " + string);
            }
        }
    }

    public static String get_folder_id(ExchangeService exchangeService, String string) {
        List<EWSCalendarFolder> list = ExchangeUtils.get_all_folders(exchangeService);
        for (EWSCalendarFolder eWSCalendarFolder : list) {
            if (!eWSCalendarFolder.getDisplayName().equals(string)) continue;
            return eWSCalendarFolder.getId();
        }
        return null;
    }

    public static List<EWSCalendarFolder> get_all_folders(ExchangeService exchangeService) {
        SOAPRequest sOAPRequest = new SOAPRequest(ExchangeUtils.get_findfolder_request(FolderType.Calendar));
        try {
            EWSResponse eWSResponse = exchangeService.makeRequest(sOAPRequest);
            m_logger.debug("resp.err.string: " + eWSResponse.getErrorString());
            m_logger.debug("resp.folderlist: #" + eWSResponse.getItems().size());
            ArrayList<EWSCalendarFolder> arrayList = new ArrayList<EWSCalendarFolder>();
            for (EWSItemBase eWSItemBase : eWSResponse.getItems()) {
                EWSCalendarFolder eWSCalendarFolder = (EWSCalendarFolder)eWSItemBase;
                arrayList.add(eWSCalendarFolder);
                m_logger.debug("         folder: " + eWSCalendarFolder.getDisplayName());
            }
            return arrayList;
        }
        catch (IOException iOException) {
            m_logger.error((Object)iOException);
            iOException.printStackTrace();
            m_logger.debug("get-all-folders: returned null");
            return null;
        }
    }

    public static String get_find_items_SP1_request(String string, boolean bl, EWSUTCTime eWSUTCTime, EWSUTCTime eWSUTCTime2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:m=\"http://schemas.microsoft.com/exchange/services/2006/messages\" xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
            stringBuilder.append("<soap:Header>");
            stringBuilder.append("<t:RequestServerVersion Version=\"Exchange2007_SP1\" />");
            stringBuilder.append("</soap:Header>");
            stringBuilder.append("<soap:Body>");
        }
        stringBuilder.append("<m:FindItem Traversal=\"Shallow\">");
        stringBuilder.append("<m:ItemShape>");
        stringBuilder.append("<t:BaseShape>IdOnly</t:BaseShape>");
        stringBuilder.append("<t:AdditionalProperties>");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:Start\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:End\" />");
        stringBuilder.append("</t:AdditionalProperties>");
        stringBuilder.append("</m:ItemShape>");
        if (bl && eWSUTCTime != null && eWSUTCTime2 != null) {
            stringBuilder.append("<m:CalendarView StartDate=\"" + eWSUTCTime.toString() + "\" EndDate=\"" + eWSUTCTime2.toString() + "\" />");
        } else {
            stringBuilder.append("<m:IndexedPageItemView Offset=\"0\" BasePoint=\"Beginning\" />");
            if (eWSUTCTime != null && eWSUTCTime2 != null) {
                stringBuilder.append("<m:Restriction>");
                stringBuilder.append("<t:And>");
                stringBuilder.append("<t:IsGreaterThanOrEqualTo>");
                stringBuilder.append("<t:FieldURI FieldURI=\"calendar:Start\" />");
                stringBuilder.append("<t:FieldURIOrConstant>");
                stringBuilder.append("<t:Constant Value=\"" + eWSUTCTime.toString() + "\" />");
                stringBuilder.append("</t:FieldURIOrConstant>");
                stringBuilder.append("</t:IsGreaterThanOrEqualTo>");
                stringBuilder.append("<t:IsLessThan>");
                stringBuilder.append("<t:FieldURI FieldURI=\"calendar:Start\" />");
                stringBuilder.append("<t:FieldURIOrConstant>");
                stringBuilder.append("<t:Constant Value=\"" + eWSUTCTime2.toString() + "\" />");
                stringBuilder.append("</t:FieldURIOrConstant>");
                stringBuilder.append("</t:IsLessThan>");
                stringBuilder.append("</t:And>");
                stringBuilder.append("</m:Restriction>");
            }
            stringBuilder.append("<m:SortOrder>");
            stringBuilder.append("  <t:FieldOrder Order=\"Ascending\">");
            stringBuilder.append("    <t:FieldURI FieldURI=\"calendar:Start\" />");
            stringBuilder.append("  </t:FieldOrder>");
            stringBuilder.append("</m:SortOrder>");
        }
        stringBuilder.append("<m:ParentFolderIds>");
        stringBuilder.append("  <t:DistinguishedFolderId Id=\"calendar\">");
        stringBuilder.append("    <t:Mailbox>");
        stringBuilder.append("      <t:EmailAddress>" + string + "</t:EmailAddress>");
        stringBuilder.append("    </t:Mailbox>");
        stringBuilder.append("  </t:DistinguishedFolderId>");
        stringBuilder.append("</m:ParentFolderIds>");
        stringBuilder.append("</m:FindItem>");
        if (bl2) {
            stringBuilder.append("</soap:Body>");
            stringBuilder.append("</soap:Envelope>");
        }
        return stringBuilder.toString();
    }

    public static String get_getitem_SP1_request(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:m=\"http://schemas.microsoft.com/exchange/services/2006/messages\" xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        }
        stringBuilder.append("<soap:Header>");
        stringBuilder.append("<t:RequestServerVersion Version=\"Exchange2007_SP1\" />");
        stringBuilder.append("</soap:Header>");
        stringBuilder.append("<soap:Body>");
        stringBuilder.append("<m:GetItem>");
        stringBuilder.append("<m:ItemShape>");
        stringBuilder.append("<t:BaseShape>IdOnly</t:BaseShape>");
        stringBuilder.append("<t:AdditionalProperties>\n");
        stringBuilder.append("<t:FieldURI FieldURI=\"item:Subject\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:Location\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"item:Body\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:Start\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:End\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:Organizer\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"item:Sensitivity\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"item:ReminderMinutesBeforeStart\" />");
        stringBuilder.append("<t:FieldURI FieldURI=\"calendar:LegacyFreeBusyStatus\" />");
        stringBuilder.append("</t:AdditionalProperties>\n");
        stringBuilder.append("</m:ItemShape>");
        stringBuilder.append("<m:ItemIds>");
        stringBuilder.append("<t:ItemId Id=\"" + string + "\" ChangeKey=\"" + string2 + "\" />");
        stringBuilder.append("</m:ItemIds>");
        stringBuilder.append("</m:GetItem>");
        if (bl) {
            stringBuilder.append("</soap:Body>");
            stringBuilder.append("</soap:Envelope>");
        }
        return stringBuilder.toString();
    }

    public static enum FolderType {
        Calendar("calendar"),
        Root("root");

        private final String xml_string;

        private FolderType(String string2) {
            this.xml_string = string2;
        }

        public String getXML() {
            return this.xml_string;
        }
    }
}

