/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.ExchangeEWSAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.ExchangeService;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarEvent;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSUTCTime;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.logging.log4j.Logger;

public class MSEWSTask
extends AdapterJob {
    private final ExchangeEWSAdapter m_cfg;
    private final ExchangeService m_ews;
    private String historyDuration;
    private final List<String> m_folders;
    private EWSUTCTime from;
    private EWSUTCTime to;
    private int last_run_hashcode = 0;

    public MSEWSTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (ExchangeEWSAdapter)abstractAdapterConfiguration;
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        this.m_folders = abstractAdapterConfiguration.targets();
        if (this.m_folders == null || this.m_folders.size() == 0) {
            this.m_ews = null;
        } else {
            this.m_ews = new ExchangeService(this.m_cfg.server(), this.m_cfg.user(), this.m_cfg.password());
            logger.info("Installing new Exchange Web Services interface: " + this.m_ews.getDomain() + " for folders: " + this.m_folders + " [private: " + this.m_cfg.privateEventSummary() + "]");
        }
        if (this.m_ews == null) {
            this.stop();
        }
    }

    @Override
    public synchronized void singleRun() {
        Object object;
        Object exception;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(this.historyDuration));
        this.from = new EWSUTCTime(calendar);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.m_cfg.range().getRangeDate());
        this.to = new EWSUTCTime(calendar2);
        this.logger.info("GetEvents: " + this.from.toString() + " - " + this.to.toString());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        for (String object3 : this.m_folders) {
            Object object2;
            try {
                object2 = this.m_ews.get_events(object3, this.from, this.to);
                this.logger.info("Folder[" + object3 + "]: received events: #" + object2.size());
            }
            catch (Exception exception2) {
                this.addAdapterError(MessageFormat.format("Mailbox[" + object3 + "]: {0}", exception2.getMessage()));
                continue;
            }
            if (object2.size() == 0) continue;
            exception = object2.iterator();
            while (exception.hasNext()) {
                object = (EWSCalendarEvent)exception.next();
                n += ((EWSCalendarEvent)object).getId().hashCode() + ((EWSCalendarEvent)object).getChangeKey().hashCode();
            }
            hashMap.put(object3, object2);
        }
        if (this.last_run_hashcode == 0 || this.last_run_hashcode != n) {
            LinkedList linkedList = new LinkedList();
            for (Object object2 : hashMap.keySet()) {
                exception = (List)hashMap.get(object2);
                object = exception.iterator();
                while (object.hasNext()) {
                    EWSCalendarEvent eWSCalendarEvent = (EWSCalendarEvent)object.next();
                    CalendarEvent calendarEvent = this.create_event(eWSCalendarEvent, (String)object2);
                    if (calendarEvent == null) {
                        n = 0;
                        continue;
                    }
                    linkedList.add(calendarEvent);
                }
            }
            this.setAdapterEvents(linkedList);
            this.last_run_hashcode = n;
        }
    }

    private CalendarEvent create_event(EWSCalendarEvent eWSCalendarEvent, String string) {
        DateTime dateTime = new DateTime(eWSCalendarEvent.getStart());
        dateTime.setUtc(true);
        DateTime dateTime2 = new DateTime(eWSCalendarEvent.getEnd());
        dateTime2.setUtc(true);
        boolean bl = this.m_cfg.privateEventSummary() != null && !this.m_cfg.privateEventSummary().isEmpty() && eWSCalendarEvent.isPrivate();
        this.logger.info("Creating new event at: " + WpTimeUtils.date2str((java.util.Date)eWSCalendarEvent.getStart()) + " | private: " + bl + "|" + eWSCalendarEvent.isPrivate());
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
        if (bl) {
            xWizePanel.add(XWizePanel.WPDataItem.PrivateEventSummary, this.m_cfg.privateEventSummary());
        }
        VAlarm vAlarm = null;
        if (!this.m_cfg.ignoreAlarm() && eWSCalendarEvent.getReminderMinutesBeforeStart() > 0) {
            vAlarm = new VAlarm();
            vAlarm.getProperties().add((Property)Action.DISPLAY);
            vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + eWSCalendarEvent.getReminderMinutesBeforeStart() + "M")));
            vAlarm.getProperties().add((Property)new Description("Alarma!"));
        }
        Organizer organizer = null;
        if (eWSCalendarEvent.getOrganizerMail() != null) {
            try {
                organizer = new Organizer("MAILTO:" + eWSCalendarEvent.getOrganizerMail());
                if (eWSCalendarEvent.getOrganizerName() != null) {
                    organizer.getParameters().add((Parameter)new Cn(eWSCalendarEvent.getOrganizerName()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, eWSCalendarEvent.getSubject());
        vEvent.getProperties().add((Property)new Uid(eWSCalendarEvent.getId()));
        vEvent.getProperties().add((Property)new Location(eWSCalendarEvent.getLocation()));
        vEvent.getProperties().add((Property)new Description(PrettyPrinter.stripHTML((String)eWSCalendarEvent.getBody())));
        vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
        if (vAlarm != null) {
            vEvent.getAlarms().add((Component)vAlarm);
        }
        if (organizer != null) {
            vEvent.getProperties().add((Property)organizer);
        }
        if (bl) {
            vEvent.getProperties().add((Property)Clazz.PRIVATE);
        }
        try {
            return new CalendarEvent(vEvent, true);
        }
        catch (Exception exception) {
            this.addAdapterError(exception.getMessage());
            return null;
        }
    }
}

