/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews;

public class SOAPRequest {
    public static final String TYPES_URI = "http://schemas.microsoft.com/exchange/services/2006/types";
    public static final String MESSAGES_URI = "http://schemas.microsoft.com/exchange/services/2006/messages";
    public static final String SOAP_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XSD_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final String soapBody;
    private final String emailAddress;
    private boolean m_raw = false;

    public SOAPRequest(String string) {
        this(string, null);
    }

    public SOAPRequest(String string, String string2) {
        this.soapBody = string;
        this.emailAddress = string2;
    }

    public SOAPRequest(String string, boolean bl) {
        this(string, null);
        this.m_raw = bl;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.m_raw) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            stringBuilder.append(String.format("<soap:Envelope xmlns:xsi=\"%1$s\"\n", XSI_URI));
            stringBuilder.append(String.format("               xmlns:xsd=\"%1$s\"\n", "http://schemas.xmlsoap.org/soap/envelope/"));
            stringBuilder.append(String.format("               xmlns:soap=\"%1$s\"\n", "http://schemas.xmlsoap.org/soap/envelope/"));
            stringBuilder.append(String.format("               xmlns=\"%1$s\"\n", MESSAGES_URI));
            stringBuilder.append(String.format("               xmlns:t=\"%1$s\">\n", TYPES_URI));
            stringBuilder.append("    <soap:Header>\n");
            if (this.emailAddress != null) {
                stringBuilder.append(this.getImpersonation());
            }
            stringBuilder.append("    </soap:Header>\n");
            stringBuilder.append("<soap:Body>\n");
        }
        stringBuilder.append(this.soapBody);
        if (!this.m_raw) {
            stringBuilder.append("</soap:Body>\n");
            stringBuilder.append("</soap:Envelope>\n");
        }
        return stringBuilder.toString();
    }

    private String getImpersonation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("        <t:ExchangeImpersonation>\n");
        stringBuilder.append("            <t:ConnectingSID>\n");
        stringBuilder.append("                <t:PrimarySmtpAddress>");
        stringBuilder.append(this.emailAddress);
        stringBuilder.append("</t:PrimarySmtpAddress>\n");
        stringBuilder.append("            </t:ConnectingSID>\n");
        stringBuilder.append("        </t:ExchangeImpersonation>\n");
        return stringBuilder.toString();
    }
}

