/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.ExchangeEMailAdapter;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.MailTaskConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.logging.log4j.Logger;

public class ExchangeMailTask
extends AdapterJob {
    private static final String MIME_TYPE = "text/calendar";
    private static final String ICS_FILENAME_PREFIX = "aaa";
    private final ExchangeEMailAdapter m_cfg;

    public ExchangeMailTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (ExchangeEMailAdapter)abstractAdapterConfiguration;
        logger.info("Installing new Exchange Mail adapter: " + this.m_cfg.user() + "@" + this.m_cfg.server());
    }

    private void printMessage(Message message) {
        try {
            String string = ((InternetAddress)message.getFrom()[0]).getAddress();
            System.out.println("   FROM: " + string);
            Address[] addressArray = message.getRecipients(Message.RecipientType.TO);
            if (addressArray != null) {
                for (Address address : addressArray) {
                    System.out.println("    TO: " + ((InternetAddress)address).getAddress());
                }
            }
            String string2 = message.getSubject();
            System.out.println("SUBJECT: " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void singleRun() {
        try {
            this.download_mails();
        }
        catch (Exception exception) {
            this.addAdapterWarning(exception.getMessage());
        }
    }

    private boolean download_mails() throws Exception {
        MailTaskConnection mailTaskConnection = new MailTaskConnection(this.m_cfg.server(), this.m_cfg.user(), this.m_cfg.password());
        mailTaskConnection.open_mailbox();
        int n = 0;
        boolean bl = false;
        for (Message message : mailTaskConnection.getMessages()) {
            try {
                Object object = message.getContent();
                String string = null;
                if (object instanceof Multipart) {
                    Multipart multipart = (Multipart)object;
                    for (int i = 0; i < multipart.getCount() && (string = this.extract_ics((Part)multipart.getBodyPart(i))) == null; ++i) {
                    }
                } else {
                    string = this.extract_ics((Part)message);
                }
                if (string == null) {
                    this.logger.error("Hm, no ICS found!");
                    continue;
                }
                string = this.patch_outlook_ics(string);
                if ((string = this.patch_x_wizepanel(string)) == null || !this.make_file(string, "" + n)) {
                    this.logger.error("Hm, should be some valid ICS (length: " + (Serializable)(string == null ? "null" : Integer.valueOf(string.length())) + ")");
                } else {
                    this.logger.debug("Created ICS file.");
                    message.setFlag(Flags.Flag.DELETED, true);
                    bl = true;
                }
                ++n;
            }
            catch (MessagingException messagingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        mailTaskConnection.close_mailbox(true);
        return bl;
    }

    private String patch_x_wizepanel(String string) {
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, this.m_cfg.user());
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
        if (this.m_cfg.privateEventSummary() != null) {
            xWizePanel.add(XWizePanel.WPDataItem.PrivateEventSummary, this.m_cfg.privateEventSummary());
        }
        xWizePanel.add(XWizePanel.WPDataItem.SuppressEventNotChangedWarnings, true);
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        try {
            Calendar calendar = calendarBuilder.build((Reader)new StringReader(string));
            for (Object e : calendar.getComponents("VEVENT")) {
                VEvent vEvent = (VEvent)e;
                vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
            }
            return calendar.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String patch_outlook_ics(String string) {
        String[] stringArray = string.split("\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.startsWith("RRULE")) {
                string2 = string2.replaceAll(" ", "");
            }
            stringArray[i] = string2;
        }
        return WpUtils.implode((String)"\n", (String[])stringArray);
    }

    private String extract_ics(Part part) {
        try {
            String string = part.getContentType().toLowerCase();
            if (string.startsWith(MIME_TYPE)) {
                int n;
                InputStream inputStream = part.getInputStream();
                char[] cArray = new char[65536];
                StringBuilder stringBuilder = new StringBuilder();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                do {
                    if ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) <= 0) continue;
                    stringBuilder.append(cArray, 0, n);
                } while (n >= 0);
                return stringBuilder.toString();
            }
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean make_file(String string, String string2) {
        OutputStreamWriter outputStreamWriter;
        File file;
        try {
            file = File.createTempFile(ICS_FILENAME_PREFIX, string2);
            outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            try {
                outputStreamWriter.write(string);
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        outputStreamWriter = new DateTime(true);
        File file2 = ExchangeMailTask.getUniqueSpoolICSFile("aaa-" + outputStreamWriter.toString() + ".ics");
        try {
            WpFileUtils.moveFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static File getUniqueSpoolICSFile(String string) {
        String string2 = java.util.Calendar.getInstance().getTime().toString().replaceAll("[^a-zA-Z0-9]", "");
        String string3 = WpSystemLocator.getLocator().getEventsDir() + "/spool/" + string + "-" + string2 + ".ics";
        return WpFileUtils.getUniqueFile((String)string3);
    }
}

