/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.locator.IWpLocatorPropertyType;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.Cfg;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.FileComparator;
import de.wilke.wizepanel.eventmanager.cache.DeleteEventException;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEventException;
import de.wilke.wizepanel.eventmanager.ical.CalendarFile;
import de.wilke.wizepanel.jms.session.WpSession;
import de.wilke.wizepanel.jms.session.WpSessionAttributes;
import de.wilke.wizepanel.jms.session.WpSessionEvent;
import de.wilke.wizepanel.jms.session.WpSessionResource;
import de.wilke.wizepanel.jms.session.WpSessionResponse;
import de.wilke.wizepanel.sessions.Communicator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public class ICS {
    private final Logger logger;
    private final EventScheduler scheduler;
    private final Map<String, CalendarEvent> m_events = new ConcurrentHashMap<String, CalendarEvent>();

    public ICS(EventScheduler eventScheduler, Logger logger) {
        this.logger = logger;
        this.scheduler = eventScheduler;
        File file = new File(Cfg.getEventDir());
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".ics");
            }
        });
        Arrays.sort(fileArray, new FileComparator());
        for (int i = 0; i < fileArray.length; ++i) {
            this.addFile(fileArray[i].getName());
        }
    }

    public synchronized void cleanup() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
        File file = new File(Cfg.getEventDir());
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".ics");
            }
        });
        HashSet<String> hashSet = new HashSet<String>();
        if (fileArray != null && fileArray.length != 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                hashSet.add(fileArray[i].getName());
            }
        }
        Iterator<String> iterator = this.m_events.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            CalendarEvent calendarEvent = this.m_events.get(string);
            if (!hashSet.contains(string)) {
                iterator.remove();
                this.logger.warn("Event file {} disappeared. Removed!", (Object)string);
                this.scheduler.removeByUID(calendarEvent.getUID());
                continue;
            }
            if (!calendarEvent.isExpired(calendar.getTime())) continue;
            iterator.remove();
            this.moveToDone(string);
            this.scheduler.removeByUID(calendarEvent.getUID());
        }
    }

    private void removeByUID(String string) {
        Iterator<String> iterator = this.m_events.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            CalendarEvent calendarEvent = this.m_events.get(string2);
            if (!calendarEvent.getUID().equals(string)) continue;
            iterator.remove();
            this.moveToDone(string2);
            this.scheduler.removeByUID(string);
            break;
        }
    }

    private CalendarEvent getEventByUID(String string) {
        for (String string2 : this.m_events.keySet()) {
            CalendarEvent calendarEvent = this.m_events.get(string2);
            if (!calendarEvent.getUID().equals(string)) continue;
            return calendarEvent;
        }
        return null;
    }

    public synchronized void addFile(String string) {
        block9: {
            try {
                this.logger.debug("NEW FILE: " + string);
                File file = new File(Cfg.getEventDir() + "/" + string);
                CalendarFile calendarFile = new CalendarFile(file, Charset.forName("UTF-8"), true);
                for (CalendarEvent calendarEvent : calendarFile.getEvents()) {
                    CalendarEvent calendarEvent2 = this.getEventByUID(calendarEvent.getUID());
                    if (calendarEvent2 != null) {
                        if (calendarEvent2.equals(calendarEvent)) {
                            throw new CalendarEventException(WizePanelExceptions.ErrorCodes.WP_EM_EVENT_NOT_CHANGED, !calendarEvent.suppressEventNotChangedEvents());
                        }
                        this.removeByUID(calendarEvent2.getUID());
                        this.scheduler.removeByUID(calendarEvent2.getUID());
                    }
                    if (!WpSystemLocator.getLocator().getBoolean((IWpLocatorPropertyType)WpSystemLocator.WpSystemLocatorPropType.EVENTS_ALLOW_EXPIRED) && calendarEvent.isExpired()) {
                        throw new CalendarEventException(WizePanelExceptions.ErrorCodes.WP_EM_EXPIRED_EVENT, true);
                    }
                    this.m_events.put(string, calendarEvent);
                    this.scheduler.addEvent(calendarEvent);
                }
                this.logger.info("Added file to cache: " + string);
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                String string2 = this.moveToDone(string);
                String string3 = this.createLogFilename(string, string2);
                this.send_to_queue(string3, WpSessionAttributes.SESSION_TAG.EXTERN, null, null, wizePanelExceptions);
                this.logger.error("WpException in " + string3 + ": " + wizePanelExceptions.getMessage());
            }
            catch (CalendarEventException calendarEventException) {
                String string4 = this.moveToDone(string);
                String string5 = this.createLogFilename(string, string4);
                if (calendarEventException.createSession()) {
                    this.send_to_queue(string5, WpSessionAttributes.SESSION_TAG.EXTERN, null, null, new WizePanelExceptions(calendarEventException.getError()));
                }
                this.logger.warn("CalException in " + string5 + ": " + calendarEventException.toString());
            }
            catch (DeleteEventException deleteEventException) {
                String string6 = this.moveToDone(string);
                String string7 = this.createLogFilename(string, string6);
                this.logger.debug("DELETE Command event in " + string7);
                if (deleteEventException.getUID() == null) break block9;
                this.removeByUID(deleteEventException.getUID());
            }
        }
    }

    private String moveToDone(String string) {
        File file = new File(Cfg.getEventDir() + "/" + string);
        File file2 = WpFileUtils.getUniqueFile((String)(Cfg.getDoneDir() + "/" + string));
        try {
            WpFileUtils.moveFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            this.logger.warn("Could not move file:\nFrom: " + file.getAbsolutePath() + "\n  To: " + file2.getAbsolutePath() + "\n Why: ", (Throwable)iOException);
        }
        return file2.getName();
    }

    private String createLogFilename(String string, String string2) {
        return string + (String)(string.equals(string2) ? "" : ":[done/" + string2 + "]");
    }

    private void send_to_queue(String string, WpSessionAttributes.SESSION_TAG sESSION_TAG, WpSessionEvent wpSessionEvent, WpSessionResource wpSessionResource, WizePanelExceptions wizePanelExceptions) {
        WpSessionAttributes wpSessionAttributes = new WpSessionAttributes();
        wpSessionAttributes.setOriginator(WpSessionAttributes.SESSION_ORIGINATOR.EXTERN);
        wpSessionAttributes.setCommand(WpSessionAttributes.SESSION_COMMAND.CREATE);
        wpSessionAttributes.setInfo(string);
        wpSessionAttributes.setTag(sESSION_TAG);
        WpSession wpSession = new WpSession();
        wpSession.setAttributes(wpSessionAttributes);
        if (wpSessionEvent != null) {
            wpSession.setEvent(wpSessionEvent);
        }
        if (wpSessionResource != null) {
            wpSession.setResource(wpSessionResource);
        }
        if (wizePanelExceptions != null) {
            WpSessionResponse wpSessionResponse = new WpSessionResponse();
            wpSessionResponse.setErrorName(wizePanelExceptions.getErrorName());
            wpSessionResponse.setErrorParams(string);
            wpSessionResponse.setSource(WpSessionResponse.RESPONSE_SOURCE.EVENT);
            wpSession.setResponse(wpSessionResponse);
            Communicator.instance.addToFinished(wpSession);
            return;
        }
        this.logger.debug(wpSession.toString());
        this.scheduler.send_session(wpSession);
    }
}

