/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.webuntis;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.WebUntisAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.cache.DeleteEventException;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEventException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebUntisTask
extends AdapterJob {
    static final String WebUntisDateTimeFormat = "yyyyMMddHHmm";
    static final int maxErrorCounter = 3;
    private String sessionId;
    private String serverURL;
    private int alarm;
    private net.fortuna.ical4j.model.TimeZone timezone;
    int errorCounter;
    private String historyDuration;
    WebUntisAdapter m_cfg;
    Map<String, Integer> roomIdMap;

    public WebUntisTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (WebUntisAdapter)abstractAdapterConfiguration;
        this.alarm = this.m_cfg.alarm();
        TimeZoneRegistry timeZoneRegistry = TimeZoneRegistryFactory.getInstance().createRegistry();
        this.timezone = timeZoneRegistry.getTimeZone(this.m_cfg.timezone());
        List list = this.m_cfg.targets();
        this.roomIdMap = new HashMap<String, Integer>();
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        try {
            this.serverURL = this.m_cfg.server() + "?school=" + URLEncoder.encode(this.m_cfg.school(), "UTF-8");
            if (list != null && list.size() != 0 && this.getSessionId()) {
                logger.info("Installing new " + this.m_cfg.getDescription() + "[" + this.m_cfg.getName() + "] : Rooms: " + list);
                this.checkRooms(list);
                this.logout();
                logger.info("Install done for " + this.m_cfg.getDescription() + "[" + this.m_cfg.getName() + "] : Rooms set up: " + this.roomIdMap.size());
            } else {
                this.m_cfg = null;
                this.stop();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.addAdapterError(MessageFormat.format("Encoding of school failed. Check for typos ({0})", unsupportedEncodingException.getMessage()));
        }
    }

    private boolean getSessionId() {
        String string;
        block9: {
            Object object;
            HttpPost httpPost;
            JSONObject jSONObject;
            string = null;
            this.sessionId = "";
            String string2 = "";
            try {
                jSONObject = new JSONObject();
                jSONObject.put("user", (Object)this.m_cfg.user());
                jSONObject.put("password", (Object)this.m_cfg.password());
                jSONObject.put("client", (Object)"WilkeTechnology_WizePanelServer");
                httpPost = new JSONObject();
                object = new Random();
                httpPost.put("id", (Object)Integer.toString(((Random)object).nextInt(Integer.MAX_VALUE)));
                httpPost.put("method", (Object)"authenticate");
                httpPost.put("params", (Object)jSONObject);
                httpPost.put("jsonrpc", (Object)"2.0");
                string2 = httpPost.toString();
            }
            catch (JSONException jSONException) {
                string = MessageFormat.format("Error while build authentication packet: {0}", jSONException.getMessage());
            }
            try {
                jSONObject = HttpClients.createDefault();
                httpPost = new HttpPost(this.serverURL);
                object = new StringEntity(string2, "UTF-8");
                object.setContentType("application/json");
                httpPost.setEntity((HttpEntity)object);
                CloseableHttpResponse closeableHttpResponse = jSONObject.execute((HttpUriRequest)httpPost);
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                if (n != 200) {
                    string = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
                    break block9;
                }
                try {
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    String string3 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                    JSONObject jSONObject2 = new JSONObject(string3);
                    if (jSONObject2.has("error")) {
                        JSONObject jSONObject3 = jSONObject2.getJSONObject("error");
                        string = jSONObject3.has("message") ? MessageFormat.format("Error while parsing authentication response: {0}", jSONObject3.getString("message")) : MessageFormat.format("Error while parsing authentication response: {0}", "NULL - no error message returned by server");
                        break block9;
                    }
                    JSONObject jSONObject4 = jSONObject2.getJSONObject("result");
                    this.sessionId = jSONObject4.getString("sessionId");
                    return true;
                }
                catch (IOException | JSONException throwable) {
                    string = MessageFormat.format("Error while parsing authentication response: {0}", throwable.getMessage());
                }
            }
            catch (IOException iOException) {
                string = MessageFormat.format("Error during authentication: {0}", iOException.getMessage());
            }
        }
        if (string != null) {
            this.addAdapterError(string);
        }
        return false;
    }

    private void logout() {
        int n;
        String string = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
            JSONObject jSONObject = new JSONObject();
            Random random = new Random();
            jSONObject.put("id", (Object)Integer.toString(random.nextInt(Integer.MAX_VALUE)));
            jSONObject.put("method", (Object)"logout");
            jSONObject.put("params", (Object)"{}");
            jSONObject.put("jsonrpc", (Object)"2.0");
            HttpPost httpPost = new HttpPost(this.serverURL);
            StringEntity stringEntity = new StringEntity(jSONObject.toString(), "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException | JSONException throwable) {
            string = MessageFormat.format("Error while building logout packet: {0}", throwable.getMessage());
        }
        if (closeableHttpResponse != null && (n = closeableHttpResponse.getStatusLine().getStatusCode()) != 200) {
            try {
                string = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
            }
            catch (IOException | org.apache.http.ParseException throwable) {
                string = MessageFormat.format("Error during logout: {0}", throwable.getMessage());
            }
        }
        if (string != null) {
            this.addAdapterError(string);
        }
    }

    private void checkRooms(List<String> list) {
        String string;
        block11: {
            Random random;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            string = null;
            String string2 = "";
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            try {
                jSONObject2 = new JSONObject();
                jSONObject = new JSONObject();
                random = new Random();
                jSONObject.put("id", (Object)Integer.toString(random.nextInt(Integer.MAX_VALUE)));
                jSONObject.put("method", (Object)"getRooms");
                jSONObject.put("params", (Object)jSONObject2);
                jSONObject.put("jsonrpc", (Object)"2.0");
                string2 = jSONObject.toString();
            }
            catch (JSONException jSONException) {
                string = MessageFormat.format("Error while build getRooms packet: {0}", jSONException.getMessage());
            }
            try {
                jSONObject2 = HttpClients.createDefault();
                jSONObject = new HttpPost(this.serverURL);
                random = new StringEntity(string2, "UTF-8");
                random.setContentType("application/json");
                jSONObject.setEntity((HttpEntity)random);
                jSONObject.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
                CloseableHttpResponse closeableHttpResponse = jSONObject2.execute((HttpUriRequest)jSONObject);
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                if (n != 200) {
                    string = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
                    break block11;
                }
                try {
                    int n2;
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    String string3 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                    JSONObject jSONObject3 = new JSONObject(string3);
                    JSONArray jSONArray = jSONObject3.getJSONArray("result");
                    for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                        JSONObject jSONObject4 = jSONArray.getJSONObject(n2);
                        if (!jSONObject4.has("name") || !jSONObject4.has("id")) continue;
                        hashMap.put(jSONObject4.getString("name"), jSONObject4.getInt("id"));
                    }
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        if (hashMap.containsKey(list.get(n2))) {
                            this.roomIdMap.put(list.get(n2), (Integer)hashMap.get(list.get(n2)));
                            continue;
                        }
                        this.addAdapterError(MessageFormat.format("Room not found in WebUntis: {0}", list.get(n2)));
                    }
                }
                catch (IOException | JSONException throwable) {
                    string = MessageFormat.format("Error while parsing getRooms response: {0}", throwable.getMessage());
                }
            }
            catch (IOException iOException) {
                string = MessageFormat.format("Error while checking rooms list: {0}", iOException.getMessage());
            }
        }
        if (string != null) {
            this.addAdapterError(string);
        }
    }

    @Override
    public synchronized void singleRun() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(this.historyDuration));
        calendar.setTimeZone((TimeZone)this.timezone);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setTimeZone((TimeZone)this.timezone);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.m_cfg.range().getRangeDate());
        calendar2.setTimeZone((TimeZone)this.timezone);
        String string = simpleDateFormat.format(calendar.getTime());
        String string2 = simpleDateFormat.format(calendar2.getTime());
        if (this.roomIdMap != null && this.roomIdMap.size() != 0 && this.getSessionId()) {
            JSONArray jSONArray = this.getSchoolyears(string, string2);
            LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
            for (Map.Entry<String, Integer> entry : this.roomIdMap.entrySet()) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    try {
                        JSONObject jSONObject = jSONArray.getJSONObject(i);
                        List<CalendarEvent> list = this.getCalendarEvents(entry, Integer.toString(jSONObject.getInt("startDate")), Integer.toString(jSONObject.getInt("endDate")));
                        if (list == null) {
                            if (this.errorCounter > 3) {
                                this.setAdapterEvents(null);
                                this.addAdapterError(MessageFormat.format("Error could not get events {0} or more times. Event list cleared!", 3));
                            } else {
                                ++this.errorCounter;
                            }
                            return;
                        }
                        linkedList.addAll(list);
                        this.errorCounter = 0;
                        continue;
                    }
                    catch (JSONException jSONException) {
                        this.addAdapterError(MessageFormat.format("Error while getting events: {0}", jSONException.getMessage()));
                    }
                }
            }
            this.setAdapterEvents(linkedList);
            this.logout();
        }
    }

    private JSONArray getSchoolyears(String string, String string2) {
        String string3;
        block12: {
            Random random;
            JSONObject jSONObject;
            string3 = null;
            String string4 = "";
            try {
                jSONObject = new JSONObject();
                random = new Random();
                jSONObject.put("id", (Object)Integer.toString(random.nextInt(Integer.MAX_VALUE)));
                jSONObject.put("method", (Object)"getSchoolyears");
                jSONObject.put("params", (Object)"{}");
                jSONObject.put("jsonrpc", (Object)"2.0");
                string4 = jSONObject.toString();
            }
            catch (JSONException jSONException) {
                string3 = MessageFormat.format("Error while build getSchoolyears packet: {0}", jSONException.getMessage());
            }
            try {
                jSONObject = HttpClients.createDefault();
                random = new HttpPost(this.serverURL);
                StringEntity stringEntity = new StringEntity(string4, "UTF-8");
                stringEntity.setContentType("application/json");
                random.setEntity((HttpEntity)stringEntity);
                random.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
                CloseableHttpResponse closeableHttpResponse = jSONObject.execute((HttpUriRequest)random);
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                if (n != 200) {
                    string3 = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
                    break block12;
                }
                try {
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    String string5 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                    JSONObject jSONObject2 = new JSONObject(string5);
                    if (jSONObject2.has("error")) {
                        JSONObject jSONObject3 = jSONObject2.getJSONObject("error");
                        string3 = jSONObject3.has("message") ? MessageFormat.format("Error while parsing getSchoolyears response: {0}", jSONObject3.getString("message")) : MessageFormat.format("Error while parsing getSchoolyears response: {0}", "NULL - no error message returned by server");
                        break block12;
                    }
                    JSONArray jSONArray = jSONObject2.getJSONArray("result");
                    JSONArray jSONArray2 = new JSONArray();
                    int n2 = Integer.parseInt(string);
                    int n3 = Integer.parseInt(string2);
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        JSONObject jSONObject4 = jSONArray.getJSONObject(i);
                        if (jSONObject4.getInt("startDate") >= n3 || n2 >= jSONObject4.getInt("endDate")) continue;
                        if (jSONObject4.getInt("startDate") < n2) {
                            jSONObject4.put("startDate", n2);
                        }
                        if (jSONObject4.getInt("endDate") > n3) {
                            jSONObject4.put("endDate", n3);
                        }
                        jSONArray2.put((Object)jSONObject4);
                    }
                    return jSONArray2;
                }
                catch (IOException | JSONException throwable) {
                    string3 = MessageFormat.format("Error while parsing getSchoolyears response: {0}", throwable.getMessage());
                }
            }
            catch (IOException iOException) {
                string3 = MessageFormat.format("Error while getting school years: {0}", iOException.getMessage());
            }
        }
        if (string3 != null) {
            this.addAdapterError(string3);
        }
        return null;
    }

    private List<CalendarEvent> getCalendarEvents(Map.Entry<String, Integer> entry, String string, String string2) {
        String string3;
        block10: {
            Object object;
            JSONObject jSONObject;
            String string4;
            HttpEntity httpEntity;
            CloseableHttpResponse closeableHttpResponse;
            StringEntity stringEntity;
            HttpPost httpPost;
            JSONObject jSONObject2;
            string3 = null;
            String string5 = "";
            try {
                jSONObject2 = new JSONObject();
                jSONObject2.put("id", (Object)entry.getValue());
                jSONObject2.put("type", 4);
                jSONObject2.put("keyType", (Object)"id");
                httpPost = new JSONObject();
                httpPost.put("element", (Object)jSONObject2);
                httpPost.put("startDate", Integer.parseInt(string));
                httpPost.put("endDate", Integer.parseInt(string2));
                httpPost.put("showBooking", true);
                httpPost.put("showInfo", true);
                httpPost.put("showSubstText", true);
                httpPost.put("showLsText", true);
                stringEntity = new JSONArray();
                stringEntity.put((Object)"name");
                stringEntity.put((Object)"longname");
                httpPost.put("klasseFields", (Object)stringEntity);
                closeableHttpResponse = new JSONArray();
                closeableHttpResponse.put((Object)"name");
                closeableHttpResponse.put((Object)"longname");
                httpPost.put("roomFields", (Object)closeableHttpResponse);
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)"name");
                jSONArray.put((Object)"longname");
                httpPost.put("subjectFields", (Object)jSONArray);
                httpEntity = new JSONArray();
                httpEntity.put((Object)"name");
                httpEntity.put((Object)"longname");
                httpPost.put("teacherFields", (Object)httpEntity);
                string4 = new JSONObject();
                string4.put("options", (Object)httpPost);
                jSONObject = new JSONObject();
                object = new Random();
                jSONObject.put("id", (Object)Integer.toString(((Random)object).nextInt(Integer.MAX_VALUE)));
                jSONObject.put("method", (Object)"getTimetable");
                jSONObject.put("params", (Object)string4);
                jSONObject.put("jsonrpc", (Object)"2.0");
                string5 = jSONObject.toString();
            }
            catch (JSONException jSONException) {
                string3 = MessageFormat.format("Error while build getTimetable packet: {0}", jSONException.getMessage());
            }
            try {
                jSONObject2 = HttpClients.createDefault();
                httpPost = new HttpPost(this.serverURL);
                stringEntity = new StringEntity(string5, "UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
                httpPost.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
                closeableHttpResponse = jSONObject2.execute((HttpUriRequest)httpPost);
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                if (n != 200) {
                    string3 = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
                    break block10;
                }
                try {
                    httpEntity = closeableHttpResponse.getEntity();
                    string4 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                    jSONObject = new JSONObject(string4);
                    if (jSONObject.has("error")) {
                        object = jSONObject.getJSONObject("error");
                        string3 = object.has("message") ? MessageFormat.format("Error while parsing getTimetable response: {0}", object.getString("message")) : MessageFormat.format("Error while parsing getTimetable response: {0}", "NULL - no error message returned by server");
                        break block10;
                    }
                    object = jSONObject.getJSONArray("result");
                    LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
                    for (int i = 0; i < object.length(); ++i) {
                        JSONObject jSONObject3 = object.getJSONObject(i);
                        CalendarEvent calendarEvent = this.createCalendarEvent(jSONObject3, entry.getKey());
                        linkedList.add(calendarEvent);
                    }
                    return linkedList;
                }
                catch (IOException | JSONException throwable) {
                    string3 = MessageFormat.format("Error while parsing getTimetable response: {0}", throwable.getMessage());
                }
            }
            catch (IOException iOException) {
                string3 = MessageFormat.format("Error while getting events: {0}", iOException.getMessage());
            }
        }
        if (string3 != null) {
            this.addAdapterError(string3);
        }
        return null;
    }

    private CalendarEvent createCalendarEvent(JSONObject jSONObject, String string) {
        String string2 = null;
        Object object = "";
        try {
            Object object2;
            String string3 = Integer.toString(jSONObject.getInt("id"));
            String string4 = Integer.toString(jSONObject.getInt("date"));
            Object object3 = Integer.toString(jSONObject.getInt("startTime"));
            if (((String)object3).length() == 3) {
                object3 = "0" + (String)object3;
            }
            if (((String)(object2 = Integer.toString(jSONObject.getInt("endTime")))).length() == 3) {
                object2 = "0" + (String)object2;
            }
            DateTime dateTime = new DateTime(string4 + (String)object3, WebUntisDateTimeFormat, this.timezone);
            dateTime.setUtc(true);
            DateTime dateTime2 = new DateTime(string4 + (String)object2, WebUntisDateTimeFormat, this.timezone);
            dateTime2.setUtc(true);
            String string5 = "ls";
            if (jSONObject.has("lstype")) {
                string5 = jSONObject.getString("lstype");
            }
            String string6 = "";
            if (jSONObject.has("code")) {
                string6 = jSONObject.getString("code");
            }
            String string7 = "";
            if (jSONObject.has("info")) {
                string7 = jSONObject.getString("info");
            }
            String string8 = "";
            if (jSONObject.has("substText")) {
                string8 = jSONObject.getString("substText");
            }
            String string9 = "";
            if (jSONObject.has("lstext")) {
                string9 = jSONObject.getString("lstext");
            }
            String string10 = "";
            if (jSONObject.has("activityType")) {
                string10 = jSONObject.getString("activityType");
            }
            JSONObject jSONObject2 = new JSONObject();
            if (jSONObject.has("su") && jSONObject.getJSONArray("su").length() > 0) {
                jSONObject2 = jSONObject.getJSONArray("su").getJSONObject(0);
            }
            JSONObject jSONObject3 = new JSONObject();
            if (jSONObject.has("te") && jSONObject.getJSONArray("te").length() > 0) {
                jSONObject3 = jSONObject.getJSONArray("te").getJSONObject(0);
            }
            JSONObject jSONObject4 = new JSONObject();
            if (jSONObject.has("kl") && jSONObject.getJSONArray("kl").length() > 0) {
                jSONObject4 = jSONObject.getJSONArray("kl").getJSONObject(0);
            }
            JSONObject jSONObject5 = new JSONObject();
            if (jSONObject.has("ro") && jSONObject.getJSONArray("ro").length() > 0) {
                jSONObject5 = jSONObject.getJSONArray("ro").getJSONObject(0);
            }
            this.logger.info("Creating new event at: " + WpTimeUtils.date2str((java.util.Date)dateTime));
            XWizePanel xWizePanel = new XWizePanel();
            xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
            xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("LSTYPE", string5);
            if (!string6.isEmpty()) {
                hashMap.put("CODE", string6);
            }
            if (!string7.isEmpty()) {
                hashMap.put("INFO", string7);
            }
            if (!string8.isEmpty()) {
                hashMap.put("SUBSTEXT", string8);
            }
            if (!string9.isEmpty()) {
                hashMap.put("LSTEXT", string9);
            }
            if (!string10.isEmpty()) {
                hashMap.put("ACTIVITY_TYPE", string10);
            }
            if (jSONObject2.has("name")) {
                hashMap.put("SUBJECT_SHORT", jSONObject2.getString("name"));
            }
            if (jSONObject2.has("longname")) {
                hashMap.put("SUBJECT_LONG", jSONObject2.getString("longname"));
            }
            if (jSONObject4.has("name")) {
                hashMap.put("CLASS_SHORT", jSONObject4.getString("name"));
                object = (String)object + jSONObject4.getString("name") + " ";
            }
            if (jSONObject4.has("longname")) {
                hashMap.put("CLASS_LONG", jSONObject4.getString("longname"));
            }
            if (jSONObject3.has("name")) {
                hashMap.put("TEACHER_SHORT", jSONObject3.getString("name"));
            }
            if (jSONObject3.has("longname")) {
                hashMap.put("TEACHER_LONG", jSONObject3.getString("longname"));
                object = (String)object + jSONObject3.getString("longname") + " ";
            }
            if (jSONObject5.has("name")) {
                hashMap.put("ROOM_SHORT", jSONObject5.getString("name"));
            }
            if (jSONObject5.has("longname")) {
                hashMap.put("ROOM_LONG", jSONObject5.getString("longname"));
            }
            if (jSONObject2.has("longname")) {
                hashMap.put("DESCRIPTION", jSONObject2.getString("longname"));
                object = (String)object + jSONObject2.getString("longname");
            } else if (!string7.isEmpty()) {
                hashMap.put("DESCRIPTION", string7);
                object = (String)object + string7;
            } else if (!string9.isEmpty()) {
                hashMap.put("DESCRIPTION", string9);
                object = (String)object + string9;
            }
            hashMap.put("SUMMARY", ((String)object).trim().replaceAll(" +", " "));
            xWizePanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
            VAlarm vAlarm = null;
            if (this.alarm > 0) {
                vAlarm = new VAlarm();
                vAlarm.getProperties().add((Property)Action.DISPLAY);
                vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + this.alarm + "M")));
                vAlarm.getProperties().add((Property)new Description("Alarma!"));
            }
            VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, string7);
            vEvent.getProperties().add((Property)new Uid(string3));
            vEvent.getProperties().add((Property)new Location(string));
            vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
            if (vAlarm != null) {
                vEvent.getAlarms().add((Component)vAlarm);
            }
            return new CalendarEvent(vEvent, true);
        }
        catch (DeleteEventException | CalendarEventException | ParseException | org.apache.http.ParseException | JSONException throwable) {
            string2 = MessageFormat.format("Error while getting creating calendar event: {0}", throwable.getMessage());
            if (!string2.isEmpty()) {
                this.addAdapterError(string2);
            }
            return null;
        }
    }
}

