/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.cache;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.FileAdapterManager;
import de.wilke.wizepanel.eventmanager.cache.CacheEvent;
import de.wilke.wizepanel.eventmanager.cache.CacheResult;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventCache {
    private static final Logger m_logger = LogManager.getLogger(EventCache.class);
    private final Map<String, CacheEvent> events = new ConcurrentHashMap<String, CacheEvent>();
    private final List<CacheResult> m_cache = new LinkedList<CacheResult>();
    private DateTime m_cache_end_date = null;
    private static final long m_cache_additional_millis = 2678400000L;
    private boolean need_cleanup = false;

    public List<CacheResult> getRecurrences(DateTime dateTime) {
        int n;
        DateTime dateTime2;
        if (this.m_cache_end_date == null || dateTime.after((Date)this.m_cache_end_date)) {
            dateTime2 = new DateTime();
            dateTime2.setTime(dateTime2.getTime() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
            this.update_cache(dateTime2, dateTime);
        } else if (this.need_cleanup) {
            this.cleanup();
            this.need_cleanup = false;
        }
        dateTime2 = new DateTime();
        dateTime2.setTime(dateTime2.getTime() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
        int n2 = 0;
        int n3 = this.m_cache.size();
        for (n = 0; n < this.m_cache.size(); ++n) {
            if (this.m_cache.get(n).getDisplayTo().after((Date)dateTime2)) {
                n2 = n;
                break;
            }
            this.need_cleanup = true;
        }
        for (n = n2; n < this.m_cache.size(); ++n) {
            if (!this.m_cache.get(n).getDisplayOn().after((Date)dateTime)) continue;
            n3 = n;
            break;
        }
        return this.m_cache.subList(n2, n3);
    }

    private void update_cache(DateTime dateTime, DateTime dateTime2) {
        this.m_cache.clear();
        this.m_cache_end_date = new DateTime(dateTime2.getTime() + 2678400000L);
        m_logger.info("Updating cache to " + WpTimeUtils.date2str((Date)this.m_cache_end_date));
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String object : this.events.keySet()) {
            CacheEvent cacheEvent = this.events.get(object);
            if (cacheEvent.getCalendarEvent().isExpired()) {
                linkedList.add(object);
                continue;
            }
            List<Period> list = cacheEvent.getRecurrences(dateTime, this.m_cache_end_date);
            if (list == null) continue;
            for (Period period : list) {
                AbstractAdapterConfiguration abstractAdapterConfiguration;
                Period period2 = cacheEvent.getDisplayPeriod(period);
                if (period2.getEnd().before((Date)dateTime) || (abstractAdapterConfiguration = FileAdapterManager.getManager().getAdapterByName(LicenseManager.getManager(), cacheEvent.getCalendarEvent().getAdapterName())) == null) continue;
                boolean bl = false;
                if (abstractAdapterConfiguration.range().getRangeDate() == null) {
                    bl = true;
                } else if (period2.getStart().before(abstractAdapterConfiguration.range().getRangeDate())) {
                    bl = true;
                }
                if (!bl) continue;
                this.m_cache.add(new CacheResult(cacheEvent.getCalendarEvent(), period2, period));
            }
        }
        for (String string : linkedList) {
            this.removeByUID(string);
        }
        Collections.sort(this.m_cache, new Comparator<CacheResult>(){

            @Override
            public int compare(CacheResult cacheResult, CacheResult cacheResult2) {
                if (cacheResult.getDisplayTo().after((Date)cacheResult2.getDisplayTo())) {
                    return 1;
                }
                if (cacheResult.getDisplayTo().before((Date)cacheResult2.getDisplayTo())) {
                    return -1;
                }
                return 0;
            }
        });
        m_logger.debug("CACHE.begin");
        for (CacheResult cacheResult : this.m_cache) {
            m_logger.debug("CACHE: " + cacheResult.toString());
        }
        m_logger.debug("CACHE.end");
    }

    public void add(CalendarEvent calendarEvent) {
        CacheEvent cacheEvent = new CacheEvent(calendarEvent);
        this.events.put(calendarEvent.getUID(), cacheEvent);
        this.m_cache_end_date = null;
    }

    public void removeByUID(String string) {
        this.events.remove(string);
        Iterator<CacheResult> iterator = this.m_cache.iterator();
        while (iterator.hasNext()) {
            CacheResult cacheResult = iterator.next();
            if (!cacheResult.getEvent().getUID().equals(string)) continue;
            iterator.remove();
        }
    }

    public void removeByAdapter(String string) {
        Iterator<CacheResult> iterator = this.m_cache.iterator();
        while (iterator.hasNext()) {
            CacheResult cacheResult = iterator.next();
            if (!cacheResult.getEvent().getAdapterName().equals(string)) continue;
            iterator.remove();
            this.events.remove(cacheResult.getEvent().getUID());
        }
    }

    public CacheEvent getEventByUID(String string, String string2) {
        return this.events.get(string);
    }

    private void cleanup() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Date date = new Date();
        date.setTime(date.getTime() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
        for (int i = 0; i < this.m_cache.size() && this.m_cache.get(i).getDisplayTo().before(date); ++i) {
            if (!this.m_cache.get(i).getEvent().isExpired()) continue;
            linkedList.add(this.m_cache.get(i).getEvent().getUID());
        }
        for (String string : linkedList) {
            this.removeByUID(string);
        }
    }
}

