/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.ical;

import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.cache.DeleteEventException;
import de.wilke.wizepanel.eventmanager.ical.CalendarEventException;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalendarEvent {
    private final Logger m_logger = LogManager.getLogger(CalendarEvent.class);
    private VEvent _vevent_component;
    private int _wake_up_time = -1;
    private int _reminder_time = -1;
    private boolean _checked_past = false;
    private XWizePanel m_xwizepanel = new XWizePanel();
    private final RRule _rrule;

    public CalendarEvent(CalendarEvent calendarEvent) {
        try {
            this._vevent_component = (VEvent)calendarEvent._vevent_component.copy();
        }
        catch (ParseException parseException) {
            this.m_logger.error(parseException.getMessage());
        }
        catch (IOException iOException) {
            this.m_logger.error(iOException.getMessage());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.m_logger.error(uRISyntaxException.getMessage());
        }
        finally {
            if (this._vevent_component == null) {
                this._vevent_component = new VEvent();
            }
        }
        this.m_xwizepanel = new XWizePanel(calendarEvent.m_xwizepanel.getICSValue());
        this._rrule = (RRule)calendarEvent._vevent_component.getProperty("RRULE");
    }

    public CalendarEvent(VEvent vEvent, boolean bl) throws CalendarEventException, DeleteEventException {
        this._vevent_component = vEvent;
        if (bl && !this.parse_x_wizepanel()) {
            this.m_logger.error("No X-WIZEPANEL line in VEVENT: " + this.m_xwizepanel.getString(XWizePanel.WPDataItem.Filename, null));
            throw new DeleteEventException(this.getUID());
        }
        if (this.m_xwizepanel.getString(XWizePanel.WPDataItem.Command, null) == null) {
            this.m_xwizepanel.add(XWizePanel.WPDataItem.Command, "ADD");
        }
        if (this.m_xwizepanel.getString(XWizePanel.WPDataItem.Command, "").equalsIgnoreCase("DELETE")) {
            throw new DeleteEventException(this.getUID());
        }
        String string = this.resolve_target();
        if (string == null) {
            // empty if block
        }
        this._rrule = (RRule)this._vevent_component.getProperty("RRULE");
    }

    public String getUID() {
        Map<String, String> map = this.getPlaceholders();
        if (map != null && map.containsKey("UID")) {
            return map.get("UID");
        }
        return this._vevent_component.getProperty("UID").getValue();
    }

    public List<Period> get(DateTime object, DateTime dateTime) {
        Object object2;
        PeriodList periodList;
        Period period;
        if (this._rrule == null && !this._checked_past) {
            this._checked_past = true;
            period = (DtStart)this._vevent_component.getProperty("DTSTART");
            periodList = period.getDate();
            try {
                object2 = (DateTime)periodList;
                if (object2.before((java.util.Date)dateTime)) {
                    object = object2;
                }
            }
            catch (Exception exception) {
                try {
                    Iterator iterator = new DateTime(periodList.getTime());
                    if (iterator.before((java.util.Date)dateTime)) {
                        object = iterator;
                    }
                }
                catch (Exception exception2) {
                    Warnings.getInstance().addWarning(this.getSummary(), exception.getMessage());
                    return null;
                }
            }
        }
        period = new Period(object, dateTime);
        try {
            periodList = this._vevent_component.calculateRecurrenceSet(period);
            if (periodList.size() == 0) {
                return null;
            }
            object2 = new ArrayList();
            for (Object e : periodList) {
                period = (Period)e;
                object2.add(period);
            }
            return object2;
        }
        catch (Exception exception) {
            Warnings.getInstance().addWarning(this.getSummary(), exception.getMessage());
            return null;
        }
    }

    public int getWakeUpTime() {
        if (this._wake_up_time == -1) {
            UpiTargetItem upiTargetItem = WpUpiServerStaticFactory.getRoutingHandler().getTargetByName(this.getTargetName());
            if (upiTargetItem != null) {
                try {
                    WizePanelItemType wizePanelItemType = WpDataManager.getManager().getWizepanelById(Integer.parseInt(upiTargetItem.getId()));
                    this._wake_up_time = wizePanelItemType.params().getWakeup();
                }
                catch (Exception exception) {
                    this._wake_up_time = upiTargetItem.getParams().getWakeup();
                }
            } else {
                this._wake_up_time = 0;
            }
        }
        return this._wake_up_time;
    }

    public int getReminderTime() {
        if (this._reminder_time == -1) {
            int n = 0;
            Object[] objectArray = this._vevent_component.getAlarms().toArray();
            int n2 = objectArray.length;
            if (n < n2) {
                Object object = objectArray[n];
                VAlarm vAlarm = (VAlarm)object;
                Dur dur = vAlarm.getTrigger().getDuration();
                this._reminder_time = dur.getSeconds() + 60 * dur.getMinutes() + 3600 * dur.getHours() + 86400 * dur.getDays();
            }
            if (this._reminder_time < 0) {
                this._reminder_time = 0;
            }
        }
        return this._reminder_time;
    }

    public void setReminderTime(int n) {
        if (this._reminder_time <= 0) {
            this._reminder_time = n;
        }
    }

    private boolean parse_x_wizepanel() {
        Property property = this._vevent_component.getProperty("X-WIZEPANEL");
        if (property == null) {
            return false;
        }
        this.m_xwizepanel = new XWizePanel(property.getValue());
        this.m_logger.debug("Parsed X-WIZEPANEL: " + this.m_xwizepanel.getICSValue());
        return true;
    }

    private String resolve_target() {
        String string = this.getWPData(XWizePanel.WPDataItem.TargetStationPath);
        if (string == null || string.isEmpty()) {
            return null;
        }
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        UpiTargetItem upiTargetItem = upiRoutingHandler.getTargetByName(string);
        if (upiTargetItem == null) {
            return null;
        }
        return upiTargetItem.getParams().getName();
    }

    public String getWPData(XWizePanel.WPDataItem wPDataItem) {
        return this.m_xwizepanel.getString(wPDataItem, null);
    }

    public boolean isSimpleEvents() {
        return this.m_xwizepanel.getBoolean(XWizePanel.WPDataItem.IsSimpleEvents, false);
    }

    public boolean isSimpleEventsNonMain() {
        return this.m_xwizepanel.getBoolean(XWizePanel.WPDataItem.IsSimpleEventsNonMain, false);
    }

    public void setIsSimpleEventsNonMain() {
        this.m_xwizepanel.add(XWizePanel.WPDataItem.IsSimpleEventsNonMain, true);
    }

    public String getLocation() {
        Map<String, String> map = this.getPlaceholders();
        if (map != null && map.containsKey("LOCATION")) {
            return map.get("LOCATION");
        }
        Location location = (Location)this._vevent_component.getProperty("LOCATION");
        if (location != null) {
            return location.getValue();
        }
        return null;
    }

    public String getOrganizerName() {
        Cn cn;
        Organizer organizer = this._vevent_component.getOrganizer();
        if (organizer != null && (cn = (Cn)organizer.getParameter("CN")) != null) {
            return cn.getValue();
        }
        return this.getPlaceholder("CREATOR", "");
    }

    public String getSummary() {
        if (this.isPrivate()) {
            return this.m_xwizepanel.getString(XWizePanel.WPDataItem.PrivateEventSummary, "");
        }
        Map<String, String> map = this.getPlaceholders();
        if (map != null && map.containsKey("SUMMARY")) {
            return map.get("SUMMARY");
        }
        Summary summary = (Summary)this._vevent_component.getProperty("SUMMARY");
        if (summary != null) {
            return summary.getValue();
        }
        return null;
    }

    public String getDescription() {
        if (this.isPrivate()) {
            return "";
        }
        Map<String, String> map = this.getPlaceholders();
        if (map != null && map.containsKey("DESCRIPTION") && map.get("DESCRIPTION") != "") {
            return map.get("DESCRIPTION");
        }
        Description description = (Description)this._vevent_component.getProperty("DESCRIPTION");
        if (description != null) {
            return description.getValue();
        }
        return null;
    }

    public boolean req_attendee_cancelled() {
        PropertyList propertyList = this._vevent_component.getProperties("ATTENDEE");
        for (int i = 0; i < propertyList.size(); ++i) {
            Attendee attendee = (Attendee)propertyList.get(i);
            Role role = (Role)attendee.getParameter("ROLE");
            PartStat partStat = (PartStat)attendee.getParameter("PARTSTAT");
            if (role == null || !role.getValue().equals(Role.REQ_PARTICIPANT.getValue()) || !partStat.getValue().equals(PartStat.DECLINED.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean status_cancel() {
        Status status = (Status)this._vevent_component.getProperty("STATUS");
        if (status == null) {
            return false;
        }
        return status.getValue().equals(Status.VEVENT_CANCELLED.getValue());
    }

    public String getTargetName() {
        return this.m_xwizepanel.getString(XWizePanel.WPDataItem.TargetStationPath, null);
    }

    public void setTargetName(String string) {
        this.m_xwizepanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
    }

    public void setSummary(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SUMMARY", string);
        this.m_xwizepanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
    }

    public void setDescription(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DESCRIPTION", string);
        this.m_xwizepanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
    }

    public void setLocation(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("LOCATION", string);
        this.m_xwizepanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
    }

    public java.util.Date getStartDate() {
        return this._vevent_component.getStartDate().getDate();
    }

    public java.util.Date getEndDate() {
        Date date = null;
        try {
            date = this._vevent_component.getEndDate().getDate();
            return date;
        }
        catch (Exception exception) {
            this.m_logger.error(exception.toString());
            try {
                date = this._vevent_component.getEndDate(true).getDate();
                return date;
            }
            catch (Exception exception2) {
                this.m_logger.error(exception2.toString());
                return new java.util.Date();
            }
        }
    }

    public java.util.Date getLastModified() {
        try {
            return this._vevent_component.getLastModified().getDate();
        }
        catch (Throwable throwable) {
            return new java.util.Date();
        }
    }

    private boolean isPrivate() {
        Clazz clazz = this._vevent_component.getClassification();
        return clazz != null && (clazz == Clazz.PRIVATE || clazz == Clazz.CONFIDENTIAL);
    }

    public boolean isExpired() {
        String string = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(this.getAdapterName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(string)) continue;
            string = groupData.historyDuration;
        }
        if (string.equals("0")) {
            string = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        java.util.Date date = new java.util.Date();
        date.setTime(date.getTime() - Long.valueOf(string));
        return this.isExpired(date);
    }

    public boolean isExpired(java.util.Date date) {
        if (this._rrule != null) {
            Recur recur = this._rrule.getRecur();
            Date date2 = recur.getUntil();
            if (date2 != null) {
                return date2.before(date);
            }
            return false;
        }
        return this.getEndDate().before(date);
    }

    public boolean startsBefore(java.util.Date date) {
        boolean bl;
        try {
            bl = this.getStartDate().before(date);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean suppressEventNotChangedEvents() {
        return this.m_xwizepanel.getBoolean(XWizePanel.WPDataItem.SuppressEventNotChangedWarnings, false);
    }

    public String getAdapterName() {
        return this.m_xwizepanel.getString(XWizePanel.WPDataItem.AdapterCfg, "");
    }

    public void setAdapterName(String string) {
        this.m_xwizepanel.add(XWizePanel.WPDataItem.AdapterCfg, string);
    }

    public String getPlaceholder(String string, String string2) {
        Map<String, String> map = this.getPlaceholders();
        if (map != null && map.containsKey(string)) {
            return map.get(string);
        }
        return string2;
    }

    public Map<String, String> getPlaceholders() {
        return this.m_xwizepanel.getMap(XWizePanel.WPDataItem.Placeholders);
    }

    public boolean equals(Object object) {
        if (object instanceof CalendarEvent) {
            CalendarEvent calendarEvent = (CalendarEvent)object;
            Map<String, String> map = calendarEvent.getPlaceholders();
            Map<String, String> map2 = this.getPlaceholders();
            if (map == null && map2 != null) {
                return false;
            }
            if (map != null && map2 == null) {
                return false;
            }
            if (map != null && map2 != null && !map.equals(map2)) {
                return false;
            }
            String string = calendarEvent.getWPData(XWizePanel.WPDataItem.Template);
            String string2 = this.getWPData(XWizePanel.WPDataItem.Template);
            String string3 = calendarEvent.getWPData(XWizePanel.WPDataItem.TargetStationPath);
            String string4 = this.getWPData(XWizePanel.WPDataItem.TargetStationPath);
            return calendarEvent.getUID().equals(this.getUID()) && calendarEvent.getStartDate().equals(this.getStartDate()) && calendarEvent.getEndDate().equals(this.getEndDate()) && (string3 == string4 || string3 != null && string3.equals(string4)) && (calendarEvent.getSummary() == this.getSummary() || calendarEvent.getSummary() != null && calendarEvent.getSummary().equals(this.getSummary())) && (string == string2 || string != null && string.equals(string2)) && (calendarEvent.getLocation() == this.getLocation() || calendarEvent.getLocation() != null && calendarEvent.getLocation().equals(this.getLocation())) && calendarEvent.getReminderTime() == this.getReminderTime() && (calendarEvent.getDescription() == this.getDescription() || calendarEvent.getDescription() != null && calendarEvent.getDescription().equals(this.getDescription())) && (calendarEvent._rrule == this._rrule || calendarEvent._rrule != null && calendarEvent._rrule.equals((Object)this._rrule));
        }
        return super.equals(object);
    }

    public void setUID(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("UID", string);
        this.m_xwizepanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
    }
}

