/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.AdaptersChangeListener;
import de.wilke.wizepanel.core.adapters.AscTimeTablesAdapter;
import de.wilke.wizepanel.core.adapters.CsvAdapter;
import de.wilke.wizepanel.core.adapters.DEAEMSAdapter;
import de.wilke.wizepanel.core.adapters.EnergySaverAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeEMailAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeEWSAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeEWSOnlineAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeGraphAdapter;
import de.wilke.wizepanel.core.adapters.GoogleCalendarAdapter;
import de.wilke.wizepanel.core.adapters.HttpGeneralAdapter;
import de.wilke.wizepanel.core.adapters.ICalendarAdapter;
import de.wilke.wizepanel.core.adapters.SystemMonitorAdapter;
import de.wilke.wizepanel.core.adapters.WebUntisAdapter;
import de.wilke.wizepanel.core.adapters.WilkeSimpleEventsAdapter;
import de.wilke.wizepanel.core.adapters.XMLAdapter;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.FileAdapterManager;
import de.wilke.wizepanel.eventmanager.WPEventManager;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.asc_timetables.AscTimeTablesTask;
import de.wilke.wizepanel.eventmanager.adapters.csv.CsvTask;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.DeaEmsTask;
import de.wilke.wizepanel.eventmanager.adapters.energysaver.EnergySaverTask;
import de.wilke.wizepanel.eventmanager.adapters.googlecal.GoogleCalendarTask;
import de.wilke.wizepanel.eventmanager.adapters.http_general.HttpGeneralTask;
import de.wilke.wizepanel.eventmanager.adapters.icalendar.ICalendarTask;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.MSEWSTask;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews_online.MSEWSOnlineTask;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.ExchangeMailTask;
import de.wilke.wizepanel.eventmanager.adapters.ms_graph.MSGraphTask;
import de.wilke.wizepanel.eventmanager.adapters.simple_events.SimpleEventsTask;
import de.wilke.wizepanel.eventmanager.adapters.systemmonitor.SystemMonitorTask;
import de.wilke.wizepanel.eventmanager.adapters.webuntis.WebUntisTask;
import de.wilke.wizepanel.eventmanager.adapters.xml.XMLTask;
import de.wilke.wizepanel.server.AppWrapper;
import de.wilke.wizepanel.server.Services;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class AdapterLauncher
extends AppWrapper {
    private static final Logger logger = LogManager.getLogger(AdapterLauncher.class);
    private Map<String, AdapterJob> m_tasks = new HashMap<String, AdapterJob>();
    private boolean is_running = false;
    private final WPEventManager em;
    private final Map<Class<? extends AbstractAdapterConfiguration>, Class<? extends AdapterJob>> adapter2job = new HashMap<Class<? extends AbstractAdapterConfiguration>, Class<? extends AdapterJob>>();

    public AdapterLauncher(Services services, WPEventManager wPEventManager) {
        super(services, "Adapters", true);
        this.em = wPEventManager;
        FileAdapterManager.getManager().addChangeListener(new AdaptersChangeListener(){

            public void changed() {
                AdapterLauncher.this.what_to_do();
            }
        });
        this.adapter2job.put(ExchangeEMailAdapter.class, ExchangeMailTask.class);
        this.adapter2job.put(ExchangeEWSAdapter.class, MSEWSTask.class);
        this.adapter2job.put(ExchangeEWSOnlineAdapter.class, MSEWSOnlineTask.class);
        this.adapter2job.put(ExchangeGraphAdapter.class, MSGraphTask.class);
        this.adapter2job.put(DEAEMSAdapter.class, DeaEmsTask.class);
        this.adapter2job.put(AscTimeTablesAdapter.class, AscTimeTablesTask.class);
        this.adapter2job.put(WebUntisAdapter.class, WebUntisTask.class);
        this.adapter2job.put(XMLAdapter.class, XMLTask.class);
        this.adapter2job.put(ICalendarAdapter.class, ICalendarTask.class);
        this.adapter2job.put(GoogleCalendarAdapter.class, GoogleCalendarTask.class);
        this.adapter2job.put(CsvAdapter.class, CsvTask.class);
        this.adapter2job.put(HttpGeneralAdapter.class, HttpGeneralTask.class);
        this.adapter2job.put(SystemMonitorAdapter.class, SystemMonitorTask.class);
        this.adapter2job.put(EnergySaverAdapter.class, EnergySaverTask.class);
        this.adapter2job.put(WilkeSimpleEventsAdapter.class, SimpleEventsTask.class);
    }

    @Override
    public boolean run() {
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : FileAdapterManager.getManager().getAllAdapters()) {
            logger.info("AllAdapter:" + abstractAdapterConfiguration.getName() + "/" + abstractAdapterConfiguration.getType());
        }
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : FileAdapterManager.getManager().getEnabledAdapters(LicenseManager.getManager())) {
            if (abstractAdapterConfiguration.getErrors().size() != 0) continue;
            this.add(abstractAdapterConfiguration);
        }
        this.is_running = true;
        return true;
    }

    private void add(AbstractAdapterConfiguration abstractAdapterConfiguration) {
        Object object;
        AdapterJob adapterJob = null;
        try {
            object = this.adapter2job.get(abstractAdapterConfiguration.getClass());
            if (object == null) {
                logger.fatal("Unknown adapter: " + abstractAdapterConfiguration.getName());
                return;
            }
            Constructor<? extends AdapterJob> constructor = ((Class)object).getConstructor(Logger.class, AbstractAdapterConfiguration.class, EventScheduler.class);
            adapterJob = constructor.newInstance(LogManager.getLogger(constructor), abstractAdapterConfiguration, this.em.getScheduler());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.fatal("Bad adapter: NoSuchMethodException:" + noSuchMethodException.getMessage());
            return;
        }
        catch (SecurityException securityException) {
            logger.fatal("Bad adapter: SecurityException:" + securityException.getMessage());
            return;
        }
        catch (InstantiationException instantiationException) {
            logger.fatal("Bad adapter: InstantiationException:" + instantiationException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.fatal("Bad adapter: IllegalAccessException:" + illegalAccessException.getMessage());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.fatal("Bad adapter: IllegalArgumentException:" + illegalArgumentException.getMessage());
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.fatal("Bad adapter: InvocationTargetException:" + invocationTargetException.getCause().getClass());
            logger.fatal(invocationTargetException.toString());
            logger.fatal(invocationTargetException.getCause().toString());
            return;
        }
        logger.info("New adapter: " + abstractAdapterConfiguration.getName() + "/" + abstractAdapterConfiguration.getType() + "/" + abstractAdapterConfiguration.getIntervalSecs() + "s/" + abstractAdapterConfiguration.toString());
        this.m_tasks.put(abstractAdapterConfiguration.getName(), adapterJob);
        object = new Timer("WP-A-" + abstractAdapterConfiguration.getName());
        ((Timer)object).scheduleAtFixedRate((TimerTask)adapterJob, 1000L, (long)abstractAdapterConfiguration.getIntervalSecs() * 1000L);
    }

    @Override
    public void stop() {
        this.is_running = false;
        for (Map.Entry<String, AdapterJob> entry : this.m_tasks.entrySet()) {
            entry.getValue().stop(1000L);
        }
        this.m_tasks.clear();
    }

    @Override
    public boolean isRunning() {
        return this.is_running;
    }

    private synchronized void what_to_do() {
        Object object22;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Object object22 : FileAdapterManager.getManager().getEnabledAdapters(LicenseManager.getManager())) {
            if (object22.getErrors().size() != 0) continue;
            hashMap.put(object22.getName(), object22);
            boolean bl = false;
            for (Map.Entry<String, AdapterJob> entry : this.m_tasks.entrySet()) {
                if (!entry.getKey().equals(object22.getName()) || !entry.getValue().getAdapter().equals(object22)) continue;
                bl = true;
            }
            if (bl) continue;
            hashMap2.put(object22.getName(), object22);
        }
        LinkedList linkedList = new LinkedList();
        for (Map.Entry entry : this.m_tasks.entrySet()) {
            if (hashMap.keySet().contains(entry.getKey()) && hashMap.values().contains(((AdapterJob)entry.getValue()).getAdapter())) continue;
            linkedList.add((String)entry.getKey());
        }
        logger.info("NEWADAPTERS: NOW[{}] NEW[{}] => DEL[{}] ADD[{}]", (Object)WpUtils.implode((String)",", this.m_tasks.keySet()), (Object)WpUtils.implode((String)",", hashMap.keySet()), (Object)WpUtils.implode((String)",", (Collection)linkedList), (Object)WpUtils.implode((String)",", hashMap2.keySet()));
        object22 = linkedList.iterator();
        while (object22.hasNext()) {
            String string = (String)object22.next();
            this.remove(string);
        }
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : hashMap2.values()) {
            this.add(abstractAdapterConfiguration);
        }
    }

    private void remove(String string) {
        AdapterJob adapterJob = this.m_tasks.remove(string);
        if (adapterJob != null) {
            adapterJob.stop(1000L);
            logger.info("Removed adapter: {}", (Object)string);
            this.em.getScheduler().removeAdapterStuff(string);
        }
    }
}

