/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import de.wilke.wizepanel.core.Schadchen;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.core.warnings.WarningList;
import de.wilke.wizepanel.core.warnings.WarningListEntry;
import de.wilke.wizepanel.eventmanager.FileAdapterManager;
import de.wilke.wizepanel.eventmanager.RulesLibrary;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.ruleslib.Rule;
import de.wilke.wizepanel.server.Services;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.templates.TemplateInfo;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;

public class Warnings {
    private static final Logger logger = LogManager.getLogger(Warnings.class);
    private final WarningList warnings = new WarningList();
    private static final Warnings _instance = new Warnings();
    private static int last_hash = 0;

    private Warnings() {
    }

    public static Warnings getInstance() {
        return _instance;
    }

    public synchronized void reset(boolean bl) {
        this.warnings.entries().clear();
        this.check_files();
        this.check_adapters();
        this.check_licenses();
        this.check_templates();
        this.check_rules();
        this.check_unused_adapter_sources();
        if (bl) {
            this.regularCheckPanels();
            this.regularCheckRouters();
        }
    }

    private void check_unused_adapter_sources() {
        Map map = Services.app.eventManager().getSchadchen().getUnusedSources(FileAdapterManager.getManager().getEnabledAdapters(LicenseManager.getManager()));
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : map.keySet()) {
            for (String string : (List)map.get(abstractAdapterConfiguration)) {
                this.addAdapterWarning(abstractAdapterConfiguration, "Source not used: " + string);
            }
        }
    }

    private void check_files() {
        for (String string : WpSystemLocator.getLocator().getErrors()) {
            this.add(WarningListEntry.Type.Error, WarningListEntry.Source.General, "Warnings", string);
        }
        for (String string : WpUpiServerStaticFactory.getServerLocator().getErrors()) {
            this.add(WarningListEntry.Type.Error, WarningListEntry.Source.General, "Warnings", string);
        }
    }

    private void check_adapters() {
        HashMap<String, Display> hashMap = new HashMap<String, Display>();
        for (WizePanelItemType wizePanelItemType : WpDataManager.getManager().getWizepanels()) {
            hashMap.put(wizePanelItemType.params().getName(), wizePanelItemType.getDisplay());
        }
        for (WizePanelItemType wizePanelItemType : FileAdapterManager.getManager().getEnabledAdapters(LicenseManager.getManager())) {
            for (String string : wizePanelItemType.getErrors()) {
                this.addAdapterError((AbstractAdapterConfiguration)wizePanelItemType, string);
            }
        }
    }

    private void check_licenses() {
        logger.info("checking for bad adapter usage ...");
        HashMap hashMap = new HashMap();
        Map map = Services.app.eventManager().getSchadchen().getAllConfigs();
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            for (Schadchen.AdapterPart adapterPart : (List)entry.getValue()) {
                List list;
                Integer n = (Integer)LicenseManager.getManager().getLicenses().get(adapterPart.type);
                if (n != null && n > 0) {
                    if (hashMap.containsKey(adapterPart.type)) {
                        if (((List)hashMap.get(adapterPart.type)).contains(entry.getKey())) continue;
                        if (n > ((List)hashMap.get(adapterPart.type)).size()) {
                            list = (List)hashMap.get(adapterPart.type);
                            list.add((String)entry.getKey());
                            hashMap.put(adapterPart.type, list);
                            continue;
                        }
                        bl = true;
                        list = Services.app.eventManager().getSchadchen().getConfig((String)entry.getKey());
                        list.remove(adapterPart);
                        Services.app.eventManager().getSchadchen().setConfig((String)entry.getKey(), list);
                        continue;
                    }
                    list = new LinkedList<String>();
                    list.add((String)entry.getKey());
                    hashMap.put(adapterPart.type, list);
                    continue;
                }
                bl = true;
                list = Services.app.eventManager().getSchadchen().getConfig((String)entry.getKey());
                list.remove(adapterPart);
                Services.app.eventManager().getSchadchen().setConfig((String)entry.getKey(), list);
            }
        }
        if (bl) {
            this.add(WarningListEntry.Type.Warning, WarningListEntry.Source.General, "Warnings", "there was some bad adapter usage, extra source usages has been deleted!");
            Services.app.eventManager().getSchadchen().save(WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SCHADCHEN_CFG_FILE));
        } else {
            logger.info("no bad adapter usage!");
        }
    }

    private void check_rules() {
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        RulesLibrary rulesLibrary = RulesLibrary.getSingleton();
        boolean bl = false;
        Iterator iterator = rulesLibrary.getRules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            String string = rule.getPlaceholderValue("TARGET_NAME");
            if (string == null || upiRoutingHandler.getTargetByName(string) != null) continue;
            this.add(WarningListEntry.Type.Warning, WarningListEntry.Source.General, "Warnings", MessageFormat.format("Removing rule: {0}", rule.getRuleString()));
            iterator.remove();
            bl = true;
        }
        if (bl) {
            rulesLibrary.save();
        }
    }

    private void check_templates() {
        RulesLibrary rulesLibrary = RulesLibrary.getSingleton();
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
            for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                Rule rule = rulesLibrary.blankRule(upiTargetItem.getParams().getName());
                if (rule == null || rule.getTemplate().isEmpty()) {
                    this.addTargetWarning(upiTargetItem, "Missing no-event template");
                } else {
                    this.check_template_type(upiTargetItem, rule.getTemplate(), false);
                }
                String string = rulesLibrary.getSingleTemplate(upiTargetItem.getParams().getName());
                String string2 = rulesLibrary.getManyTemplate(upiTargetItem.getParams().getName());
                if (string == null && string2 == null) {
                    this.addTargetWarning(upiTargetItem, "Select either single-event or multiple-event template");
                }
                if (string != null) {
                    this.check_template_type(upiTargetItem, string, true);
                }
                if (string2 == null) continue;
                this.check_template_type(upiTargetItem, string2, true);
            }
        }
    }

    private void check_template_type(UpiTargetItem upiTargetItem, String string, boolean bl) {
        TemplateInfo templateInfo = Services.app.templateManager().getInfo(string);
        if (templateInfo == null) {
            this.addTargetWarning(upiTargetItem, MessageFormat.format("Could not open template ''{0}''", string));
            return;
        }
        if (templateInfo.display().getType().id != upiTargetItem.getParams().getType()) {
            this.addTargetWarning(upiTargetItem, MessageFormat.format("Template ''{0}'' has type ''{1}'' whereas target has type ''{2}''", string, templateInfo.display().getType().id, upiTargetItem.getParams().getType()));
        }
        if (bl) {
            int n;
            List list = Services.app.eventManager().getSchadchen().getSources(upiTargetItem.getParams().getName());
            int n2 = n = list == null ? -1 : list.size();
            if (templateInfo.numberOfSources() < n) {
                this.addTargetWarning(upiTargetItem, MessageFormat.format("Template ''{0}'' has ''{1}'' sources whereas target has ''{2}'' sources", string, templateInfo.numberOfSources(), n));
            }
        }
    }

    private synchronized void add(WarningListEntry.Type type, WarningListEntry.Source source, String string, String string2) {
        WarningListEntry warningListEntry = null;
        for (WarningListEntry warningListEntry2 : this.warnings.entries()) {
            if (warningListEntry2.source != source || !warningListEntry2.source_details.equals(string) || !warningListEntry2.message.equals(string2) || warningListEntry2.type != type) continue;
            warningListEntry = warningListEntry2;
            break;
        }
        if (warningListEntry == null) {
            Level level = Level.ERROR;
            if (type == WarningListEntry.Type.Warning) {
                level = Level.WARN;
            } else if (type == WarningListEntry.Type.Information) {
                level = Level.INFO;
            }
            logger.log(level, "[{}:{}] {}", (Object)source, (Object)string, (Object)string2);
            this.warnings.add(type, source, string, System.currentTimeMillis(), string2);
        } else {
            warningListEntry.timestamp = System.currentTimeMillis();
        }
        last_hash = 0;
    }

    public void addTargetWarning(String string, String string2) {
        this.add(WarningListEntry.Type.Warning, WarningListEntry.Source.Target, string, string2);
    }

    public void addTargetError(UpiTargetItem upiTargetItem, String string) {
        this.add(WarningListEntry.Type.Error, WarningListEntry.Source.Target, upiTargetItem.getParams().getName(), string);
    }

    public void addTargetError(String string, String string2) {
        this.add(WarningListEntry.Type.Error, WarningListEntry.Source.Target, string, string2);
    }

    private void addTargetWarning(UpiTargetItem upiTargetItem, String string) {
        this.addTargetWarning(upiTargetItem.getParams().getName(), string);
    }

    public void addTargetInfo(String string, String string2) {
        this.add(WarningListEntry.Type.Information, WarningListEntry.Source.Target, string, string2);
    }

    public void addAdapterWarning(AbstractAdapterConfiguration abstractAdapterConfiguration, String string) {
        this.add(WarningListEntry.Type.Warning, WarningListEntry.Source.Adapter, abstractAdapterConfiguration.getName(), string);
    }

    public void addAdapterError(AbstractAdapterConfiguration abstractAdapterConfiguration, String string) {
        this.add(WarningListEntry.Type.Error, WarningListEntry.Source.Adapter, abstractAdapterConfiguration.getName(), string);
    }

    public void addWarning(String string, String string2) {
        this.add(WarningListEntry.Type.Warning, WarningListEntry.Source.General, string, string2);
    }

    public void addRouterError(String string, String string2) {
        this.add(WarningListEntry.Type.Error, WarningListEntry.Source.Router, string, string2);
    }

    public synchronized String toJSONString(int n) throws JSONException {
        if (n == -1) {
            this.reset(true);
        } else if (last_hash != 0 && n == last_hash) {
            return "";
        }
        String string = this.warnings.toJSONString();
        last_hash = n;
        return string;
    }

    public synchronized List<WarningListEntry> toList(boolean bl) {
        last_hash = 0;
        if (bl) {
            this.reset(true);
        }
        return new LinkedList<WarningListEntry>(this.warnings.entries());
    }

    public synchronized void regularCleanup() {
        long l = System.currentTimeMillis() - 86400000L;
        Iterator iterator = this.warnings.entries().iterator();
        while (iterator.hasNext()) {
            if (((WarningListEntry)iterator.next()).timestamp >= l) continue;
            iterator.remove();
            last_hash = 0;
        }
    }

    public void regularCheckRouters() {
        WpDataManager wpDataManager = WpDataManager.getManager();
        long l = System.currentTimeMillis() - 300000L;
        for (String string : DispatcherPool.getPool().getDispatchers()) {
            DispatcherItemType dispatcherItemType = wpDataManager.getDispatcherById(string);
            if (dispatcherItemType == null || dispatcherItemType.isLastUpdateSuccessful() || dispatcherItemType.getLastUpdate() == 0L || dispatcherItemType.getLastUpdate() >= l || dispatcherItemType.params().getIp().equals("0.0.0.0")) continue;
            this.addRouterError(dispatcherItemType.getId(), "Dispatcher is offline: " + dispatcherItemType.params().getIp() + ":" + dispatcherItemType.params().getPort() + " (last update: " + WpTimeUtils.date2str((Date)new Date(dispatcherItemType.getLastUpdate())) + ")");
        }
    }

    public void regularCheckPanels() {
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
            for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                if (upiTargetItem.getParams().getBatteryLevel() > 0 && upiTargetItem.getParams().getBatteryLevel() < 15) {
                    this.addTargetError(upiTargetItem, "Low battery level < 15%");
                }
                int n = upiTargetItem.getParams().getWakeup() * 10;
                if (upiTargetItem.getParams().getLastSeen() <= n) continue;
                this.addTargetError(upiTargetItem, "Last seen > " + WpTimeUtils.secondsPrettyPrinter((int)n));
            }
        }
    }
}

