/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import java.io.File;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

public class WpFileMonitor {
    private static final WpFileMonitor SINGLETON = new WpFileMonitor();
    private final Timer timer = new Timer("WP-File-Monitor", true);
    private final Hashtable<String, WpFileMonitorTask> timerTasks = new Hashtable();

    private WpFileMonitor() {
    }

    public static WpFileMonitor getInstance() {
        return SINGLETON;
    }

    public void addChangeListener(WpFileChangeListener wpFileChangeListener, String string, long l) {
        this.removeChangeListener(wpFileChangeListener, string);
        WpFileMonitorTask wpFileMonitorTask = new WpFileMonitorTask(wpFileChangeListener, string);
        this.timerTasks.put(string + wpFileChangeListener.hashCode(), wpFileMonitorTask);
        this.timer.schedule((TimerTask)wpFileMonitorTask, l, l);
    }

    public void removeChangeListener(WpFileChangeListener wpFileChangeListener, String string) {
        WpFileMonitorTask wpFileMonitorTask = this.timerTasks.remove(string + wpFileChangeListener.hashCode());
        if (wpFileMonitorTask != null) {
            wpFileMonitorTask.cancel();
        }
    }

    public void checkNow(WpFileChangeListener wpFileChangeListener, String string) {
        WpFileMonitorTask wpFileMonitorTask = this.timerTasks.get(string + wpFileChangeListener.hashCode());
        if (null != wpFileMonitorTask) {
            wpFileMonitorTask.run();
        }
    }

    protected void fireFileChangeEvent(WpFileChangeListener wpFileChangeListener, String string) {
        wpFileChangeListener.fileChanged(string);
    }

    public static interface WpFileChangeListener {
        public void fileChanged(String var1);
    }

    class WpFileMonitorTask
    extends TimerTask {
        WpFileChangeListener listener;
        String fileName;
        File monitoredFile;
        long lastModified;
        final ReentrantLock lock = new ReentrantLock();

        public WpFileMonitorTask(WpFileChangeListener wpFileChangeListener, String string) {
            this.listener = wpFileChangeListener;
            this.fileName = string;
            this.lastModified = 0L;
            this.monitoredFile = new File(string);
            this.lastModified = this.getLastModified();
        }

        private long getLastModified() {
            if (this.monitoredFile.exists()) {
                return this.monitoredFile.lastModified();
            }
            return -1L;
        }

        @Override
        public void run() {
            this.lock.lock();
            long l = this.getLastModified();
            if (l != this.lastModified) {
                this.lastModified = l;
                this.lock.unlock();
                WpFileMonitor.this.fireFileChangeEvent(this.listener, this.fileName);
            }
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }
}

