/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server.backup_restore;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.server.backup_restore.FilesOfInterest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BackupRestore {
    public static void exportTo(String string) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (String string2 : FilesOfInterest.files) {
                BackupRestore.addToZipFile(string2, zipOutputStream);
            }
            for (String string2 : FilesOfInterest.directories) {
                WpFile wpFile = new WpFile("${env_var:WIZEPANEL_HOME}/" + string2);
                for (String string3 : wpFile.list()) {
                    BackupRestore.addToZipFile(string2 + File.separator + string3, zipOutputStream);
                }
            }
        }
    }

    public static void importFrom(String string) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(string);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry zipEntry;
            WpFile wpFile = new WpFile("${env_var:WIZEPANEL_HOME}/");
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                System.out.println("ENTRY: " + zipEntry.getName());
                BackupRestore.extractFromZipFile(wpFile.getJavaFile().getAbsolutePath(), zipInputStream, zipEntry);
            }
        }
    }

    private static void addToZipFile(String string, ZipOutputStream zipOutputStream) throws FileNotFoundException, IOException {
        System.out.println("Writing '" + string + "' to zip file");
        WpFile wpFile = new WpFile("${env_var:WIZEPANEL_HOME}/" + string);
        try (FileInputStream fileInputStream = new FileInputStream(wpFile.getJavaFile());){
            int n;
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
    }

    private static void extractFromZipFile(String string, ZipInputStream zipInputStream, ZipEntry zipEntry) throws Exception {
        File file = new File(string + "/" + zipEntry.getName());
        file.getParentFile().mkdirs();
        byte[] byArray = new byte[2048];
        try (FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsoluteFile());){
            int n = 0;
            while ((n = zipInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
    }
}

