/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server.http;

import de.wilke.wizepanel.core.Schadchen;
import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.core.server.GetNextEventsInterrupted;
import de.wilke.wizepanel.core.server.ServerReply;
import de.wilke.wizepanel.core.server.ServerReplyNotChanged;
import de.wilke.wizepanel.core.server.ServerRequest;
import de.wilke.wizepanel.core.server.transfer.EventList;
import de.wilke.wizepanel.core.server.transfer.SimpleEventsList;
import de.wilke.wizepanel.core.users.UserManager;
import de.wilke.wizepanel.eventmanager.FileAdapterManager;
import de.wilke.wizepanel.eventmanager.RulesLibrary;
import de.wilke.wizepanel.eventmanager.WPEventManager;
import de.wilke.wizepanel.eventmanager.cache.CacheEvent;
import de.wilke.wizepanel.eventmanager.cache.CacheResult;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarUtils;
import de.wilke.wizepanel.jms.session.WpSession;
import de.wilke.wizepanel.prot.basic.CommInvoker;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmDispGetFirmwareVer;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.ServiceUtils;
import de.wilke.wizepanel.server.Services;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.backup_restore.BackupRestore;
import de.wilke.wizepanel.server.http.SessionHandler;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.server.http.adaptertests.AdapterTesterFactory;
import de.wilke.wizepanel.sessions.Communicator;
import de.wilke.wizepanel.simple_events.SimpleEventsServer;
import de.wilke.wizepanel.templates.TemplateManager;
import de.wilke.wizepanel.upi.UpiUtils;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.engine.proxy.WpUpiServerDataProxy;
import de.wilke.wizepanel.upi.engine.transactions.FinalImage;
import de.wilke.wizepanel.upi.res.system.WpUpiSystemResDynamicRouting;
import de.wilke.wizepanel.upi.res.system.WpUpiSystemResVersion;
import de.wilke.wizepanel.upi.res.transaction.WpUpiTransaction;
import de.wilke.wizepanel.upi.res.transaction.WpUpiTransactionCancel;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AdminCmdParser {
    private static final Logger m_logger = LogManager.getLogger(AdminCmdParser.class);
    private static final String ERR_WRONG_NUM_ARGS = "Wrong number of arguments.";
    private static final String ERR_COULD_NOT_OPEN_FILE = "Could not open file";
    private static final String ERR_COULD_NOT_SAVE_FILE = "Could not save to file";
    private static final String ERR_COULD_NOT_FIND_TARGET = "Could not find target";
    static ArrayList<String> TempMods = new ArrayList();
    static ArrayList<String> lastTempMods = new ArrayList();
    static ArrayList<String> AdapMods = new ArrayList();
    static ArrayList<String> lastAdapMods = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(String string) {
        ServerReply serverReply = new ServerReply();
        try {
            ServerRequest serverRequest = new ServerRequest(string);
            m_logger.debug("NEW command: {}", (Object)serverRequest.toLog());
            try {
                switch (serverRequest.getCommand()) {
                    case LICENSE: {
                        serverReply.setOK(this.license());
                        break;
                    }
                    case STATUS: {
                        serverReply.setOK(ServiceUtils.getStatus());
                        break;
                    }
                    case UPI_VERSION: {
                        WpUpiSystemResVersion wpUpiSystemResVersion = new WpUpiSystemResVersion();
                        serverReply.setOK(wpUpiSystemResVersion.getSystemVersion());
                        break;
                    }
                    case UPI_TRANSACTION: {
                        WpUpiTransaction wpUpiTransaction = new WpUpiTransaction();
                        serverReply.setOK(wpUpiTransaction.getTransactionStatus(serverRequest.getData()));
                        break;
                    }
                    case UPI_TRANSACTION_CANCEL: {
                        WpUpiTransactionCancel wpUpiTransactionCancel = new WpUpiTransactionCancel();
                        serverReply.setOK(wpUpiTransactionCancel.get(serverRequest.getData()));
                        break;
                    }
                    case UPI_DYNROUTING: {
                        DispatcherPool.getPool().sendUpdateStatsToAllDispatchers();
                        WpUpiSystemResDynamicRouting wpUpiSystemResDynamicRouting = new WpUpiSystemResDynamicRouting();
                        serverReply.setOK(wpUpiSystemResDynamicRouting.get());
                        break;
                    }
                    case WARNINGS: {
                        serverReply.setOK(Warnings.getInstance().toJSONString(Integer.parseInt(serverRequest.getData())));
                        break;
                    }
                    case ROUTING: {
                        serverReply.setOK(this.routing(serverRequest));
                        break;
                    }
                    case RULES_GET: {
                        serverReply.setOK(this.rules_get(serverRequest));
                        break;
                    }
                    case RULES_PUT: {
                        serverReply.setOK(this.rules_put(serverRequest));
                        break;
                    }
                    case DISPLAYS: {
                        serverReply.setOK(this.displays());
                        break;
                    }
                    case TARGET_NAME: {
                        serverReply.setOK(this.target_name(serverRequest.getData()));
                        break;
                    }
                    case TARGET_ROTATION: {
                        serverReply.setOK(this.target_rotation(serverRequest.getData()));
                        break;
                    }
                    case TARGET_COMMENT: {
                        serverReply.setOK(this.target_comment(serverRequest.getData()));
                        break;
                    }
                    case TARGET_LAST_IMAGE: {
                        serverReply.setOK(this.target_last_image(serverRequest));
                        break;
                    }
                    case ROUTER_PING: {
                        serverReply.setOK(this.router_ping(serverRequest.getData()));
                        break;
                    }
                    case ROUTER_IDENT: {
                        serverReply.setOK(this.router_ident(serverRequest.getData()));
                        break;
                    }
                    case ROUTER_TIMEZONE: {
                        serverReply.setOK(this.router_timezone(serverRequest.getData()));
                        break;
                    }
                    case ROUTER_NAME: {
                        serverReply.setOK(this.router_name(serverRequest.getData()));
                        break;
                    }
                    case ROUTER_ADD: {
                        serverReply.setOK(this.router_add(serverRequest.getData()));
                        break;
                    }
                    case SESSIONS_LIST: {
                        serverReply.setOK(this.sessions_list(serverRequest));
                        break;
                    }
                    case SESSIONS_ADD: {
                        Communicator.instance.add(new WpSession(serverRequest.getData()));
                        serverReply.setOK("");
                        break;
                    }
                    case SESSION_FIND: {
                        List<WpSession> list;
                        if (serverRequest.getData().isEmpty()) {
                            serverReply.setError("id empty");
                            break;
                        }
                        boolean bl = true;
                        List<WpSession> list2 = list = Communicator.instance.getFinishedSessions();
                        synchronized (list2) {
                            for (WpSession wpSession : list) {
                                if (!wpSession.getAttributes().getID().equalsIgnoreCase(serverRequest.getData())) continue;
                                serverReply.setOK(wpSession.getResponse().getResponseData());
                                bl = false;
                                break;
                            }
                        }
                        if (!bl) break;
                        serverReply.setError("Not found!");
                        break;
                    }
                    case TEMPLATE_LIST: {
                        serverReply.setOK(this.template_list(serverRequest));
                        break;
                    }
                    case TEMPLATE_GET: {
                        serverReply.setOK(this.template_get(serverRequest.getData()));
                        break;
                    }
                    case TEMPLATE_PUT: {
                        serverReply.setOK(this.template_put(serverRequest));
                        break;
                    }
                    case TEMPLATE_RENAME: {
                        serverReply.setOK(this.template_rename(serverRequest));
                        break;
                    }
                    case TEMPLATE_FONTLIST: {
                        serverReply.setOK(this.template_fontlist());
                        break;
                    }
                    case SYSTEM_EXPORT: {
                        serverReply.setOK(this.system_export(serverRequest.getData()));
                        break;
                    }
                    case SYSTEM_IMPORT: {
                        serverReply.setOK(this.system_import(serverRequest.getData()));
                        break;
                    }
                    case NEXT_EVENTS: {
                        serverReply.setOK(this.next_events(serverRequest));
                        break;
                    }
                    case EVENTS_RESEND: {
                        serverReply.setOK(this.events_resend(serverRequest.getData()));
                        break;
                    }
                    case ADAPTERS_GET: {
                        serverReply.setOK(this.adapters_get(serverRequest));
                        break;
                    }
                    case ADAPTERS_PUT: {
                        serverReply.setOK(this.adapters_put(serverRequest));
                        break;
                    }
                    case ADAPTERS_TEST: {
                        serverReply.setOK(this.adapters_test(serverRequest));
                        break;
                    }
                    case ADAPTERS_RENAME: {
                        serverReply.setOK(this.adapters_rename(serverRequest));
                        break;
                    }
                    case RESOURCE_GET: {
                        serverReply.setOK(this.resource_get(serverRequest.getData()));
                        break;
                    }
                    case RESOURCE_PUT: {
                        serverReply.setOK(this.resource_put(serverRequest));
                        break;
                    }
                    case SCHADCHEN_GET: {
                        serverReply.setOK(this.schadchen_get(serverRequest));
                        break;
                    }
                    case SCHADCHEN_PUT: {
                        serverReply.setOK(this.schadchen_put(serverRequest.getData()));
                        break;
                    }
                    case USERS_GET: {
                        serverReply.setOK(this.users_get(serverRequest));
                        break;
                    }
                    case USERS_PUT: {
                        serverReply.setOK(this.users_put(serverRequest.getData()));
                        break;
                    }
                    case GROUPS_GET: {
                        serverReply.setOK(this.groups_get(serverRequest));
                        break;
                    }
                    case GROUPS_PUT: {
                        serverReply.setOK(this.groups_put(serverRequest.getData()));
                        break;
                    }
                    case CURRENT_GROUP_GET: {
                        serverReply.setOK(this.current_group_get(serverRequest.getData()));
                        break;
                    }
                    case CURRENT_MAIN_GROUP_GET: {
                        serverReply.setOK(this.current_main_group_get(serverRequest.getData()));
                        break;
                    }
                    case SIMPLE_EVENTS_GET_ROOMS: {
                        serverReply.setOK(this.simple_events_get_rooms());
                        break;
                    }
                    case SIMPLE_EVENTS_PUT_ROOMS: {
                        serverReply.setOK(this.simple_events_put_rooms(serverRequest.getData()));
                        break;
                    }
                    case SIMPLE_EVENTS_PUT_EVENT: {
                        serverReply.setOK(this.simple_events_put_event(serverRequest.getData()));
                        break;
                    }
                    case SIMPLE_EVENTS_GET_EVENT: {
                        serverReply.setOK(this.simple_events_get_event(serverRequest.getData()));
                        break;
                    }
                    case SIMPLE_EVENTS_DEL_EVENT: {
                        serverReply.setOK(this.simple_events_del_event(serverRequest.getData()));
                        break;
                    }
                    case NEXT_SIMPLE_EVENTS: {
                        serverReply.setOK(this.next_simple_events(serverRequest));
                        break;
                    }
                    case WIZEPANEL_LOCALE_GET_ALL: {
                        serverReply.setOK(this.get_all_java_locales());
                        break;
                    }
                    case WIZEPANEL_LOCALE_GET: {
                        serverReply.setOK(this.get_WizePanel_Locale(serverRequest.getData()));
                        break;
                    }
                    case WIZEPANEL_LOCALE_PUT: {
                        serverReply.setOK(this.put_WizePanel_Locale(serverRequest.getData().split("/")[0], serverRequest.getData().split("/")[1]));
                        break;
                    }
                    case TIMETABLE_START_DAY_GET: {
                        serverReply.setOK(this.getTimetableStartDay(serverRequest.getData()));
                        break;
                    }
                    case TIMETABLE_START_DAY_PUT: {
                        serverReply.setOK(this.putTimetableStartDay(serverRequest.getData().split("/")[0], serverRequest.getData().split("/")[1]));
                        break;
                    }
                    case EVENT_HISTORY_DURATION_GET: {
                        serverReply.setOK(this.getEventHistoryDuration(serverRequest.getData()));
                        break;
                    }
                    case EVENT_HISTORY_DURATION_PUT: {
                        serverReply.setOK(this.putEventHistoryDuration(serverRequest.getData().split("/")[0], serverRequest.getData().split("/")[1]));
                        break;
                    }
                    case SET_TEMP_LOCK: {
                        serverReply.setOK(this.putTempLock(serverRequest.getData()));
                        break;
                    }
                    case FORCE_SET_TEMP_LOCK: {
                        serverReply.setOK(this.forcePutTempLock(serverRequest.getData()));
                        break;
                    }
                    case LIFT_TEMP_LOCK: {
                        serverReply.setOK(this.liftTempLock(serverRequest.getData()));
                        break;
                    }
                    case GET_TEMP_LOCK: {
                        serverReply.setOK(this.getTempLock(serverRequest.getData()));
                        break;
                    }
                    case GET_LATEST_TEMPM: {
                        serverReply.setOK(this.getTempLatestModifier(serverRequest.getData()));
                        break;
                    }
                    case SET_LATEST_TEMPM: {
                        serverReply.setOK(this.setTempLatestModifier(serverRequest.getData()));
                        break;
                    }
                    case SET_ADAP_LOCK: {
                        serverReply.setOK(this.putAdapLock(serverRequest.getData()));
                        break;
                    }
                    case LIFT_ADAP_LOCK: {
                        serverReply.setOK(this.liftAdapLock(serverRequest.getData()));
                        break;
                    }
                    case GET_LATEST_ADAPM: {
                        serverReply.setOK(this.getAdapLatestModifier(serverRequest.getData()));
                        break;
                    }
                    case SET_LATEST_ADAPM: {
                        serverReply.setOK(this.setAdapLatestModifier(serverRequest.getData()));
                    }
                }
            }
            catch (ServerReplyNotChanged serverReplyNotChanged) {
                serverReply.setNotChanged();
            }
            m_logger.debug("REPLY: {}", (Object)serverReply.toLog(serverRequest.getCommand()));
        }
        catch (Exception exception) {
            m_logger.error(exception.getMessage(), (Throwable)exception);
            serverReply.setError(exception.getMessage());
        }
        return serverReply.toString();
    }

    private String putTempLock(String string) {
        for (String string2 : TempMods) {
            if (!string2.startsWith(string.split("/")[0])) continue;
            return "";
        }
        TempMods.add(string);
        return "";
    }

    private String forcePutTempLock(String string) {
        Iterator<String> iterator = TempMods.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string.split("/")[0])) continue;
            iterator.remove();
        }
        TempMods.add(string);
        return "";
    }

    private String liftTempLock(String string) {
        Iterator<String> iterator = TempMods.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.startsWith(string.split("/")[0]) && !string2.equals(string)) {
                return "false";
            }
            if (!string2.equals(string)) continue;
            iterator.remove();
            return "true";
        }
        return "true";
    }

    private String getTempLock(String string) {
        for (String string2 : TempMods) {
            if (string2.startsWith(string.split("/")[0]) && !string2.equals(string)) {
                return "false";
            }
            if (!string2.equals(string)) continue;
            return "true";
        }
        return "true";
    }

    private String getTempLatestModifier(String string) {
        for (String string2 : lastTempMods) {
            if (!string2.startsWith(string)) continue;
            return string2.split("/")[1];
        }
        return "";
    }

    private String setTempLatestModifier(String object) {
        object = (String)object + "/" + String.valueOf(new Date().getTime());
        Iterator<String> iterator = lastTempMods.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.startsWith(((String)object).split("/")[0])) continue;
            iterator.remove();
        }
        lastTempMods.add((String)object);
        return ((String)object).split("/")[1];
    }

    private String putAdapLock(String string) {
        for (String string2 : AdapMods) {
            if (!string2.startsWith(string.split("/")[0])) continue;
            return "";
        }
        AdapMods.add(string);
        return "";
    }

    private String liftAdapLock(String string) {
        Iterator<String> iterator = AdapMods.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.startsWith(string.split("/")[0]) && !string2.equals(string)) {
                return "false";
            }
            if (!string2.equals(string)) continue;
            iterator.remove();
            return "true";
        }
        return "true";
    }

    private String getAdapLatestModifier(String string) {
        for (String string2 : lastAdapMods) {
            if (!string2.startsWith(string)) continue;
            return string2.split("/")[1];
        }
        return "";
    }

    private String setAdapLatestModifier(String object) {
        object = (String)object + "/" + String.valueOf(new Date().getTime());
        Iterator<String> iterator = lastAdapMods.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.startsWith(((String)object).split("/")[0])) continue;
            iterator.remove();
        }
        lastAdapMods.add((String)object);
        return ((String)object).split("/")[1];
    }

    private String schadchen_get(ServerRequest serverRequest) {
        return Services.app.eventManager().getSchadchen().toString();
    }

    private String schadchen_put(String string) {
        Schadchen schadchen = Services.app.eventManager().getSchadchen();
        if (schadchen.fromString(string, FileAdapterManager.getManager().getAllAdapters())) {
            schadchen.save(WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SCHADCHEN_CFG_FILE));
        }
        return "";
    }

    private String users_get(ServerRequest serverRequest) {
        return UserManager.getManager().toString();
    }

    private String users_put(String string) {
        if (UserManager.getManager().fromString(string)) {
            UserManager.getManager().saveToFile(WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.USER_MANAGEMENT_FILE));
        }
        return "";
    }

    private String current_group_get(String string) {
        try {
            return SessionHandler.accept(string, null, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "none";
        }
    }

    private String current_main_group_get(String string) {
        try {
            return SessionHandler.getMainGroup(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "none";
        }
    }

    private String groups_get(ServerRequest serverRequest) throws Exception {
        String string = GroupManager.getManager().toString();
        if ((long)string.hashCode() == serverRequest.getHash()) {
            throw new ServerReplyNotChanged();
        }
        return string;
    }

    private String groups_put(String string) {
        if (GroupManager.getManager().fromString(string)) {
            GroupManager.getManager().saveToFile(WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.GROUP_MANAGEMENT_FILE));
        }
        return "";
    }

    private String rules_get(ServerRequest serverRequest) throws Exception {
        String string = WpFileUtils.readTextFile((File)new File(WpSystemLocator.getLocator().getRulesDBFile()));
        if ((long)string.hashCode() == serverRequest.getHash()) {
            throw new ServerReplyNotChanged();
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("raw", (Object)string);
        return jSONObject.toString();
    }

    private String rules_put(ServerRequest serverRequest) throws Exception {
        JSONObject jSONObject = new JSONObject(serverRequest.getData());
        String string = jSONObject.getString("raw");
        RulesLibrary.getSingleton().parse_xml_stream(string);
        RulesLibrary.getSingleton().save();
        Services.app.eventManager().getScheduler().wakeup();
        return "";
    }

    private String displays() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("raw", (Object)WpFileUtils.readTextFile((File)new File(WpSystemLocator.getLocator().getDisplaysFile())));
        return jSONObject.toString();
    }

    private String license() {
        return WpFileUtils.readTextFile((File)new WpFile("${env_var:WIZEPANEL_HOME}/license.txt").getJavaFile(), (Charset)Charset.forName("UTF-8"));
    }

    private String next_events(ServerRequest serverRequest) throws Exception {
        int n = Integer.parseInt(serverRequest.getData());
        WPEventManager wPEventManager = Services.app.eventManager();
        EventList eventList = new EventList();
        try {
            for (CacheResult cacheResult : wPEventManager.getNextEvents(n)) {
                eventList.addEvent(cacheResult.getEvent().getUID(), cacheResult.getEvent().isSimpleEvents(), cacheResult.getEvent().getAdapterName(), cacheResult.getEvent().getTargetName(), cacheResult.getEvent().getSummary(), (Date)cacheResult.getEventTime().getStart(), (Date)cacheResult.getEventTime().getEnd(), WpTimeUtils.date2str((Date)cacheResult.getEventTime().getStart()) + " - " + WpTimeUtils.date2str((Date)cacheResult.getEventTime().getEnd()), (Date)cacheResult.getDisplayOn(), cacheResult.getEvent().isSimpleEventsNonMain());
            }
            eventList.sort();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            throw new GetNextEventsInterrupted();
        }
        String string = eventList.toJSONString();
        if (serverRequest.getHash() == (long)string.hashCode()) {
            throw new ServerReplyNotChanged();
        }
        return string;
    }

    private String next_simple_events(ServerRequest serverRequest) throws Exception {
        Object object;
        int n = Integer.parseInt(serverRequest.getData());
        SimpleEventsList simpleEventsList = new SimpleEventsList();
        LinkedList<String> linkedList = new LinkedList<String>();
        long l = SimpleEventsServer.getServer().getEvents(serverRequest.getHash(), linkedList);
        try {
            object = Calendar.getInstance();
            for (String string : linkedList) {
                CalendarEvent calendarEvent = CalendarUtils.create_event(string, this);
                CacheEvent cacheEvent = new CacheEvent(calendarEvent);
                DateTime dateTime = new DateTime();
                dateTime.setTime(dateTime.getTime() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, n);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                List<Period> list = cacheEvent.getRecurrences(dateTime, new DateTime(calendar.getTime()));
                if (list != null) {
                    for (Period period : list) {
                        Period period2 = cacheEvent.getDisplayPeriod(period);
                        if (period2.getEnd().before((Date)dateTime)) continue;
                        CacheResult cacheResult = new CacheResult(cacheEvent.getCalendarEvent(), period2, period);
                        simpleEventsList.addEvent(cacheResult.getEvent().getUID(), cacheResult.getEvent().getTargetName(), cacheResult.getEvent().getSummary(), cacheResult.getEvent().getOrganizerName(), (Date)cacheResult.getEventTime().getStart(), (Date)cacheResult.getEventTime().getEnd(), WpTimeUtils.date2str((Date)cacheResult.getEventTime().getStart()) + " - " + WpTimeUtils.date2str((Date)cacheResult.getEventTime().getEnd()), (Date)cacheResult.getDisplayOn(), cacheResult.getEvent().isSimpleEventsNonMain());
                    }
                }
                if (!calendarEvent.isExpired(((Calendar)object).getTime())) continue;
            }
            simpleEventsList.sort();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            throw new GetNextEventsInterrupted();
        }
        object = simpleEventsList.toJSONString();
        if (serverRequest.getHash() == l) {
            throw new ServerReplyNotChanged();
        }
        return object;
    }

    private String events_resend(String string) throws Exception {
        if (string.equals("-1")) {
            Services.app.eventManager().resendEvents(null);
        } else {
            UpiTargetItem upiTargetItem = this.get_target_by_id(string);
            Services.app.eventManager().resendEvents(upiTargetItem);
        }
        return "";
    }

    private String simple_events_put_event(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        SimpleEventsServer.getServer().addEvent(jSONObject.getString("id"), jSONObject.getString("raw"));
        return "";
    }

    private String simple_events_get_event(String string) throws Exception {
        String string2 = SimpleEventsServer.getServer().getEvent(string);
        if (string2 == null) {
            throw new Exception("Event not found");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("raw", (Object)string2);
        return jSONObject.toString();
    }

    private String simple_events_del_event(String string) throws Exception {
        SimpleEventsServer.getServer().delEvent(string);
        Services.app.eventManager().getScheduler().removeByUID(string);
        return "";
    }

    private String system_export(String string) throws Exception {
        BackupRestore.exportTo(string);
        return "";
    }

    private String system_import(String string) throws Exception {
        BackupRestore.importFrom(string);
        return "";
    }

    private String template_list(ServerRequest serverRequest) throws Exception {
        TemplateManager templateManager = Services.app.templateManager();
        if (serverRequest.getHash() == -1L || serverRequest.getHash() != templateManager.lastUpdate()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("last_update", templateManager.lastUpdate());
            jSONObject.put("templates", (Object)templateManager.toJSON());
            return jSONObject.toString();
        }
        throw new ServerReplyNotChanged();
    }

    private String template_get(String string) throws Exception {
        File file = new File(string);
        WpFile wpFile = new WpFile(file.getName(), WpFile.WpFileType.TEMPLATE_FILE);
        String string2 = UpiUtils.file2base64((String)wpFile.getJavaFile().getAbsolutePath());
        if (string2 == null) {
            throw new Exception(ERR_COULD_NOT_OPEN_FILE);
        }
        return string2;
    }

    private String resource_get(String string) throws Exception {
        File file = new File(string);
        WpFile wpFile = new WpFile(file.getName(), WpFile.WpFileType.FINAL_IMG_RESOURCE_FILE);
        String string2 = UpiUtils.file2base64((String)wpFile.getJavaFile().getAbsolutePath());
        if (string2 == null) {
            throw new Exception(ERR_COULD_NOT_OPEN_FILE);
        }
        return string2;
    }

    private String target_last_image(ServerRequest serverRequest) throws Exception {
        UpiTargetItem upiTargetItem = this.get_target_by_id(serverRequest.getData());
        String string = FinalImage.createPath(Integer.parseInt(upiTargetItem.getId()));
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception(ERR_COULD_NOT_OPEN_FILE);
        }
        long l = file.lastModified();
        if (l == serverRequest.getHash()) {
            throw new ServerReplyNotChanged();
        }
        String string2 = UpiUtils.file2base64((String)file.getAbsolutePath());
        if (string2 == null) {
            throw new Exception(ERR_COULD_NOT_OPEN_FILE);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("mtime", l);
        jSONObject.put("content", (Object)string2);
        return jSONObject.toString();
    }

    private String resource_put(ServerRequest serverRequest) throws Exception {
        WpFile wpFile = new WpFile("studio.png", WpFile.WpFileType.FINAL_IMG_RESOURCE_FILE);
        File file = WpFileUtils.getUniqueFile((String)wpFile.getResolvedFileName());
        if (file == null) {
            throw new Exception(ERR_COULD_NOT_SAVE_FILE);
        }
        UpiUtils.base642file((String)serverRequest.getData(), (String)file.getAbsolutePath());
        return file.getName();
    }

    private String template_put(ServerRequest serverRequest) throws Exception {
        JSONObject jSONObject = new JSONObject(serverRequest.getData());
        String string = jSONObject.getString("name");
        String string2 = null;
        if (jSONObject.has("data")) {
            string2 = jSONObject.getString("data");
        }
        if (string2 == null) {
            WpFile wpFile = new WpFile(string, WpFile.WpFileType.TEMPLATE_FILE);
            wpFile.delete();
            return "";
        }
        WpFile wpFile = new WpFile(string, WpFile.WpFileType.TEMPLATE_FILE);
        UpiUtils.base642file((String)string2, (String)wpFile.getJavaFile().getAbsolutePath());
        TemplateManager templateManager = Services.app.templateManager();
        templateManager.resetEntry(string, null);
        Services.app.eventManager().getScheduler().wakeup();
        return "";
    }

    private String template_rename(ServerRequest serverRequest) throws Exception {
        JSONObject jSONObject = new JSONObject(serverRequest.getData());
        String string = jSONObject.getString("from");
        String string2 = jSONObject.getString("to");
        WpFile wpFile = new WpFile(string, WpFile.WpFileType.TEMPLATE_FILE);
        WpFile wpFile2 = new WpFile(string2, WpFile.WpFileType.TEMPLATE_FILE);
        WpFileUtils.moveFile((File)wpFile.getJavaFile(), (File)wpFile2.getJavaFile());
        return "";
    }

    private String template_fontlist() {
        JSONArray jSONArray = new JSONArray();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : graphicsEnvironment.getAvailableFontFamilyNames()) {
            jSONArray.put((Object)string);
        }
        return jSONArray.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sessions_list(ServerRequest serverRequest) throws ServerReplyNotChanged, JSONException {
        List<WpSession> list;
        if (serverRequest.getHash() == Communicator.instance.getLastUpdateTimestamp()) {
            throw new ServerReplyNotChanged();
        }
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("timestamp", Communicator.instance.getLastUpdateTimestamp());
        jSONObject.put("jobs", (Object)jSONArray);
        List<WpSession> list2 = list = Communicator.instance.getFinishedSessions();
        synchronized (list2) {
            for (WpSession wpSession : list) {
                jSONArray.put((Object)wpSession.toString());
            }
        }
        return jSONObject.toString();
    }

    private String router_ping(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Could not parse port: " + stringArray[1]);
        }
        CommCmDispGetFirmwareVer commCmDispGetFirmwareVer = new CommCmDispGetFirmwareVer();
        commCmDispGetFirmwareVer.setRepeatPacket(1);
        commCmDispGetFirmwareVer.setReadTimeout(2000);
        if (new CommInvoker().ExecuteCommand(stringArray[0], n, (ACommCommand)commCmDispGetFirmwareVer)) {
            return commCmDispGetFirmwareVer.getDispFirmwareVer();
        }
        throw new Exception("Could not connect to dispatcher.");
    }

    private String router_ident(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        new WpUpiServerDataProxy().dispatcherIdentify(stringArray[0], stringArray[1]);
        return "";
    }

    private String router_add(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        DispatcherItemType dispatcherItemType = new DispatcherItemType(stringArray[0] + ":" + stringArray[1]);
        dispatcherItemType.params().setIp(stringArray[0]);
        dispatcherItemType.params().setPort(Integer.parseInt(stringArray[1]));
        DispatcherPool.getPool().updateDispatcher(dispatcherItemType, null, false, false);
        return "";
    }

    private String routing(ServerRequest serverRequest) throws Exception {
        String[] stringArray = serverRequest.getData().split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        if (stringArray[0].equalsIgnoreCase("get")) {
            UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
            for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
                DispatcherItemType dispatcherItemType = WpDataManager.getManager().getDispatcherById(upiRouterItem.getId());
                if (dispatcherItemType == null) continue;
                if (dispatcherItemType.getLastUpdate() > 0L) {
                    upiRouterItem.getParams().setLastSeen((int)((System.currentTimeMillis() - dispatcherItemType.getLastUpdate()) / 1000L));
                    continue;
                }
                upiRouterItem.getParams().setLastSeen(-1);
            }
            String string = upiRoutingHandler.toRoutingTable().toString();
            if ((long)string.hashCode() == serverRequest.getHash()) {
                throw new ServerReplyNotChanged();
            }
            return string;
        }
        if (stringArray[0].equalsIgnoreCase("put")) {
            DispatcherPool.getPool().setRouting(stringArray[1]);
            return "";
        }
        throw new Exception("Unknown subcommand: " + stringArray[0]);
    }

    private String target_name(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        UpiTargetItem upiTargetItem = this.get_target_by_id(stringArray[0]);
        String string2 = upiTargetItem.getParams().getName();
        new WpUpiServerDataProxy().setWizepanelName(Integer.parseInt(upiTargetItem.getId()), stringArray[1]);
        Schadchen schadchen = Services.app.eventManager().getSchadchen();
        if (schadchen.renameTarget(string2, stringArray[1])) {
            schadchen.save(WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SCHADCHEN_CFG_FILE));
        }
        return "";
    }

    private UpiTargetItem get_target_by_id(String string) throws Exception {
        UpiTargetItem upiTargetItem = WpUpiServerStaticFactory.getRoutingHandler().getTargetById(string);
        if (upiTargetItem == null) {
            throw new Exception(ERR_COULD_NOT_FIND_TARGET);
        }
        return upiTargetItem;
    }

    private String target_comment(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        UpiTargetItem upiTargetItem = this.get_target_by_id(stringArray[0]);
        JSONObject jSONObject = new JSONObject(stringArray[1]);
        String string2 = jSONObject.getString("raw");
        WizePanelItemType wizePanelItemType = WpDataManager.getManager().getWizepanelById(Integer.parseInt(upiTargetItem.getId()));
        if (wizePanelItemType != null) {
            wizePanelItemType.params().setComment(string2);
        }
        upiTargetItem.getParams().setComment(string2);
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        upiRoutingHandler.saveRoutingTable();
        Services.app.eventManager().getScheduler().wakeup();
        return "";
    }

    private String target_rotation(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        new WpUpiServerDataProxy().setWizepanelRotation(n, n2);
        Services.app.eventManager().getScheduler().wakeup();
        return "";
    }

    private String router_timezone(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 1 && stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        String string2 = stringArray[0];
        String string3 = "";
        if (stringArray.length == 2) {
            string3 = stringArray[1];
        }
        new WpUpiServerDataProxy().setDispatcherTimeZone(string2, string3);
        Services.app.eventManager().getScheduler().wakeup();
        return "";
    }

    private String router_name(String string) throws Exception {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        new WpUpiServerDataProxy().setDispatcherName(string2, string3);
        Services.app.eventManager().getScheduler().wakeup();
        return "";
    }

    private String adapters_get(ServerRequest serverRequest) throws Exception {
        FileAdapterManager.getManager().read_config();
        String string = FileAdapterManager.getManager().toJSON().toString();
        if (serverRequest.getHash() == (long)string.hashCode()) {
            throw new ServerReplyNotChanged();
        }
        return string;
    }

    private String adapters_put(ServerRequest serverRequest) throws Exception {
        FileAdapterManager.getManager().fromString(serverRequest.getData());
        return "";
    }

    private String adapters_rename(ServerRequest serverRequest) throws Exception {
        String[] stringArray = serverRequest.getData().split("\\s+", 2);
        if (stringArray.length != 2) {
            throw new Exception(ERR_WRONG_NUM_ARGS);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        FileAdapterManager.getManager().renameAdapter(string, string2);
        return "";
    }

    private String adapters_test(ServerRequest serverRequest) throws Exception {
        String string = AdapterTesterFactory.test(new JSONObject(serverRequest.getData()));
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)string);
        return jSONArray.toString();
    }

    private String simple_events_get_rooms() {
        return SimpleEventsServer.getServer().getRooms();
    }

    private String simple_events_put_rooms(String string) {
        SimpleEventsServer.getServer().setRooms(string);
        return "";
    }

    private String put_WizePanel_Locale(String string, String string2) {
        if (string2.equals("superGroup")) {
            WpSystemLocator.getLocator().setDateTimeLocale(string);
            WpSystemLocator.getLocator().saveProps();
        } else {
            GroupData groupData = GroupManager.getManager().getGroupByName(string2);
            GroupManager.getManager().add(groupData.name, groupData.id, groupData.templates, groupData.adapters, groupData.wizpanels, groupData.simpleRooms, groupData.historyDuration, groupData.timeTableStart, string);
            this.groups_put(GroupManager.getManager().toString());
        }
        return "";
    }

    private String get_WizePanel_Locale(String string) {
        if (string.equals("superGroup")) {
            return WpSystemLocator.getLocator().getDateTimeLocale();
        }
        return GroupManager.getManager().getGroupByName((String)string).localeLang;
    }

    private String putTimetableStartDay(String string, String string2) {
        if (string2.equals("superGroup")) {
            WpSystemLocator.getLocator().setTimetableStartDay(string);
            WpSystemLocator.getLocator().saveProps();
        } else {
            GroupData groupData = GroupManager.getManager().getGroupByName(string2);
            GroupManager.getManager().add(groupData.name, groupData.id, groupData.templates, groupData.adapters, groupData.wizpanels, groupData.simpleRooms, groupData.historyDuration, string, groupData.localeLang);
            this.groups_put(GroupManager.getManager().toString());
        }
        return "";
    }

    private String getTimetableStartDay(String string) {
        if (string.equals("superGroup")) {
            return WpSystemLocator.getLocator().getTimetableStartDay();
        }
        return GroupManager.getManager().getGroupByName((String)string).timeTableStart;
    }

    private String putEventHistoryDuration(String string, String string2) {
        if (string2.equals("superGroup")) {
            WpSystemLocator.getLocator().setEventHistoryDuration(string);
            WpSystemLocator.getLocator().saveProps();
        } else {
            GroupData groupData = GroupManager.getManager().getGroupByName(string2);
            GroupManager.getManager().add(groupData.name, groupData.id, groupData.templates, groupData.adapters, groupData.wizpanels, groupData.simpleRooms, string, groupData.timeTableStart, groupData.localeLang);
            this.groups_put(GroupManager.getManager().toString());
        }
        return "";
    }

    private String getEventHistoryDuration(String string) {
        if (string.equals("superGroup")) {
            return WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        return GroupManager.getManager().getGroupByName((String)string).historyDuration;
    }

    private String get_all_java_locales() {
        JSONObject jSONObject;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Locale locale : jSONObject = Locale.getAvailableLocales()) {
            if (locale.getLanguage() == "" || locale.getDisplayLanguage() == "") continue;
            hashMap.put(locale.getLanguage(), locale.getDisplayLanguage());
        }
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("locales", hashMap);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject2.toString();
    }
}

