/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server.http;

import de.wilke.wizepanel.core.adapters.IAdapterTask;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.server.AWpRequest;
import de.wilke.wizepanel.server.http.HTTPServerConfig;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.engine.services.CleanupDatabase;
import de.wilke.wizepanel.upi.engine.services.GetWpParamsRequester;
import de.wilke.wizepanel.upi.engine.services.UpdateJobStatus;
import de.wilke.wizepanel.upi.engine.services.WpDispatcherListener;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Application;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.service.LogService;

public class HTTPServer
implements IAdapterTask {
    private final Logger m_logger = LogManager.getLogger(HTTPServer.class);
    private final Component restlet_comp;
    private final Server restlet_server;
    private final List<AWpRequest> services = new LinkedList<AWpRequest>();

    public HTTPServer() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        WpUpiServerLocator wpUpiServerLocator = WpUpiServerStaticFactory.getServerLocator();
        this.restlet_comp = new Component();
        NullLogService nullLogService = new NullLogService();
        nullLogService.setLoggerName("de.wilke.wizepanel.server.http.restlet");
        this.restlet_comp.setLogService((LogService)nullLogService);
        this.restlet_server = this.restlet_comp.getServers().add(Protocol.HTTP, wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.WP_SERVER_PORT));
        int n6 = wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.WP_SERVER_MAX_TOTAL_CONNECTION);
        if (n6 > 0) {
            this.restlet_server.getContext().getParameters().add("maxTotalConnections", Integer.toString(n6));
        }
        if ((n5 = wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.WP_SERVER_MAX_THREADS)) > 0) {
            this.restlet_server.getContext().getParameters().add("maxThreads", Integer.toString(n5));
        }
        if ((n4 = wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.DATA_INFO_REQUEST_INTERVAL)) >= 0) {
            this.services.add(new GetWpParamsRequester(n4));
        }
        if ((n3 = wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.UPDATE_JOB_STATUS_INTERVAL)) >= 0) {
            this.services.add(new UpdateJobStatus(n3));
        }
        if ((n2 = wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.DISPATCHERS_REQUEST_INTERVAL)) >= 0) {
            this.services.add(new WpDispatcherListener(n2));
        }
        if ((n = wpUpiServerLocator.getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.DATABASE_CLEANUP_INTERVAL)) >= 0) {
            this.services.add(new CleanupDatabase(n));
        }
    }

    public boolean start() {
        JaxRsApplication jaxRsApplication = new JaxRsApplication(this.restlet_comp.getContext().createChildContext());
        LicenseManager licenseManager = LicenseManager.getManager();
        jaxRsApplication.add((Application)new HTTPServerConfig(licenseManager.hasLicense(LicenseManager.LicensePackages.WZP_SOFT_BRANCHE) || licenseManager.hasLicense(LicenseManager.LicensePackages.WZP_TEST_SOFT)));
        this.restlet_comp.getDefaultHost().attach((Restlet)jaxRsApplication);
        try {
            this.restlet_comp.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        for (AWpRequest aWpRequest : this.services) {
            aWpRequest.start(false, this.m_logger, false);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.restlet_server != null) {
            stringBuilder.append("Server port: ").append(this.restlet_server.getPort()).append("\n");
        }
        for (AWpRequest aWpRequest : this.services) {
            stringBuilder.append(aWpRequest.getClass().getName()).append(": ").append(aWpRequest.getRequestInterval()).append("\n");
        }
        stringBuilder.append("Static Routing: " + WpUpiServerStaticFactory.getServerLocator().getBoolean(WpUpiServerLocator.WpUpiServerLocatorPropType.UPI_WP_SERVER_STATIC_ROUTING));
        return stringBuilder.toString();
    }

    public void stopEverything() {
        try {
            this.restlet_comp.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (AWpRequest aWpRequest : this.services) {
            aWpRequest.exit();
        }
    }

    public Component server() {
        return this.restlet_comp;
    }

    class NullLogService
    extends LogService {
        NullLogService() {
        }

        public boolean isLoggable(Request request) {
            String string = request.getResourceRef().getPath();
            return !string.startsWith("/login/") && !string.startsWith("/logout/") && !string.startsWith("/action/");
        }
    }
}

