/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server.http.adaptertests;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpPasswords;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.adapters.asc_timetables.AscServerReply;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.DeaEmsSOAP12Request;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.DeaEmsSOAPRequest;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.Booking;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.GetAllRoomBookingsResponse;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.GetAllRoomsResult;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.ExchangeService;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSCalendarEvent;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSUTCTime;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.MailTaskConnection;
import de.wilke.wizepanel.eventmanager.adapters.systemmonitor.SystemMonitorUtils;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarFile;
import de.wilke.wizepanel.server.http.adaptertests.CsvTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.schema.FolderSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.CalendarView;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdapterTesterFactory {
    private static final Logger m_logger = LogManager.getLogger(AdapterTesterFactory.class);

    public static String test(JSONObject jSONObject) throws Exception {
        switch (jSONObject.getString("type")) {
            case "ms-ews": {
                return AdapterTesterFactory.test_ms_ews(jSONObject);
            }
            case "ms-ews-online": {
                return AdapterTesterFactory.test_ms_ews_online(jSONObject);
            }
            case "ms-exchange-graph": {
                return AdapterTesterFactory.test_ms_graph(jSONObject);
            }
            case "ms-email": {
                return AdapterTesterFactory.test_ms_aaa(jSONObject);
            }
            case "xml": {
                return AdapterTesterFactory.test_xml(jSONObject);
            }
            case "icalendar": {
                return AdapterTesterFactory.test_icalendar(jSONObject);
            }
            case "dea-ems": {
                return AdapterTesterFactory.test_dea_ems(jSONObject);
            }
            case "csv": {
                return new CsvTest().action(jSONObject);
            }
            case "asc-timetables": {
                return AdapterTesterFactory.test_asc_time_tables(jSONObject);
            }
            case "system-monitor": {
                return AdapterTesterFactory.test_system_monitor_test(jSONObject);
            }
            case "google-calendar": {
                return AdapterTesterFactory.test_google_calendar(jSONObject);
            }
            case "webuntis": {
                return AdapterTesterFactory.testWebUntis(jSONObject);
            }
        }
        throw new Exception("Unknown adapter.");
    }

    private static String test_system_monitor_test(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("smtp");
        String string2 = jSONObject.getString("from");
        String string3 = WpPasswords.decrypt((String)jSONObject.getString("password"));
        JSONArray jSONArray = jSONObject.getJSONArray("to");
        boolean bl = jSONObject.getBoolean("use_ssl");
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            linkedList.add(jSONArray.getString(i));
        }
        SystemMonitorUtils.send_mail(string, string2, string3, linkedList, "WizePanel-Server: Test email", "Successful", bl);
        return "Successful";
    }

    private static String test_ms_ews(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("url");
        String string2 = jSONObject.getString("user");
        String string3 = WpPasswords.decrypt((String)jSONObject.getString("password"));
        int n = jSONObject.getInt("days");
        String string4 = jSONObject.getString("folder");
        ExchangeService exchangeService = new ExchangeService(string, string2, string3);
        Calendar calendar = Calendar.getInstance();
        EWSUTCTime eWSUTCTime = new EWSUTCTime(calendar);
        calendar.setTime(WpTimeUtils.midnight_in_days((int)n));
        EWSUTCTime eWSUTCTime2 = new EWSUTCTime(calendar);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            List<EWSCalendarEvent> list = exchangeService.get_events(string4, eWSUTCTime, eWSUTCTime2);
            stringBuilder.append("Could read #events: ").append(list.size());
            for (int i = 0; i < list.size() && i < 3; ++i) {
                EWSCalendarEvent eWSCalendarEvent = list.get(i);
                stringBuilder.append("\n  + ").append(eWSCalendarEvent.getSubject());
            }
            if (list.size() >= 3) {
                stringBuilder.append("\n...");
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception.getMessage());
            throw new Exception(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private static String test_ms_ews_online(JSONObject jSONObject) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            FolderView folderView;
            CalendarFolder calendarFolder;
            String string = jSONObject.getString("url");
            String string2 = jSONObject.getString("user");
            String string3 = WpPasswords.decrypt((String)jSONObject.getString("password"));
            int n = jSONObject.getInt("days");
            String string4 = jSONObject.getString("folder");
            microsoft.exchange.webservices.data.core.ExchangeService exchangeService = new microsoft.exchange.webservices.data.core.ExchangeService(ExchangeVersion.Exchange2010_SP2);
            WebCredentials webCredentials = new WebCredentials(string2, string3);
            exchangeService.setCredentials((ExchangeCredentials)webCredentials);
            exchangeService.setUrl(new URI(string));
            Date date = Calendar.getInstance().getTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(WpTimeUtils.midnight_in_days((int)n));
            Date date2 = calendar.getTime();
            FolderId folderId = null;
            String string5 = "";
            if (string4.contains("\\") || string4.contains("/")) {
                calendarFolder = string4.split("\\\\|\\/");
                if (((String[])calendarFolder).length > 0) {
                    string5 = calendarFolder[((String[])calendarFolder).length - 1];
                }
                folderView = new FolderView(100);
                PropertySet propertySet = new PropertySet(BasePropertySet.IdOnly);
                propertySet.add((PropertyDefinitionBase)FolderSchema.DisplayName);
                folderView.setPropertySet(propertySet);
                folderView.setTraversal(FolderTraversal.Deep);
                SearchFilter.IsEqualTo isEqualTo = new SearchFilter.IsEqualTo((PropertyDefinitionBase)FolderSchema.FolderClass, (Object)"IPF.Appointment");
                FindFoldersResults findFoldersResults = exchangeService.findFolders(WellKnownFolderName.Root, (SearchFilter)isEqualTo, folderView);
                for (Folder folder : findFoldersResults.getFolders()) {
                    if (!folder.getDisplayName().equals(string5)) continue;
                    folderId = folder.getId();
                    break;
                }
            } else {
                folderId = new FolderId(WellKnownFolderName.Calendar, Mailbox.getMailboxFromString((String)string4));
            }
            calendarFolder = CalendarFolder.bind((microsoft.exchange.webservices.data.core.ExchangeService)exchangeService, (FolderId)folderId);
            folderView = calendarFolder.findAppointments(new CalendarView(date, date2));
            stringBuilder.append("Could read #events: ").append(folderView.getTotalCount());
            for (SearchFilter.IsEqualTo isEqualTo : folderView.getItems()) {
                stringBuilder.append("\n  + ").append(isEqualTo.getSubject());
            }
            if (folderView.getTotalCount() >= 3) {
                stringBuilder.append("\n...");
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception.getMessage());
            m_logger.error(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private static String test_ms_graph(JSONObject jSONObject) {
        String string = "";
        String string2 = "";
        String string3 = "";
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = "https://graph.microsoft.com/.default";
        String string5 = "";
        int n = 0;
        try {
            Object object;
            String string6 = jSONObject.getString("clientId");
            String string7 = jSONObject.getString("tenantId");
            String string8 = WpPasswords.decrypt((String)jSONObject.getString("clientSecret"));
            int n2 = jSONObject.getInt("days");
            String string9 = jSONObject.getString("calendar");
            ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)string6, (IClientCredential)ClientCredentialFactory.createFromSecret((String)string8)).authority("https://login.microsoftonline.com/" + string7 + "/")).build();
            ClientCredentialParameters clientCredentialParameters = ClientCredentialParameters.builder(Collections.singleton(string4)).build();
            CompletableFuture completableFuture = confidentialClientApplication.acquireToken(clientCredentialParameters);
            confidentialClientApplication.validateAuthority();
            string5 = ((IAuthenticationResult)completableFuture.get()).accessToken();
            if (string9.contains("\\") || string9.contains("/")) {
                object = string9.split("\\\\|\\/");
                string = object[0];
                string2 = object[((String[])object).length - 1];
            } else {
                string = string9;
                string2 = "";
            }
            object = URLEncoder.encode("displayName,userPrincipalName", "UTF-8");
            URL uRL = new URL("https://graph.microsoft.com/v1.0/users/" + string + "?$select=" + (String)object);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + string5);
            httpURLConnection.setRequestProperty("Accept", "application/json");
            int n3 = httpURLConnection.getResponseCode();
            if (n3 == 200) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Comparable<StringBuilder> comparable;
                Object object6;
                object = URLEncoder.encode("name,id", "UTF-8");
                uRL = string2.equals("") ? new URL("https://graph.microsoft.com/v1.0/users/" + string + "/calendar?$select=" + (String)object) : new URL("https://graph.microsoft.com/v1.0/users/" + string + "/calendars?$select=" + (String)object);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Authorization", "Bearer " + string5);
                httpURLConnection.setRequestProperty("Accept", "application/json");
                n3 = httpURLConnection.getResponseCode();
                if (n3 == 200) {
                    object6 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    comparable = new StringBuilder();
                    while ((object5 = ((BufferedReader)object6).readLine()) != null) {
                        ((StringBuilder)comparable).append((String)object5);
                    }
                    object4 = new JSONObject(((StringBuilder)comparable).toString());
                    if (object4.has("value")) {
                        object3 = object4.getJSONArray("value");
                        int n4 = object3.length();
                        for (int i = 0; i < n4; ++i) {
                            object2 = object3.getJSONObject(i);
                            if (!string2.equals(object2.getString("name"))) continue;
                            string3 = object2.getString("id");
                        }
                    } else {
                        string3 = object4.getString("id");
                    }
                } else if (n3 == 404) {
                    stringBuilder.append("Could not find calendar \"" + string2 + "\" for account \"" + string + "\"");
                    m_logger.error(stringBuilder.toString());
                } else {
                    stringBuilder.append(String.format("Connection returned HTTP code: %s with message: %s", n3, httpURLConnection.getResponseMessage()));
                    m_logger.error(stringBuilder.toString());
                }
                if (string3 != "") {
                    comparable = Calendar.getInstance();
                    ((Calendar)comparable).setTimeInMillis(((Calendar)comparable).getTimeInMillis() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
                    ((Calendar)comparable).setTimeZone(TimeZone.getTimeZone("UTC"));
                    object6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
                    ((DateFormat)object6).setTimeZone(TimeZone.getTimeZone("UTC"));
                    object5 = Calendar.getInstance();
                    ((Calendar)object5).setTime(WpTimeUtils.midnight_in_days((int)n2));
                    ((Calendar)object5).setTimeZone(TimeZone.getTimeZone("UTC"));
                    object4 = ((DateFormat)object6).format(((Calendar)comparable).getTime());
                    object3 = ((DateFormat)object6).format(((Calendar)object5).getTime());
                    String string10 = URLEncoder.encode((String)object4, "UTF-8");
                    String string11 = URLEncoder.encode((String)object3, "UTF-8");
                    object2 = URLEncoder.encode("subject,body,start,end,organizer,reminderMinutesBeforeStart,sensitivity,location,lastModifiedDateTime", "UTF-8");
                    String string12 = URLEncoder.encode("start/datetime", "UTF-8");
                    JSONObject jSONObject2 = new JSONObject().put("@odata.nextLink", (Object)("https://graph.microsoft.com/v1.0/users/" + string + "/calendars/" + string3 + "/calendarView?startDateTime=" + string10 + "&endDateTime=" + string11 + "&$select=" + (String)object2 + "&$orderby=" + string12));
                    while (jSONObject2.has("@odata.nextLink")) {
                        uRL = new URL(jSONObject2.getString("@odata.nextLink"));
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod("GET");
                        httpURLConnection.setRequestProperty("Authorization", "Bearer " + string5);
                        httpURLConnection.setRequestProperty("Accept", "application/json");
                        httpURLConnection.setRequestProperty("Prefer", "outlook.body-content-type='text'");
                        n3 = httpURLConnection.getResponseCode();
                        if (n3 == 200) {
                            String string13;
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                            StringBuilder stringBuilder2 = new StringBuilder();
                            while ((string13 = bufferedReader.readLine()) != null) {
                                stringBuilder2.append(string13);
                            }
                            jSONObject2 = new JSONObject(stringBuilder2.toString());
                            JSONArray jSONArray = jSONObject2.getJSONArray("value");
                            n += jSONArray.length();
                            continue;
                        }
                        stringBuilder.append(String.format("Connection returned HTTP code: %s with message: %s", n3, httpURLConnection.getResponseMessage()));
                        m_logger.error(stringBuilder.toString());
                        break;
                    }
                    stringBuilder.append("Source[" + string9 + "]: received events: #" + n);
                } else {
                    stringBuilder.append("Could not find calendar \"" + string2 + "\" for account \"" + string + "\"");
                    m_logger.error(stringBuilder.toString());
                }
            } else if (n3 == 404) {
                stringBuilder.append("Could not find account: \"" + string + "\"");
                m_logger.error(stringBuilder.toString());
            } else {
                stringBuilder.append(String.format("Connection returned HTTP code: %s with message: %s", n3, httpURLConnection.getResponseMessage()));
                m_logger.error(stringBuilder.toString());
            }
        }
        catch (IOException | InterruptedException | ExecutionException | JSONException throwable) {
            stringBuilder.append(throwable.getMessage());
            m_logger.error(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private static String test_ms_aaa(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("url");
        String string2 = jSONObject.getString("user");
        String string3 = WpPasswords.decrypt((String)jSONObject.getString("password"));
        MailTaskConnection mailTaskConnection = new MailTaskConnection(string, string2, string3);
        try {
            mailTaskConnection.open_mailbox();
            mailTaskConnection.close_mailbox(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return "Successful";
    }

    private static String test_xml(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("path");
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("Directory does not exist.");
        }
        if (!file.isDirectory()) {
            throw new Exception("Is not a directory.");
        }
        return "";
    }

    private static String test_icalendar(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("path");
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("Directory does not exist.");
        }
        if (!file.isDirectory()) {
            throw new Exception("Is not a directory.");
        }
        return "";
    }

    private static String test_asc_time_tables(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("url");
        String string2 = jSONObject.getString("date");
        String[] stringArray = string2.split("-");
        if (stringArray.length != 3) {
            throw new Exception("Invalid date format.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]));
        AscServerReply ascServerReply = new AscServerReply();
        ascServerReply.get(string, calendar.getTime(), 0);
        JSONObject jSONObject2 = new JSONObject();
        for (String string3 : ascServerReply.rooms().keySet()) {
            jSONObject2.put(string3, (Object)ascServerReply.rooms().get(string3));
        }
        return jSONObject2.toString();
    }

    private static String test_dea_ems(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("url");
        String string2 = jSONObject.getString("user");
        String string3 = WpPasswords.decrypt((String)jSONObject.getString("password"));
        String string4 = jSONObject.getString("command");
        Boolean bl = jSONObject.getBoolean("soap1_2");
        if (string4.equals("get-rooms")) {
            GetAllRoomsResult getAllRoomsResult = new GetAllRoomsResult();
            if (bl.booleanValue()) {
                DeaEmsSOAP12Request deaEmsSOAP12Request = new DeaEmsSOAP12Request(string, string2, string3);
                if (deaEmsSOAP12Request.exec(getAllRoomsResult)) {
                    Collections.sort(getAllRoomsResult.rooms(), new Comparator<GetAllRoomsResult.Room>(){

                        @Override
                        public int compare(GetAllRoomsResult.Room room, GetAllRoomsResult.Room room2) {
                            int n = room.building.compareToIgnoreCase(room2.building);
                            if (n == 0) {
                                return room.name.compareTo(room2.name);
                            }
                            return n;
                        }
                    });
                    JSONArray jSONArray = new JSONArray();
                    for (GetAllRoomsResult.Room room : getAllRoomsResult.rooms()) {
                        JSONArray jSONArray2 = new JSONArray();
                        jSONArray2.put((Object)room.id);
                        jSONArray2.put((Object)room.name);
                        jSONArray2.put((Object)room.building);
                        jSONArray.put((Object)jSONArray2);
                    }
                    return jSONArray.toString();
                }
                throw new Exception(getAllRoomsResult.error());
            }
            DeaEmsSOAPRequest deaEmsSOAPRequest = new DeaEmsSOAPRequest(string, string2, string3);
            if (deaEmsSOAPRequest.exec(getAllRoomsResult)) {
                Collections.sort(getAllRoomsResult.rooms(), new Comparator<GetAllRoomsResult.Room>(){

                    @Override
                    public int compare(GetAllRoomsResult.Room room, GetAllRoomsResult.Room room2) {
                        int n = room.building.compareToIgnoreCase(room2.building);
                        if (n == 0) {
                            return room.name.compareTo(room2.name);
                        }
                        return n;
                    }
                });
                JSONArray jSONArray = new JSONArray();
                for (GetAllRoomsResult.Room room : getAllRoomsResult.rooms()) {
                    JSONArray jSONArray3 = new JSONArray();
                    jSONArray3.put((Object)room.id);
                    jSONArray3.put((Object)room.name);
                    jSONArray3.put((Object)room.building);
                    jSONArray.put((Object)jSONArray3);
                }
                return jSONArray.toString();
            }
            throw new Exception(getAllRoomsResult.error());
        }
        if (string4.equals("get-events")) {
            String string5 = jSONObject.getString("room_id");
            int n = jSONObject.getInt("days");
            GetAllRoomBookingsResponse getAllRoomBookingsResponse = new GetAllRoomBookingsResponse(string5, new Date(), WpTimeUtils.midnight_in_days((int)n));
            if (bl.booleanValue()) {
                DeaEmsSOAP12Request deaEmsSOAP12Request = new DeaEmsSOAP12Request(string, string2, string3);
                if (deaEmsSOAP12Request.exec(getAllRoomBookingsResponse)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    List<Booking> list = getAllRoomBookingsResponse.bookings();
                    stringBuilder.append("Could read #events: ").append(list.size());
                    for (int i = 0; i < list.size() && i < 3; ++i) {
                        Booking booking = list.get(i);
                        stringBuilder.append("\n  + ").append(booking.subject());
                    }
                    if (list.size() >= 3) {
                        stringBuilder.append("\n...");
                    }
                    return stringBuilder.toString();
                }
                throw new Exception("Failed to read room: " + string5 + ". Error: " + getAllRoomBookingsResponse.error());
            }
            DeaEmsSOAPRequest deaEmsSOAPRequest = new DeaEmsSOAPRequest(string, string2, string3);
            if (deaEmsSOAPRequest.exec(getAllRoomBookingsResponse)) {
                StringBuilder stringBuilder = new StringBuilder();
                List<Booking> list = getAllRoomBookingsResponse.bookings();
                stringBuilder.append("Could read #events: ").append(list.size());
                for (int i = 0; i < list.size() && i < 3; ++i) {
                    Booking booking = list.get(i);
                    stringBuilder.append("\n  + ").append(booking.subject());
                }
                if (list.size() >= 3) {
                    stringBuilder.append("\n...");
                }
                return stringBuilder.toString();
            }
            throw new Exception("Failed to read room: " + string5 + ". Error: " + getAllRoomBookingsResponse.error());
        }
        throw new Exception("Unknown command: " + string4);
    }

    private static String test_google_calendar(JSONObject jSONObject) throws Exception {
        String string = WpPasswords.decrypt((String)jSONObject.getString("url"));
        String string2 = WpFileUtils.downloadFile((String)string, (Charset)Charset.forName("UTF-8"));
        int n = 0;
        CalendarFile calendarFile = new CalendarFile(string2, false);
        for (CalendarEvent calendarEvent : calendarFile.getEvents()) {
            if (!calendarEvent.isExpired()) continue;
            ++n;
        }
        return MessageFormat.format("Could read {0} events.\n\nEvents expired: {1}.", calendarFile.getEventCount(), n);
    }

    private static String testWebUntis(JSONObject jSONObject) {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder();
        TimeZoneRegistry timeZoneRegistry = TimeZoneRegistryFactory.getInstance().createRegistry();
        try {
            net.fortuna.ical4j.model.TimeZone timeZone = timeZoneRegistry.getTimeZone(jSONObject.getString("timezone"));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(WpSystemLocator.getLocator().getEventHistoryDuration()));
            calendar.setTimeZone((TimeZone)timeZone);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            simpleDateFormat.setTimeZone((TimeZone)timeZone);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(WpTimeUtils.midnight_in_days((int)jSONObject.getInt("days")));
            calendar2.setTimeZone((TimeZone)timeZone);
            String string2 = simpleDateFormat.format(calendar.getTime());
            String string3 = simpleDateFormat.format(calendar2.getTime());
            String string4 = jSONObject.getString("room");
            String string5 = jSONObject.getString("server") + "?school=" + URLEncoder.encode(jSONObject.getString("school"), "UTF-8");
            String string6 = "";
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("user", (Object)jSONObject.getString("user"));
            jSONObject2.put("password", (Object)WpPasswords.decrypt((String)jSONObject.getString("password")));
            jSONObject2.put("client", (Object)"WilkeTechnology_WizePanelServer");
            JSONObject jSONObject3 = new JSONObject();
            Random random = new Random();
            jSONObject3.put("id", (Object)Integer.toString(random.nextInt(Integer.MAX_VALUE)));
            jSONObject3.put("method", (Object)"authenticate");
            jSONObject3.put("params", (Object)jSONObject2);
            jSONObject3.put("jsonrpc", (Object)"2.0");
            string6 = jSONObject3.toString();
            CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(string5);
            StringEntity stringEntity = new StringEntity(string6, "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n != 200) {
                string = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
            } else {
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                String string7 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                JSONObject jSONObject4 = new JSONObject(string7);
                if (jSONObject4.has("error")) {
                    JSONObject jSONObject5 = jSONObject4.getJSONObject("error");
                    string = jSONObject5.has("message") ? MessageFormat.format("Error while parsing authentication response: {0}", jSONObject5.getString("message")) : MessageFormat.format("Error while parsing authentication response: {0}", "NULL - no error message returned by server");
                } else {
                    JSONObject jSONObject6 = jSONObject4.getJSONObject("result");
                    String string8 = jSONObject6.getString("sessionId");
                    JSONObject jSONObject7 = new JSONObject();
                    jSONObject7.put("id", (Object)string4);
                    jSONObject7.put("type", 4);
                    jSONObject7.put("keyType", (Object)"name");
                    JSONObject jSONObject8 = new JSONObject();
                    jSONObject8.put("element", (Object)jSONObject7);
                    jSONObject8.put("startDate", Integer.parseInt(string2));
                    jSONObject8.put("endDate", Integer.parseInt(string3));
                    JSONObject jSONObject9 = new JSONObject();
                    jSONObject9.put("options", (Object)jSONObject8);
                    jSONObject3 = new JSONObject();
                    random = new Random();
                    jSONObject3.put("id", (Object)Integer.toString(random.nextInt(Integer.MAX_VALUE)));
                    jSONObject3.put("method", (Object)"getTimetable");
                    jSONObject3.put("params", (Object)jSONObject9);
                    jSONObject3.put("jsonrpc", (Object)"2.0");
                    string6 = jSONObject3.toString();
                    httpPost = new HttpPost(string5);
                    stringEntity = new StringEntity(string6, "UTF-8");
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    httpPost.setHeader("Cookie", "JSESSIONID=" + string8);
                    closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                    n = closeableHttpResponse.getStatusLine().getStatusCode();
                    if (n != 200) {
                        string = String.format("Connection returned HTTP code: %s with message: %s", n, EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8"));
                    } else {
                        httpEntity = closeableHttpResponse.getEntity();
                        string7 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                        jSONObject4 = new JSONObject(string7);
                        if (jSONObject4.has("error")) {
                            JSONObject jSONObject10 = jSONObject4.getJSONObject("error");
                            string = jSONObject10.has("message") ? MessageFormat.format("Error while parsing getTimetable response: {0}", jSONObject10.getString("message")) : MessageFormat.format("Error while parsing getTimetable response: {0}", "NULL - no error message returned by server");
                        } else {
                            JSONArray jSONArray = jSONObject4.getJSONArray("result");
                            stringBuilder.append("Source[" + string4 + "]: received events: #" + jSONArray.length());
                        }
                    }
                    jSONObject3 = new JSONObject();
                    random = new Random();
                    jSONObject3.put("id", (Object)Integer.toString(random.nextInt(Integer.MAX_VALUE)));
                    jSONObject3.put("method", (Object)"logout");
                    jSONObject3.put("params", (Object)"{}");
                    jSONObject3.put("jsonrpc", (Object)"2.0");
                    httpPost = new HttpPost(string5);
                    stringEntity = new StringEntity(jSONObject3.toString(), "UTF-8");
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    httpPost.setHeader("Cookie", "JSESSIONID=" + string8);
                    closeableHttpClient.execute((HttpUriRequest)httpPost);
                }
            }
        }
        catch (IOException | JSONException throwable) {
            stringBuilder.append(throwable.getMessage());
            m_logger.error(stringBuilder.toString());
        }
        if (string.length() > 0) {
            stringBuilder.append(string);
            m_logger.error(string);
        }
        return stringBuilder.toString();
    }
}

