/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server.http.adaptertests;

import au.com.bytecode.opencsv.CSVReader;
import de.wilke.wizepanel.core.adapters.types.CsvAdapterFormat;
import de.wilke.wizepanel.eventmanager.adapters.csv.CsvUtils;
import de.wilke.wizepanel.server.Services;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fortuna.ical4j.model.DateTime;
import org.json.JSONArray;
import org.json.JSONException;

class CsvFile {
    private final List<String[]> m_lines = new LinkedList<String[]>();
    private int m_max_num_of_fields = 0;
    private final CsvAdapterFormat m_fmt;

    public CsvFile(String string, CsvAdapterFormat csvAdapterFormat, int n) throws Exception {
        this.m_fmt = csvAdapterFormat;
        try (CSVReader cSVReader = new CSVReader((Reader)new StringReader(string), this.m_fmt.getCsvSeparator().charAt(0), this.m_fmt.getCsvEnclosure().charAt(0), '\\', 0);){
            for (String[] stringArray : cSVReader.readAll()) {
                if (stringArray.length < this.m_fmt.numMinCols()) continue;
                this.m_max_num_of_fields = Math.max(this.m_max_num_of_fields, stringArray.length);
                this.m_lines.add(stringArray);
                if (n == -1 || n != this.m_lines.size()) continue;
                break;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_lines.isEmpty()) {
            stringBuilder.append("[empty]");
        } else {
            for (String[] stringArray : this.m_lines) {
                for (String string : stringArray) {
                    stringBuilder.append("\t>" + string + "<");
                }
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public List<String[]> getLines() {
        return this.m_lines;
    }

    public int getMaxNumOfFields() {
        return this.m_max_num_of_fields;
    }

    public String getFirstInvalidTargetName(JSONArray jSONArray) throws JSONException {
        if (this.m_fmt.getTargetCol() == 0) {
            return null;
        }
        for (int i = this.m_fmt.getSkipLines(); i < this.m_lines.size(); ++i) {
            String string = this.m_lines.get(i)[this.m_fmt.getTargetCol() - 1];
            if (string.isEmpty()) continue;
            if (jSONArray == null || jSONArray.length() == 0) {
                return string;
            }
            boolean bl = false;
            for (int j = 0; j < jSONArray.length(); ++j) {
                if (!jSONArray.getString(j).equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return string;
        }
        return null;
    }

    public String getFirstInvalidDate() {
        for (int i = this.m_fmt.getSkipLines(); i < this.m_lines.size(); ++i) {
            String string = this.m_lines.get(i)[this.m_fmt.getStartTimeDateCol() - 1];
            if (string.isEmpty()) continue;
            DateTime dateTime = CsvUtils.parse_date_time(string, null);
            if (dateTime == null) {
                return string;
            }
            String string2 = this.m_lines.get(i)[this.m_fmt.getEndTimeDateCol() - 1];
            if (CsvUtils.parse_date_time(string2, dateTime) != null) continue;
            return string2;
        }
        return null;
    }

    public String getFirstInvalidTemplateName() {
        if (this.m_fmt.getTemplateCol() > 0) {
            for (int i = this.m_fmt.getSkipLines(); i < this.m_lines.size(); ++i) {
                String string = this.m_lines.get(i)[this.m_fmt.getTemplateCol() - 1];
                if (Services.app.templateManager().getInfo(string) != null) continue;
                return string;
            }
        }
        return null;
    }

    public String getTemplate(String[] stringArray) {
        if (this.m_fmt.getTemplateCol() == 0) {
            return null;
        }
        return stringArray[this.m_fmt.getTemplateCol() - 1];
    }

    public String getTarget(String[] stringArray) {
        if (this.m_fmt.getTargetCol() == 0) {
            return null;
        }
        return stringArray[this.m_fmt.getTargetCol() - 1];
    }

    public String getStart(String[] stringArray) {
        if (this.m_fmt.getStartTimeDateCol() == 0) {
            return null;
        }
        return stringArray[this.m_fmt.getStartTimeDateCol() - 1];
    }

    public String getEnd(String[] stringArray) {
        if (this.m_fmt.getEndTimeDateCol() == 0) {
            return null;
        }
        return stringArray[this.m_fmt.getEndTimeDateCol() - 1];
    }

    public Map<String, String> getPlaceholders(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.m_fmt.getPlaceholders().keySet()) {
            hashMap.put(string, stringArray[(Integer)this.m_fmt.getPlaceholders().get(string) - 1]);
        }
        hashMap.put("DTSTART", stringArray[this.m_fmt.getStartTimeDateCol() - 1]);
        hashMap.put("DTEND", stringArray[this.m_fmt.getEndTimeDateCol() - 1]);
        hashMap.put("TARGET_NAME", stringArray[this.m_fmt.getTargetCol() - 1]);
        return hashMap;
    }

    public CsvAdapterFormat getFormat() {
        return this.m_fmt;
    }

    public Set<String> getTargets() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.m_fmt.getTargetCol() == 0) {
            return hashSet;
        }
        for (int i = this.m_fmt.getSkipLines(); i < this.m_lines.size(); ++i) {
            String string = this.m_lines.get(i)[this.m_fmt.getTargetCol() - 1];
            if (string.isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }
}

