/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.services;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.AWpRequest;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class SystemMonitorService
extends AWpRequest {
    private static final Logger logger = LogManager.getLogger(SystemMonitorService.class);

    public SystemMonitorService(int n) {
        super("WP-S-SystemMonitor", n, 0);
        WpDataManager wpDataManager = WpDataManager.getManager();
        for (WizePanelItemType wizePanelItemType : wpDataManager.getWizepanels()) {
            if (wizePanelItemType.params().getRequiredWakeup() == wizePanelItemType.params().getWakeup()) continue;
            logger.warn("Messed up WakeUpTime for {}: req: {} now: {}. Correcting.", (Object)wizePanelItemType.getSerialNo(), (Object)wizePanelItemType.params().getRequiredWakeup(), (Object)wizePanelItemType.params().getWakeup());
            DispatcherItemType dispatcherItemType = wpDataManager.getDispatcherByWizepanelId(wizePanelItemType.getSerialNo());
            if (dispatcherItemType == null) continue;
            try {
                DispatcherPool.getPool().sendWakeUpTime(dispatcherItemType.getId(), wizePanelItemType.getSerialNo(), wizePanelItemType.params().getRequiredWakeup(), false);
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                logger.error("BAD", (Throwable)wizePanelExceptions);
            }
        }
    }

    @Override
    public void requestBody() {
        Warnings.getInstance().regularCheckRouters();
        Warnings.getInstance().regularCheckPanels();
        Warnings.getInstance().regularCleanup();
    }
}

