/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.services;

import de.wilke.wizepanel.server.AWpRequest;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.services.BackupRoutingTask;
import de.wilke.wizepanel.services.SystemMonitorService;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WpServiceLauncher {
    private final Logger m_logger = LogManager.getLogger(WpServiceLauncher.class);
    private final Map<WpUpiServerLocator.WpUpiServerLocatorPropType, Class<? extends AWpRequest>> services = new HashMap<WpUpiServerLocator.WpUpiServerLocatorPropType, Class<? extends AWpRequest>>();
    private final List<AWpRequest> running = new LinkedList<AWpRequest>();

    public WpServiceLauncher() {
        this.services.put(WpUpiServerLocator.WpUpiServerLocatorPropType.BACKUP_ROUTING_INTERVAL, BackupRoutingTask.class);
        this.services.put(WpUpiServerLocator.WpUpiServerLocatorPropType.MONITOR_INTERVAL, SystemMonitorService.class);
        this.start();
    }

    public void start() {
        for (WpUpiServerLocator.WpUpiServerLocatorPropType wpUpiServerLocatorPropType : this.services.keySet()) {
            int n = WpUpiServerStaticFactory.getServerLocator().getInt(wpUpiServerLocatorPropType);
            if (n <= 0) continue;
            try {
                Class<? extends AWpRequest> clazz = this.services.get((Object)wpUpiServerLocatorPropType);
                Constructor<? extends AWpRequest> constructor = clazz.getConstructor(Integer.TYPE);
                AWpRequest aWpRequest = constructor.newInstance(n);
                aWpRequest.start(false, this.m_logger, true);
                this.running.add(aWpRequest);
            }
            catch (Exception exception) {
                this.m_logger.debug((Object)exception);
            }
        }
    }

    public void stopEverything() {
        for (AWpRequest aWpRequest : this.running) {
            aWpRequest.exit();
        }
    }
}

