/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.simple_events;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.adapters.types.SimpleEventsRoom;
import de.wilke.wizepanel.core.adapters.types.SimpleEventsRoomGraph;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarUtils;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleEventsServer {
    private static final String ID = "SimpleEventsServer";
    private static final String JSON_ROOMS_GRAPH = "roomsgraph";
    private static final String JSON_EVENTS = "events";
    private static final String JSON_VERSION = "version";
    private static final String VERSION = "2.0";
    private final SimpleEventsRoomGraph rooms = new SimpleEventsRoomGraph();
    private final Map<String, String> events = new HashMap<String, String>();
    private static final SimpleEventsServer _singleton = new SimpleEventsServer();

    private SimpleEventsServer() {
        String string = WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SIMPLE_EVENTS_DB_FILE);
        String string2 = WpFileUtils.readTextFile((File)new File(string), (Charset)Charset.forName("UTF-8"));
        if (string2 != null) {
            try {
                this.read_from_json_config(string2);
            }
            catch (JSONException jSONException) {
                try {
                    this.save_to_file();
                }
                catch (JSONException jSONException2) {
                    // empty catch block
                }
            }
        }
    }

    public static SimpleEventsServer getServer() {
        return _singleton;
    }

    public List<SimpleEventsRoom> getSubrooms(String string) {
        return this.rooms.getSubRooms(string);
    }

    public Set<String> getAllSubrooms(String string) {
        return this.rooms.getAllDescendants(string);
    }

    public synchronized String getRooms() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject = this.rooms.toJSON();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject.toString();
    }

    public synchronized void setRooms(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.rooms.fromJSON(jSONObject);
            this.save_to_file();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private synchronized void read_from_json_config(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        if (jSONObject.has(JSON_VERSION)) {
            if (!jSONObject.getString(JSON_VERSION).equals(VERSION)) {
                return;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(JSON_ROOMS_GRAPH);
            this.rooms.fromJSON(jSONObject2);
            Set set = this.rooms.getAllRooms();
            JSONObject jSONObject3 = jSONObject.getJSONObject(JSON_EVENTS);
            if (jSONObject3.length() != 0) {
                for (String string2 : JSONObject.getNames((JSONObject)jSONObject3)) {
                    String string3 = jSONObject3.getString(string2);
                    CalendarEvent calendarEvent = CalendarUtils.create_event(string3, ID);
                    if (calendarEvent == null || !set.contains(calendarEvent.getTargetName())) continue;
                    this.events.put(string2, string3);
                }
                if (jSONObject3.length() != this.events.size()) {
                    this.save_to_file();
                }
            }
        } else {
            JSONObject jSONObject4 = jSONObject.getJSONObject("rooms");
            JSONObject jSONObject5 = jSONObject.getJSONObject(JSON_EVENTS);
            if (jSONObject4.length() != 0) {
                for (String string4 : JSONObject.getNames((JSONObject)jSONObject4)) {
                    this.rooms.addRoom(string4);
                }
            }
            if (jSONObject5.length() != 0) {
                Set set = this.rooms.getAllRooms();
                for (String string5 : JSONObject.getNames((JSONObject)jSONObject5)) {
                    String string6 = jSONObject5.getString(string5);
                    CalendarEvent calendarEvent = CalendarUtils.create_event(string6, ID);
                    if (calendarEvent == null || !set.contains(calendarEvent.getTargetName())) continue;
                    this.events.put(string5, string6);
                }
            }
            this.save_to_file();
        }
    }

    private void save_to_file() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSON_VERSION, (Object)VERSION);
        JSONObject jSONObject2 = this.rooms.toJSON();
        jSONObject.put(JSON_ROOMS_GRAPH, (Object)jSONObject2);
        JSONObject jSONObject3 = new JSONObject();
        for (String string : this.events.keySet()) {
            jSONObject3.put(string, (Object)this.events.get(string));
        }
        jSONObject.put(JSON_EVENTS, (Object)jSONObject3);
        String string = WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SIMPLE_EVENTS_DB_FILE);
        WpFileUtils.writeTextToFile((File)new File(string), (String)jSONObject.toString(4));
    }

    public synchronized void addEvent(String string, String string2) throws JSONException {
        this.events.put(string, string2);
        this.save_to_file();
    }

    public synchronized String getEvent(String string) {
        return this.events.get(string);
    }

    public synchronized void delEvent(String string) {
        this.events.remove(string);
        try {
            this.save_to_file();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public synchronized long getEvents(long l, List<String> list) {
        long l2 = this.events.hashCode();
        if (l2 == l) {
            return l;
        }
        for (String string : this.events.values()) {
            list.add(string);
        }
        return l2;
    }

    public synchronized void cleanup() {
    }
}

