/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.dispatchers;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WizePanelFatalException;
import de.wilke.wizepanel.prot.basic.CommInvoker;
import de.wilke.wizepanel.prot.basic.Version;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmDispGetFirmwareVer;
import de.wilke.wizepanel.prot.comm.CommCmDispGetWizepanelsAll;
import de.wilke.wizepanel.prot.comm.CommCmDispSetAudioVisualIdentify;
import de.wilke.wizepanel.prot.comm.CommCmDispSetIpSettings;
import de.wilke.wizepanel.prot.comm.CommCmUpdateDispatcher;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSendBmp;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSetWakeUpInterval;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelDataList;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.UpiResDescrNaming;
import de.wilke.wizepanel.upi.UpiUtils;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.engine.transactions.Entry;
import de.wilke.wizepanel.upi.engine.transactions.TransactionManager;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DispatcherActions {
    protected final Logger logger;
    protected final DispatcherItemType dispatcher;
    private final boolean fast_mode;
    protected long calc_data_memory = 0L;
    protected long data_memory = 0L;

    public DispatcherActions(DispatcherItemType dispatcherItemType, boolean bl, Logger logger) {
        this.logger = logger;
        this.dispatcher = dispatcherItemType;
        this.fast_mode = bl;
        logger.info("v" + this.actionProtocolVersion() + " [" + bl + "]");
    }

    public Entry get_next_job() {
        List<Entry> list = TransactionManager.getManager().getAllJobs(this.dispatcher.getId(), Entry.STATUS.ON_SERVER);
        List<Entry> list2 = TransactionManager.getManager().getAllJobs(this.dispatcher.getId(), Entry.STATUS.ON_ROUTER);
        Iterator<Entry> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.getWpid() == 0) {
                return entry;
            }
            for (Entry entry2 : list2) {
                if (!entry.getCommand().is_mergeable || entry.getWpid() != entry2.getWpid()) continue;
                if (entry.getCommand() == entry2.getCommand()) {
                    this.logger.debug("Removing ON_ROUTER job: " + entry2.getId());
                    TransactionManager.getManager().setJobStatus(entry2, Entry.STATUS.OVERWRITTEN);
                    continue;
                }
                iterator.remove();
                continue block0;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public Entry get_next_critical_job() {
        Entry entry = this.get_next_job();
        if (entry == null || entry.getPriority() != 0) {
            return null;
        }
        return entry;
    }

    public final Reply exec(Entry entry) throws WizePanelExceptions {
        Reply reply = new Reply();
        switch (entry.getCommand()) {
            case WP_IMAGE: {
                reply.trans_id = this.send_image(entry.getWpid(), entry.getCommandData());
                reply.status = Entry.STATUS.ON_ROUTER;
                break;
            }
            case WP_WAKEUP: {
                reply.trans_id = this.send_wakeup(entry.getWpid(), Integer.parseInt(entry.getCommandData()));
                reply.status = Entry.STATUS.ON_ROUTER;
                break;
            }
            case DP_UPDATE_FIRMWARE: {
                this.send_update(entry.getCommandData());
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                reply.status = Entry.STATUS.FINISHED;
                reply.reread_version = true;
                break;
            }
            case DP_ADDRESS: {
                this.send_address(entry.getCommandData());
                reply.update_thread_name = true;
                reply.status = Entry.STATUS.FINISHED;
                break;
            }
            case DP_RESTART: {
                this.send_reset();
                reply.status = Entry.STATUS.FINISHED;
                break;
            }
            case DP_IDENTIFY: {
                this.send_identify(entry.getCommandData());
                reply.status = Entry.STATUS.FINISHED;
                break;
            }
            case CANCEL_TRANSACTION: {
                Entry entry2 = TransactionManager.getManager().getJob(entry.getCommandData());
                if (entry2 == null) {
                    reply.status = Entry.STATUS.ERROR;
                    break;
                }
                if (this.exec_cancel(entry2)) {
                    TransactionManager.getManager().setJobStatus(entry2, Entry.STATUS.CANCELLED);
                    reply.status = Entry.STATUS.FINISHED;
                    break;
                }
                reply.status = Entry.STATUS.ERROR;
                break;
            }
            default: {
                return this.exec_special(entry);
            }
        }
        return reply;
    }

    protected Reply exec_special(Entry entry) throws WizePanelExceptions {
        throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_UNKNOWN_METHOD, entry.toString());
    }

    public void exec_get_errors() throws WizePanelExceptions {
    }

    public void update_stats() throws WizePanelExceptions {
    }

    public void read_settings() throws WizePanelExceptions {
    }

    public void exec_update_stats() throws WizePanelExceptions {
        this.send_get_all_wps();
    }

    protected boolean exec_cancel(Entry entry) throws WizePanelExceptions {
        return false;
    }

    public boolean check_is_ready_to_run() {
        return true;
    }

    private void send_update(String string) throws WizePanelExceptions {
        CommCmUpdateDispatcher commCmUpdateDispatcher = new CommCmUpdateDispatcher(UpiUtils.base642data((String)string));
        this.send_to_dispatcher((ACommCommand)commCmUpdateDispatcher);
    }

    private void send_address(String string) throws WizePanelExceptions {
        String string2;
        String string3;
        int n;
        String string4;
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string);
            string4 = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_IP.toString());
            n = jSONObject.getInt(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_PORT.toString());
            string3 = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_SUBNET.toString());
            string2 = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_GATEWAY.toString());
        }
        catch (JSONException jSONException) {
            throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, string);
        }
        this.logger.debug("[setaddress] => " + string4 + ":" + n);
        jSONObject = new CommCmDispSetIpSettings(string4, n, string3, string2);
        this.send_to_dispatcher((ACommCommand)jSONObject);
        this.dispatcher.params().setIp(string4);
        this.dispatcher.params().setPort(n);
        this.dispatcher.params().setSubnet(string3);
        this.dispatcher.params().setGateway(string2);
        DispatcherPool.getPool().updateDispatcher(this.dispatcher, null, false, true);
    }

    protected void send_get_all_wps() throws WizePanelExceptions {
        CommCmDispGetWizepanelsAll commCmDispGetWizepanelsAll = new CommCmDispGetWizepanelsAll();
        commCmDispGetWizepanelsAll.initializeCommandParams();
        this.send_to_dispatcher((ACommCommand)commCmDispGetWizepanelsAll);
        WizePanelDataList wizePanelDataList = new WizePanelDataList(commCmDispGetWizepanelsAll.getWizePanelList());
        Date date = new Date();
        for (WizePanelItemType wizePanelItemType : wizePanelDataList.getWpDataList()) {
            wizePanelItemType.setLastUpdate(date);
        }
        this.process_getwpparams(this.dispatcher, wizePanelDataList.getWpDataList());
        DispatcherPool.getPool().updateDispatcher(this.dispatcher, wizePanelDataList, true, false);
    }

    protected void send_reset() throws WizePanelExceptions {
    }

    private long send_image(int n, String string) throws WizePanelExceptions {
        byte[] byArray = UpiUtils.base642data((String)string);
        CommCmWizePanelSendBmp commCmWizePanelSendBmp = new CommCmWizePanelSendBmp(n, byArray);
        this.send_to_dispatcher((ACommCommand)commCmWizePanelSendBmp);
        return commCmWizePanelSendBmp.getResponseHeader().getTransactionId();
    }

    private void send_identify(String string) throws WizePanelExceptions {
        CommCmDispSetAudioVisualIdentify commCmDispSetAudioVisualIdentify = new CommCmDispSetAudioVisualIdentify(Integer.parseInt(string));
        this.send_to_dispatcher((ACommCommand)commCmDispSetAudioVisualIdentify);
    }

    private long send_wakeup(int n, int n2) throws WizePanelExceptions {
        CommCmWizePanelSetWakeUpInterval commCmWizePanelSetWakeUpInterval = new CommCmWizePanelSetWakeUpInterval(n, n2 / 60);
        this.send_to_dispatcher((ACommCommand)commCmWizePanelSetWakeUpInterval);
        return commCmWizePanelSetWakeUpInterval.getResponseHeader().getTransactionId();
    }

    public final void send_to_dispatcher(ACommCommand aCommCommand) throws WizePanelExceptions {
        DispatcherItemType dispatcherItemType;
        WizePanelExceptions wizePanelExceptions = null;
        try {
            new CommInvoker(this.fast_mode).ExecuteCommand(this.dispatcher.params().getIp(), this.dispatcher.params().getPort(), aCommCommand);
        }
        catch (WizePanelExceptions wizePanelExceptions2) {
            wizePanelExceptions = wizePanelExceptions2;
        }
        this.dispatcher.setLastUpdateSuccessful(wizePanelExceptions == null);
        if (wizePanelExceptions == null) {
            this.dispatcher.setLastUpdate(System.currentTimeMillis());
        }
        if ((dispatcherItemType = WpDataManager.getManager().getDispatcherById(this.dispatcher.getId())) != null) {
            dispatcherItemType.setLastUpdateSuccessful(this.dispatcher.isLastUpdateSuccessful());
            dispatcherItemType.setLastUpdate(this.dispatcher.getLastUpdate());
        }
        if (wizePanelExceptions != null) {
            throw wizePanelExceptions;
        }
    }

    public Version get_version() {
        try {
            CommCmDispGetFirmwareVer commCmDispGetFirmwareVer = new CommCmDispGetFirmwareVer();
            this.send_to_dispatcher((ACommCommand)commCmDispGetFirmwareVer);
            return new Version(commCmDispGetFirmwareVer.getDispFirmwareVer());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int actionProtocolVersion() {
        return 1;
    }

    protected void process_getwpparams(DispatcherItemType dispatcherItemType, List<WizePanelItemType> list) {
        WpDataManager wpDataManager = WpDataManager.getManager();
        this.logger.debug("processing getwpparams: " + (String)(list == null ? "[null]" : "#" + list.size()));
        if (list != null) {
            boolean bl = WpUpiServerStaticFactory.getServerLocator().getBoolean(WpUpiServerLocator.WpUpiServerLocatorPropType.UPI_WP_SERVER_STATIC_ROUTING);
            Iterator<WizePanelItemType> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getSerialNo() != 0) continue;
                iterator.remove();
            }
            wpDataManager.addWizePanels(list, dispatcherItemType);
            if (!bl) {
                UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
                UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterById(dispatcherItemType.getId());
                boolean bl2 = false;
                UpiTargetItem[] upiTargetItemArray = new UpiTargetItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    WizePanelItemType wizePanelItemType = list.get(i);
                    upiTargetItemArray[i] = new UpiTargetItem(Integer.toString(wizePanelItemType.getSerialNo()));
                    upiTargetItemArray[i].getParams().copyFrom(wizePanelItemType.params());
                    String string = Integer.toString(wizePanelItemType.getSerialNo());
                    if (upiRouterItem.getTargetById(string) != null) continue;
                    upiRouterItem.addTarget(new UpiTargetItem(string));
                    bl2 = true;
                }
                if (bl2) {
                    upiRoutingHandler.saveRoutingTable();
                }
            }
        }
    }

    protected void update_job_states() throws WizePanelExceptions {
    }

    public void register_panels() throws WizePanelExceptions {
    }

    protected void kill_all_dispatcher_jobs() throws WizePanelExceptions {
    }

    class Reply {
        public Entry.STATUS status;
        public long trans_id;
        public boolean reread_version = false;
        public boolean update_thread_name = false;

        Reply() {
        }
    }
}

