/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.dispatchers;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.prot.comm.types.SendDataHeader;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelDataList;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.UpiUtils;
import de.wilke.wizepanel.upi.engine.dispatchers.DataCommand;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherThread;
import de.wilke.wizepanel.upi.engine.transactions.Entry;
import de.wilke.wizepanel.upi.engine.transactions.TransactionManager;
import de.wilke.wizepanel.upi.routing.RoutingTable;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DispatcherPool {
    private static Logger m_logger = null;
    private static DispatcherPool pool = null;
    private final Map<String, DispatcherThread> d_threads = new ConcurrentHashMap<String, DispatcherThread>();
    private final Map<String, WizePanelDataList> d_wizepanels = new ConcurrentHashMap<String, WizePanelDataList>();

    private DispatcherPool() {
        m_logger = LogManager.getLogger(DispatcherPool.class);
    }

    public static synchronized DispatcherPool getPool() {
        if (pool == null) {
            pool = new DispatcherPool();
            WpDataManager wpDataManager = WpDataManager.getManager();
            List<DispatcherItemType> list = wpDataManager.getDispatchers();
            for (DispatcherItemType dispatcherItemType : list) {
                WizePanelDataList wizePanelDataList = new WizePanelDataList(wpDataManager.getWizepanelsByDispatcher(dispatcherItemType.getId()));
                pool.updateDispatcher(dispatcherItemType, wizePanelDataList, false, false);
            }
            m_logger.debug("DispatcherPool created!");
        }
        return pool;
    }

    public synchronized void updateDispatcherName(String string, String string2) {
        if (this.d_threads.containsKey(string)) {
            this.d_threads.get(string).resetDeadCounter();
            DispatcherItemType dispatcherItemType = this.d_threads.get(string).getDispatcherData();
            dispatcherItemType.params().setName(string2);
        }
    }

    public synchronized void updateDispatcher(DispatcherItemType dispatcherItemType, WizePanelDataList wizePanelDataList, boolean bl, boolean bl2) {
        if (!this.d_threads.containsKey(dispatcherItemType.getId())) {
            m_logger.debug("Creating new dispatcher thread for: " + dispatcherItemType.getId() + " {IP: " + dispatcherItemType.getPrettyId() + "}");
            for (String string : this.d_threads.keySet()) {
                DispatcherThread dispatcherThread = this.d_threads.get(string);
                DispatcherItemType dispatcherItemType2 = dispatcherThread.getDispatcherData();
                if (!dispatcherItemType2.params().getIp().equals(dispatcherItemType.params().getIp()) || dispatcherItemType2.params().getPort() != dispatcherItemType.params().getPort() || dispatcherItemType2.getId() == dispatcherItemType.getId() || dispatcherItemType2.params().getStatus() == DispatcherThread.Status.THREAD_TERMINATED.name()) continue;
                m_logger.warn("New Dispatcher [" + dispatcherItemType.getId() + "] has IP/Port of already known Dispatcher[" + dispatcherItemType2.getId() + "]");
                dispatcherThread.terminate(true);
                UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
                UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterById(dispatcherItemType2.getId());
                if (upiRouterItem == null) continue;
                upiRouterItem.getParams().setStatus(DispatcherThread.Status.THREAD_TERMINATED.name());
                upiRoutingHandler.saveRoutingTable();
                WpDataManager.getManager().reload();
            }
            DispatcherThread dispatcherThread = new DispatcherThread(dispatcherItemType);
            this.d_threads.put(dispatcherItemType.getId(), dispatcherThread);
            this.sendUpdateStats(dispatcherItemType.getId());
            dispatcherThread.start();
            dispatcherThread.wakeMeUp();
        } else if (!this.d_threads.get(dispatcherItemType.getId()).isAlive()) {
            DispatcherItemType dispatcherItemType3 = this.d_threads.get(dispatcherItemType.getId()).getDispatcherData();
            dispatcherItemType.params().setMaxWP(dispatcherItemType3.params().getMaxWP());
            dispatcherItemType.params().setVersion(dispatcherItemType3.params().getVersion());
            dispatcherItemType.params().setStatus(dispatcherItemType3.params().getStatus());
            dispatcherItemType.params().setTimeZone(dispatcherItemType3.params().getTimeZone());
            dispatcherItemType.params().setDHCP(dispatcherItemType3.params().isDHCP());
            if (WpUpiServerStaticFactory.getRoutingHandler().getRouterById(dispatcherItemType.getId()) != null) {
                dispatcherItemType.params().setName(dispatcherItemType3.params().getName());
            }
            WpDataManager.getManager().addDispatcher(dispatcherItemType);
            this.d_threads.remove(dispatcherItemType.getId());
            for (String string : this.d_threads.keySet()) {
                DispatcherThread dispatcherThread = this.d_threads.get(string);
                DispatcherItemType dispatcherItemType4 = dispatcherThread.getDispatcherData();
                if (!dispatcherItemType4.params().getIp().equals(dispatcherItemType.params().getIp()) || dispatcherItemType4.params().getPort() != dispatcherItemType.params().getPort() || dispatcherItemType4.getId() == dispatcherItemType.getId() || dispatcherItemType4.params().getStatus() == DispatcherThread.Status.THREAD_TERMINATED.name()) continue;
                m_logger.warn("Known dead Dispatcher [" + dispatcherItemType.getId() + "] now has IP/Port of Dispatcher[" + dispatcherItemType4.getId() + "]");
                dispatcherThread.terminate(true);
                UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
                UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterById(dispatcherItemType4.getId());
                if (upiRouterItem == null) continue;
                upiRouterItem.getParams().setStatus("THREAD_TERMINATED");
                upiRoutingHandler.saveRoutingTable();
                WpDataManager.getManager().reload();
            }
            DispatcherThread dispatcherThread = new DispatcherThread(dispatcherItemType);
            this.d_threads.put(dispatcherItemType.getId(), dispatcherThread);
            this.sendUpdateStats(dispatcherItemType.getId());
            dispatcherThread.start();
            dispatcherThread.wakeMeUp();
        } else {
            this.d_threads.get(dispatcherItemType.getId()).resetDeadCounter();
            if (bl2) {
                String string2;
                DispatcherItemType dispatcherItemType5 = this.d_threads.get(dispatcherItemType.getId()).getDispatcherData();
                Boolean bl3 = false;
                if (!dispatcherItemType5.params().equalsCore(dispatcherItemType.params())) {
                    bl3 = true;
                }
                dispatcherItemType.params().setMaxWP(dispatcherItemType5.params().getMaxWP());
                dispatcherItemType.params().setVersion(dispatcherItemType5.params().getVersion());
                dispatcherItemType.params().setStatus(dispatcherItemType5.params().getStatus());
                dispatcherItemType.params().setTimeZone(dispatcherItemType5.params().getTimeZone());
                dispatcherItemType.params().setDHCP(dispatcherItemType5.params().isDHCP());
                if (WpUpiServerStaticFactory.getRoutingHandler().getRouterById(dispatcherItemType.getId()) != null) {
                    dispatcherItemType.params().setName(dispatcherItemType5.params().getName());
                }
                dispatcherItemType5.copyFrom(dispatcherItemType, false);
                for (String string2 : this.d_threads.keySet()) {
                    DispatcherThread dispatcherThread = this.d_threads.get(string2);
                    DispatcherItemType dispatcherItemType6 = dispatcherThread.getDispatcherData();
                    if (!dispatcherItemType6.params().getIp().equals(dispatcherItemType.params().getIp()) || dispatcherItemType6.params().getPort() != dispatcherItemType.params().getPort() || dispatcherItemType6.getId() == dispatcherItemType.getId() || dispatcherItemType6.params().getStatus() == DispatcherThread.Status.THREAD_TERMINATED.name()) continue;
                    m_logger.warn("Known active Dispatcher [" + dispatcherItemType.getId() + "] now has IP/Port of Dispatcher[" + dispatcherItemType6.getId() + "]");
                    dispatcherThread.terminate(true);
                    UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
                    UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterById(dispatcherItemType6.getId());
                    if (upiRouterItem == null) continue;
                    upiRouterItem.getParams().setStatus("THREAD_TERMINATED");
                    upiRoutingHandler.saveRoutingTable();
                    WpDataManager.getManager().reload();
                }
                WpDataManager.getManager().addDispatcher(dispatcherItemType);
                UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
                string2 = upiRoutingHandler.getRouterById(dispatcherItemType.getId());
                if (string2 != null) {
                    if (bl3.booleanValue()) {
                        m_logger.debug("Updating dispatcher " + dispatcherItemType.getId() + " params from " + string2.getParams().toJSON() + " to " + dispatcherItemType5.toJSON());
                        string2.getParams().importFrom(dispatcherItemType5.params());
                        upiRoutingHandler.saveRoutingTable();
                        WpDataManager.getManager().reload();
                    } else {
                        string2.getParams().importFrom(dispatcherItemType5.params());
                    }
                }
            }
        }
        if (wizePanelDataList != null) {
            if (this.d_wizepanels.get(dispatcherItemType.getId()) != null && this.d_wizepanels.get(dispatcherItemType.getId()).getWpDataList() != null && wizePanelDataList.getWpDataList().size() < this.d_wizepanels.get(dispatcherItemType.getId()).getWpDataList().size()) {
                m_logger.warn("DispatcherReset1: now:" + wizePanelDataList.getWpDataList().size() + " was:" + this.d_wizepanels.get(dispatcherItemType.getId()).getWpDataList().size());
            }
            this.d_wizepanels.put(dispatcherItemType.getId(), wizePanelDataList);
            if (bl) {
                this.update_dispatcher_108(dispatcherItemType, wizePanelDataList);
            }
        }
    }

    private void update_dispatcher_108(DispatcherItemType dispatcherItemType, WizePanelDataList wizePanelDataList) {
        boolean bl = false;
        List<Entry> list = TransactionManager.getManager().getAllJobs(dispatcherItemType.getId(), Entry.STATUS.ON_ROUTER);
        if (list == null || list.size() == 0) {
            return;
        }
        for (Entry entry : list) {
            WizePanelItemType wizePanelItemType = wizePanelDataList.getById(entry.getWpid());
            if (wizePanelItemType == null) {
                m_logger.warn("DispatcherReset6: " + entry.getWpid());
                entry.setCompletedTransactions(1);
                TransactionManager.getManager().setJobStatus(entry, Entry.STATUS.ON_ROUTER);
                continue;
            }
            if (wizePanelItemType.params().getGoodTransmissions() > entry.getCompletedTransactions()) {
                m_logger.info("Updating job-status: WPID:" + entry.getWpid() + " for " + entry.getId());
                TransactionManager.getManager().setJobStatus(entry, Entry.STATUS.ON_TARGET);
                bl = true;
            } else if (wizePanelItemType.params().getGoodTransmissions() < entry.getCompletedTransactions()) {
                m_logger.warn("DispatcherReset2(wp: " + entry.getWpid() + " transid: " + entry.getId() + " completed job:" + entry.getCompletedTransactions() + " received:" + wizePanelItemType.params().getGoodTransmissions() + " failed job:" + entry.getFailedFransactions() + " received:" + wizePanelItemType.params().getBadTransmissions() + ") dispatcher:" + dispatcherItemType.getId());
                entry.setCompletedTransactions(wizePanelItemType.params().getGoodTransmissions());
                TransactionManager.getManager().setJobStatus(entry, Entry.STATUS.ON_SERVER);
            }
            if (wizePanelItemType.params().getBadTransmissions() <= entry.getFailedFransactions() + 10) continue;
            m_logger.warn("DispatcherReset3: " + entry.getWpid() + " job:" + entry.getFailedFransactions() + " received:" + wizePanelItemType.params().getBadTransmissions());
        }
        if (bl) {
            this.run_dispatcher_queue(dispatcherItemType.getId());
        }
    }

    public String sendWakeUpTime(String string, int n, int n2, boolean bl) throws WizePanelExceptions {
        WizePanelItemType wizePanelItemType = this.getWizePanel(string, n);
        if (bl) {
            wizePanelItemType.params().setRequiredWakeup(n2);
        }
        string = this.check_dispatcher(string, n);
        String string2 = TransactionManager.getManager().add(Entry.COMMAND.WP_WAKEUP, 2, string, n, String.valueOf(n2), Entry.STATUS.ON_SERVER, wizePanelItemType.params().getGoodTransmissions(), wizePanelItemType.params().getBadTransmissions());
        this.run_dispatcher_queue(string);
        return string2;
    }

    public String sendScreenUpdateMethod(String string, int n, String string2) throws WizePanelExceptions {
        WizePanelItemType wizePanelItemType = this.getWizePanel(string, n);
        string = this.check_dispatcher(string, n);
        String string3 = TransactionManager.getManager().add(Entry.COMMAND.WP_SCREEN_UPDATE_METHOD, 2, string, n, string2, Entry.STATUS.ON_SERVER, wizePanelItemType.params().getGoodTransmissions(), wizePanelItemType.params().getBadTransmissions());
        this.run_dispatcher_queue(string);
        return string3;
    }

    public String sendCancelJob(String string, String string2) throws WizePanelExceptions {
        String string3 = TransactionManager.getManager().add(Entry.COMMAND.CANCEL_TRANSACTION, 0, string, 0, string2, Entry.STATUS.ON_SERVER, 0, 0);
        this.run_dispatcher_queue(string);
        return string3;
    }

    public String setDispatcherAddress(String string, String string2) {
        String string3 = TransactionManager.getManager().add(Entry.COMMAND.DP_ADDRESS, 1, string, 0, string2, Entry.STATUS.ON_SERVER, 0, 0);
        this.run_dispatcher_queue(string);
        return string3;
    }

    public String sendImage(String string, int n, byte[] byArray) throws WizePanelExceptions {
        WizePanelItemType wizePanelItemType = this.getWizePanel(string, n);
        string = this.check_dispatcher(string, n);
        String string2 = TransactionManager.getManager().add(Entry.COMMAND.WP_IMAGE, 2, string, n, UpiUtils.data2base64((byte[])byArray), Entry.STATUS.ON_SERVER, wizePanelItemType.params().getGoodTransmissions(), wizePanelItemType.params().getBadTransmissions());
        this.run_dispatcher_queue(string);
        return string2;
    }

    public String sendDispatcherUpdate(String string, String string2) {
        String string3 = TransactionManager.getManager().add(Entry.COMMAND.DP_UPDATE_FIRMWARE, 0, string, 0, string2, Entry.STATUS.ON_SERVER, 0, 0);
        this.run_dispatcher_queue(string);
        return string3;
    }

    public String sendData(String string, int n, byte[] byArray, SendDataHeader.Type type) throws WizePanelExceptions {
        WizePanelItemType wizePanelItemType = this.getWizePanel(string, n);
        string = this.check_dispatcher(string, n);
        DataCommand dataCommand = new DataCommand(byArray, type);
        String string2 = TransactionManager.getManager().add(Entry.COMMAND.WP_DATA, 2, string, n, dataCommand.toString(), Entry.STATUS.ON_SERVER, wizePanelItemType.params().getGoodTransmissions(), wizePanelItemType.params().getBadTransmissions());
        this.run_dispatcher_queue(string);
        return string2;
    }

    public void sendUpdateJobs(String string) {
        DispatcherThread dispatcherThread = this.d_threads.get(string);
        if (dispatcherThread != null) {
            dispatcherThread.updateJobs();
        }
    }

    public void sendUpdateStatsToAllDispatchers() {
        for (DispatcherThread dispatcherThread : this.d_threads.values()) {
            dispatcherThread.updateStats();
        }
    }

    public void sendUpdateStats(String string) {
        DispatcherThread dispatcherThread = this.d_threads.get(string);
        if (dispatcherThread != null) {
            dispatcherThread.updateStats();
        }
    }

    public void sendReadErrors(String string) {
        DispatcherThread dispatcherThread = this.d_threads.get(string);
        if (dispatcherThread != null) {
            dispatcherThread.readErrors();
        }
    }

    public String sendReset(String string) {
        String string2 = TransactionManager.getManager().add(Entry.COMMAND.DP_RESTART, 0, string, 0, "", Entry.STATUS.ON_SERVER, 0, 0);
        this.run_dispatcher_queue(string);
        return string2;
    }

    public String sendIdentify(String string, String string2) {
        String string3 = TransactionManager.getManager().add(Entry.COMMAND.DP_IDENTIFY, 1, string, 0, string2, Entry.STATUS.ON_SERVER, 0, 0);
        this.run_dispatcher_queue(string);
        return string3;
    }

    private String check_dispatcher(String string, int n) {
        Entry entry = TransactionManager.getManager().getNextUnfinishedJob(n);
        if (entry != null && !entry.getDispatcher().equals(string)) {
            m_logger.debug("USING dispatcher " + entry.getDispatcher() + " instead of " + string);
            return entry.getDispatcher();
        }
        return string;
    }

    public void run_dispatcher_queue(String string) {
        if (string == null) {
            for (DispatcherThread dispatcherThread : this.d_threads.values()) {
                dispatcherThread.wakeMeUp();
            }
        } else {
            DispatcherThread dispatcherThread = this.d_threads.get(string);
            if (dispatcherThread != null) {
                dispatcherThread.wakeMeUp();
            }
        }
    }

    private WizePanelItemType getWizePanel(String string, int n) throws WizePanelExceptions {
        if (this.d_wizepanels.get(string) == null) {
            return null;
        }
        for (WizePanelItemType wizePanelItemType : this.d_wizepanels.get(string).getWpDataList()) {
            if (wizePanelItemType.getSerialNo() != n) continue;
            return wizePanelItemType;
        }
        if (WpUpiServerStaticFactory.getServerLocator().getBoolean(WpUpiServerLocator.WpUpiServerLocatorPropType.UPI_WP_SERVER_STATIC_ROUTING)) {
            return new WizePanelItemType(0, 0, 0, 0, 0, 0, 0, 0);
        }
        throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_TARGET_NOT_KNOWN_BY_DISPATCHER);
    }

    public String getDynamicRouting() {
        RoutingTable routingTable = new RoutingTable();
        for (String string : this.d_wizepanels.keySet()) {
            Object object3;
            Object object2;
            routingTable.addRouter(string);
            DispatcherThread dispatcherThread = this.d_threads.get(string);
            if (dispatcherThread != null) {
                object2 = dispatcherThread.getDispatcherData();
                if (object2.getLastUpdate() > 0L) {
                    object2.params().setLastSeen((int)((System.currentTimeMillis() - object2.getLastUpdate()) / 1000L));
                }
                routingTable.setRouterParameter(string, object2.params());
            }
            for (Object object3 : this.d_wizepanels.get((Object)string).wpDataList) {
                routingTable.addRouterTarget(string, new UpiTargetItem(String.valueOf(object3.getSerialNo()), object3.params()));
            }
            object2 = UpiRoutingHandler.getInstance().getRouterById(string);
            if (object2 == null) continue;
            object3 = object2.getTargets();
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(routingTable.getRouterTargets(string)));
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                UpiTargetItem upiTargetItem = (UpiTargetItem)iterator.next();
                if (hashSet.contains(upiTargetItem.getId())) continue;
                routingTable.addRouterTarget(string, new UpiTargetItem(upiTargetItem));
                m_logger.info("Configured WizePanel not in DispatcherList! [disp: " + string + " , wzp: " + upiTargetItem.getId() + "]");
            }
        }
        return routingTable.toString();
    }

    public synchronized String setRouting(String string) throws WizePanelExceptions {
        m_logger.info("New routing table: " + string);
        RoutingTable routingTable = new RoutingTable(string);
        if (routingTable.getRouters() != null) {
            int n = 0;
            for (String string2 : routingTable.getRouters()) {
                String[] stringArray2 = routingTable.getRouterTargets(string2);
                if (stringArray2 == null) continue;
                n += stringArray2.length;
            }
            int n2 = LicenseManager.getManager().getLicenseCount(LicenseManager.LicensePackages.WZP_SOFT_BA);
            if (n2 > 0 && n > n2) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_LICENSE_VIOLATION_TOO_MANY_TARGETS);
            }
        }
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        for (Map.Entry<String, DispatcherThread> entry : this.d_threads.entrySet()) {
            String string3 = entry.getKey();
            if (WpDataManager.getManager().getDispatcherById(string3) == null) continue;
            entry.getValue().terminate(true);
        }
        this.d_threads.clear();
        LinkedList linkedList = new LinkedList();
        if (routingTable.getRouters() != null) {
            for (String string2 : routingTable.getRouters()) {
                UpiRouterItem upiRouterItem = new UpiRouterItem(string2);
                upiRouterItem.getParams().importFrom(routingTable.getRouterParameters(string2));
                if (routingTable.getRouterTargets(string2) != null) {
                    for (String string3 : routingTable.getRouterTargets(string2)) {
                        upiRouterItem.addTarget(new UpiTargetItem(string3, routingTable.getRouterTargetParameters(string2, string3)));
                    }
                }
                linkedList.add(upiRouterItem);
            }
        }
        upiRoutingHandler.setRouters((List)linkedList);
        upiRoutingHandler.saveRoutingTable();
        WpDataManager wpDataManager = WpDataManager.getManager();
        wpDataManager.reload();
        TransactionManager.getManager().abandonAllOpenWizePanelJobs();
        for (WizePanelItemType wizePanelItemType : wpDataManager.getWizepanels()) {
            DispatcherItemType dispatcherItemType = wpDataManager.getDispatcherByWizepanelId(wizePanelItemType.getSerialNo());
            if (dispatcherItemType == null) {
                TransactionManager.getManager().deleteWizePanelJobs(wizePanelItemType.getSerialNo());
                continue;
            }
            TransactionManager.getManager().reassignWizePanelJobs(wizePanelItemType.getSerialNo(), dispatcherItemType.getId());
        }
        for (String string5 : this.d_threads.keySet()) {
            this.d_threads.get(string5).registerPanels();
        }
        for (DispatcherItemType dispatcherItemType : wpDataManager.getDispatchers()) {
            this.updateDispatcher(dispatcherItemType, null, false, false);
        }
        return "";
    }

    public Set<String> getDispatchers() {
        return this.d_wizepanels.keySet();
    }

    public void update_completed_counter(Entry entry) {
        if (entry.getWpid() == 0) {
            return;
        }
        try {
            WizePanelItemType wizePanelItemType = this.getWizePanel(entry.getDispatcher(), entry.getWpid());
            entry.setCompletedTransactions(wizePanelItemType.params().getGoodTransmissions());
            entry.setFailedTransactions(wizePanelItemType.params().getBadTransmissions());
        }
        catch (WizePanelExceptions wizePanelExceptions) {
            m_logger.debug((Object)wizePanelExceptions);
        }
    }

    public String getDispatcherStatus(String string) {
        DispatcherThread dispatcherThread = this.d_threads.get(string);
        if (dispatcherThread != null) {
            return dispatcherThread.getStatus();
        }
        return "";
    }

    public String getDispatcherDebug(String string) {
        DispatcherThread dispatcherThread = this.d_threads.get(string);
        if (dispatcherThread != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("good", dispatcherThread.getDebugGood());
                jSONObject.put("bad", dispatcherThread.getDebugBad());
                jSONObject.put("calc_data_memory", dispatcherThread.getCalcDataMemory());
                jSONObject.put("data_memory", dispatcherThread.getDataMemory());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jSONObject.toString();
        }
        return "";
    }

    public void removeDispatcher(String string) {
        DispatcherThread dispatcherThread = this.d_threads.get(string);
        dispatcherThread.terminate(false);
        m_logger.info("Removed dispatcher thread: " + dispatcherThread.getName());
    }
}

