/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.services;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommPacket;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.comm.CommCmSysGetDispatchers;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.server.AWpRequest;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import java.net.DatagramPacket;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WpDispatcherListener
extends AWpRequest {
    private static final Logger m_logger = LogManager.getLogger(WpDispatcherListener.class);
    private final int port = WpUpiServerStaticFactory.getServerLocator().getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.DISPATCHERS_REQUEST_PORT);
    private final int duration = WpUpiServerStaticFactory.getServerLocator().getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.DISPATCHERS_REQUEST_DURATION) * 1000;

    public WpDispatcherListener(int n) {
        super("WP-S-DispatcherListener", n);
        m_logger.info("Listening on port " + this.port + " for " + this.duration + " ms");
    }

    @Override
    public void requestBody() {
        try {
            this.run_new();
        }
        catch (Throwable throwable) {
            m_logger.fatal("RAGNAROK", throwable);
        }
    }

    private void run_new() {
        List list = null;
        try {
            list = new CommSocketsOperations().receiveUdpDatagrams(this.port, this.duration);
        }
        catch (Exception exception) {
            m_logger.warn((Object)exception);
            return;
        }
        HashMap<String, DispatcherItemType> hashMap = new HashMap<String, DispatcherItemType>();
        CommPacket commPacket = new CommPacket();
        for (DatagramPacket datagramPacket : list) {
            if (datagramPacket.getLength() <= 0) continue;
            CommCmSysGetDispatchers commCmSysGetDispatchers = new CommCmSysGetDispatchers();
            commCmSysGetDispatchers.initializeCommandParams();
            try {
                if (commPacket.parse(datagramPacket.getData(), datagramPacket.getLength())) {
                    commCmSysGetDispatchers.parseResponse(commPacket.commandHeader(), commPacket.commandPayload());
                    DispatcherItemType dispatcherItemType = commCmSysGetDispatchers.getDispatcher();
                    dispatcherItemType.params().setIp(datagramPacket.getAddress().getHostAddress());
                    hashMap.put(dispatcherItemType.getId(), dispatcherItemType);
                    continue;
                }
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                m_logger.debug("Could not process UDP datagram: " + commPacket.toHex(), (Throwable)wizePanelExceptions);
            }
        }
        if (hashMap.size() == 0) {
            return;
        }
        for (DatagramPacket datagramPacket : hashMap.values()) {
            WpDataManager.getManager().addDispatcher((DispatcherItemType)datagramPacket);
            m_logger.debug("==found: " + datagramPacket.params().getIp() + " / " + datagramPacket.getId() + " / " + datagramPacket.params().getVersion());
            DispatcherPool.getPool().updateDispatcher((DispatcherItemType)datagramPacket, null, false, true);
        }
    }
}

