/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.transactions;

import java.io.PrintWriter;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="TRANSACTIONS")
public class Entry {
    public static final int PRIORITY_CRITICAL = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_LOW = 2;
    @Transient
    public static final int MAX_DATA_LEN = 524288;
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @Column(name="ID")
    private String id;
    @Column(name="PRIORITY")
    private int priority;
    @Column(name="EXECUTED_TRANSMISSIONS")
    private int executed_transmissions;
    @Column(name="COMMAND_ID")
    private int command_id;
    @Column(name="TIMESTAMP")
    private Timestamp timestamp;
    @Column(name="FINISHED_ON")
    private Timestamp finished_on;
    @Column(name="STATUS")
    private int status;
    @Column(name="STATUS_DETAILS")
    private String status_details;
    @Column(name="DISPATCHER", length=255)
    private String dispatcher;
    @Column(name="WIZEPANEL")
    private int wpid;
    @Column(name="COMMAND_DATA", length=524288, columnDefinition="longvarchar")
    private String command_data;
    @Column(name="COMPLETED")
    private Integer completed_transactions;
    @Column(name="FAILED")
    private Integer failed_transactions;
    @Column(name="DISPATCHER_TRANS_ID")
    private long dispatcher_transaction_id;

    public Entry() {
    }

    public Entry(int n, int n2, String string, int n3, String string2, STATUS sTATUS, Integer n4, Integer n5) {
        this.command_id = n;
        this.priority = n2;
        this.executed_transmissions = 0;
        this.dispatcher = string;
        this.wpid = n3;
        this.command_data = string2;
        this.status = sTATUS.id;
        this.timestamp = new Timestamp(System.currentTimeMillis());
        this.completed_transactions = n4;
        this.failed_transactions = n5;
        this.dispatcher_transaction_id = -1L;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public int getStatus() {
        return this.status;
    }

    @Transient
    public String getStatusAsString() {
        for (STATUS sTATUS : STATUS.values()) {
            if (sTATUS.id != this.status) continue;
            return sTATUS.name();
        }
        return "";
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setStatusDetails(String string) {
        this.status_details = string;
    }

    public String getStatusDetails() {
        return this.status_details;
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(String string) {
        this.dispatcher = string;
    }

    public int getCommandId() {
        return this.command_id;
    }

    @Transient
    public COMMAND getCommand() {
        for (COMMAND cOMMAND : COMMAND.values()) {
            if (cOMMAND.id != this.command_id) continue;
            return cOMMAND;
        }
        return COMMAND.INVALID;
    }

    @Transient
    public String getCommandAsString() {
        for (COMMAND cOMMAND : COMMAND.values()) {
            if (cOMMAND.id != this.command_id) continue;
            return cOMMAND.name();
        }
        return COMMAND.INVALID.name();
    }

    public void setCommandId(int n) {
        this.command_id = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getExecutedTransmissions() {
        return this.executed_transmissions;
    }

    public void increaseExecutedTransmissions() {
        ++this.executed_transmissions;
    }

    public int getCompletedTransactions() {
        return this.completed_transactions;
    }

    public void setCompletedTransactions(int n) {
        this.completed_transactions = n;
    }

    public int getFailedFransactions() {
        return this.failed_transactions;
    }

    public void setFailedTransactions(int n) {
        this.failed_transactions = n;
    }

    public int getWpid() {
        return this.wpid;
    }

    public void setWpid(int n) {
        this.wpid = n;
    }

    public String getCommandData() {
        return this.command_data;
    }

    public void setCommandData(String string) {
        this.command_data = string;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public long getDispatcherTransactionId() {
        return this.dispatcher_transaction_id;
    }

    public void setDispatcherTransactionId(long l) {
        this.dispatcher_transaction_id = l;
    }

    @Transient
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        stringBuilder.append(" prio:");
        stringBuilder.append(this.priority);
        stringBuilder.append(" exe:");
        stringBuilder.append(this.executed_transmissions);
        stringBuilder.append(" cmd:");
        stringBuilder.append(this.getCommandAsString());
        stringBuilder.append(" time:");
        stringBuilder.append(this.timestamp);
        stringBuilder.append(" finished:");
        stringBuilder.append(this.finished_on);
        stringBuilder.append(" status:");
        stringBuilder.append(this.getStatusAsString());
        stringBuilder.append(" status_details:");
        stringBuilder.append(this.status_details);
        stringBuilder.append(" dp:");
        stringBuilder.append(this.dispatcher);
        stringBuilder.append(" wpid:");
        stringBuilder.append(this.wpid);
        stringBuilder.append(" goodta:");
        stringBuilder.append(this.completed_transactions);
        stringBuilder.append(" badta:");
        stringBuilder.append(this.failed_transactions);
        stringBuilder.append(" dp_trans_id:");
        stringBuilder.append(this.dispatcher_transaction_id);
        return stringBuilder.toString();
    }

    public void getEverything(PrintWriter printWriter) {
        printWriter.print(this.id);
        printWriter.print(" prio:");
        printWriter.print(this.priority);
        printWriter.print(" exe:");
        printWriter.print(this.executed_transmissions);
        printWriter.print(" cmd:");
        printWriter.print(this.getCommandAsString());
        printWriter.print(" time:");
        printWriter.print(this.timestamp);
        printWriter.print(" finished:");
        printWriter.print(this.finished_on);
        printWriter.print(" status:");
        printWriter.print(this.getStatusAsString());
        printWriter.append(" status_details:");
        printWriter.append(this.status_details);
        printWriter.print(" dp:");
        printWriter.print(this.dispatcher);
        printWriter.print(" wpid:");
        printWriter.print(this.wpid);
        printWriter.print(" cmd_data:");
        printWriter.print(this.command_data);
        printWriter.print(" goodta:");
        printWriter.print(this.completed_transactions);
        printWriter.print(" badta:");
        printWriter.print(this.failed_transactions);
        printWriter.print(" dp_trans_id:");
        printWriter.print(this.dispatcher_transaction_id);
    }

    public void setFinishedOn(Timestamp timestamp) {
        this.finished_on = timestamp;
    }

    public Timestamp getFinishedOn() {
        return this.finished_on;
    }

    public static enum COMMAND {
        WP_WAKEUP(0, false, true),
        WP_IMAGE(1, false, true),
        WP_DATA(2, false, true),
        WP_SCREEN_UPDATE_METHOD(3, false, true),
        DP_ADDRESS(11, true, true),
        DP_RESTART(12, true, true),
        DP_UPDATE_FIRMWARE(13, true, true),
        DP_IDENTIFY(17, true, true),
        CANCEL_TRANSACTION(20, false, false),
        INVALID(255, false, true);

        public final int id;
        public final boolean is_dispatcher_command;
        public final boolean is_mergeable;

        private COMMAND(int n2, boolean bl, boolean bl2) {
            this.id = n2;
            this.is_dispatcher_command = bl;
            this.is_mergeable = bl2;
        }
    }

    public static enum STATUS {
        ON_SERVER(0, false),
        ON_ROUTER(1, false),
        ON_TARGET(2, true),
        PARAM_ERROR(3, true),
        OVERWRITTEN(4, true),
        ERROR(5, true),
        STARVED(6, true),
        FINISHED(7, true),
        CANCELLED(8, true);

        public final int id;
        public final boolean is_final;

        private STATUS(int n2, boolean bl) {
            this.id = n2;
            this.is_final = bl;
        }
    }
}

