/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.transactions;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;

class HibernateUtil {
    private static Logger logger = LogManager.getLogger(HibernateUtil.class);
    private static Configuration config;
    private static final SessionFactory sessionFactory;

    private HibernateUtil() {
    }

    private static SessionFactory buildSessionFactory() {
        try {
            WpUpiServerLocator wpUpiServerLocator = WpUpiServerStaticFactory.getServerLocator();
            logger.debug("HIBERNATE_CFG: " + wpUpiServerLocator.getString(WpUpiServerLocator.WpUpiServerLocatorPropType.HIBERNATE_CFG_FILE));
            config = new Configuration().configure(new File(wpUpiServerLocator.getString(WpUpiServerLocator.WpUpiServerLocatorPropType.HIBERNATE_CFG_FILE)));
            StandardServiceRegistry standardServiceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
            return config.buildSessionFactory((ServiceRegistry)standardServiceRegistry);
        }
        catch (Throwable throwable) {
            logger.error("Could not bring up hibernate.", throwable);
            throw new ExceptionInInitializerError(throwable);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void shutdown() {
        HibernateUtil.getSessionFactory().close();
    }

    public static String getConnectionURL() {
        return config.getProperty("hibernate.connection.url");
    }

    public static void logStatistics() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Statistics statistics = sessionFactory.getStatistics();
        if (!statistics.isStatisticsEnabled()) {
            return;
        }
        hashMap.put("ConnectCount", statistics.getConnectCount());
        hashMap.put("FlushCount", statistics.getFlushCount());
        hashMap.put("TransactionCount", statistics.getTransactionCount());
        hashMap.put("SuccessfulTransactionCount", statistics.getSuccessfulTransactionCount());
        hashMap.put("SessionOpenCount", statistics.getSessionOpenCount());
        hashMap.put("SessionCloseCount", statistics.getSessionCloseCount());
        hashMap.put("QueryExecutionCount", statistics.getQueryExecutionCount());
        hashMap.put("QueryExecutionMaxTime", statistics.getQueryExecutionMaxTime());
        hashMap.put("CollectionFetchCount", statistics.getCollectionFetchCount());
        hashMap.put("CollectionLoadCount", statistics.getCollectionLoadCount());
        hashMap.put("CollectionRecreateCount", statistics.getCollectionRecreateCount());
        hashMap.put("CollectionRemoveCount", statistics.getCollectionRemoveCount());
        hashMap.put("CollectionUpdateCount", statistics.getCollectionUpdateCount());
        hashMap.put("EntityDeleteCount", statistics.getEntityDeleteCount());
        hashMap.put("EntityFetchCount", statistics.getEntityFetchCount());
        hashMap.put("EntityLoadCount", statistics.getEntityLoadCount());
        hashMap.put("EntityInsertCount", statistics.getEntityInsertCount());
        hashMap.put("EntityUpdateCount", statistics.getEntityUpdateCount());
        logger.info("DBSTATS: " + PrettyPrinter.condensed(hashMap));
    }

    static {
        sessionFactory = HibernateUtil.buildSessionFactory();
    }
}

