/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class InvertedLuminanceSource
extends LuminanceSource {
    private final LuminanceSource delegate;

    public InvertedLuminanceSource(LuminanceSource luminanceSource) {
        super(luminanceSource.getWidth(), luminanceSource.getHeight());
        this.delegate = luminanceSource;
    }

    @Override
    public byte[] getRow(int n, byte[] byArray) {
        byArray = this.delegate.getRow(n, byArray);
        int n2 = this.getWidth();
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(255 - (byArray[i] & 0xFF));
        }
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        byte[] byArray = this.delegate.getMatrix();
        int n = this.getWidth() * this.getHeight();
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = (byte)(255 - (byArray[i] & 0xFF));
        }
        return byArray2;
    }

    @Override
    public boolean isCropSupported() {
        return this.delegate.isCropSupported();
    }

    @Override
    public LuminanceSource crop(int n, int n2, int n3, int n4) {
        return new InvertedLuminanceSource(this.delegate.crop(n, n2, n3, n4));
    }

    @Override
    public boolean isRotateSupported() {
        return this.delegate.isRotateSupported();
    }

    @Override
    public LuminanceSource invert() {
        return this.delegate;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        return new InvertedLuminanceSource(this.delegate.rotateCounterClockwise());
    }

    @Override
    public LuminanceSource rotateCounterClockwise45() {
        return new InvertedLuminanceSource(this.delegate.rotateCounterClockwise45());
    }
}

