/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public RGBLuminanceSource(int n, int n2, int[] nArray) {
        super(n, n2);
        this.dataWidth = n;
        this.dataHeight = n2;
        this.left = 0;
        this.top = 0;
        this.luminances = new byte[n * n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[n3 + j];
                int n5 = n4 >> 16 & 0xFF;
                int n6 = n4 >> 8 & 0xFF;
                int n7 = n4 & 0xFF;
                this.luminances[n3 + j] = n5 == n6 && n6 == n7 ? (byte)n5 : (byte)(n5 + n6 + n6 + n7 >> 2);
            }
        }
    }

    private RGBLuminanceSource(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n5, n6);
        if (n3 + n5 > n || n4 + n6 > n2) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.luminances = byArray;
        this.dataWidth = n;
        this.dataHeight = n2;
        this.left = n3;
        this.top = n4;
    }

    @Override
    public byte[] getRow(int n, byte[] byArray) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n);
        }
        int n2 = this.getWidth();
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        int n3 = (n + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.luminances, n3, byArray, 0, n2);
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == this.dataWidth && n2 == this.dataHeight) {
            return this.luminances;
        }
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        int n4 = this.top * this.dataWidth + this.left;
        if (n == this.dataWidth) {
            System.arraycopy(this.luminances, n4, byArray, 0, n3);
            return byArray;
        }
        byte[] byArray2 = this.luminances;
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n;
            System.arraycopy(byArray2, n4, byArray, n5, n);
            n4 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n, int n2, int n3, int n4) {
        return new RGBLuminanceSource(this.luminances, this.dataWidth, this.dataHeight, this.left + n, this.top + n2, n3, n4);
    }
}

