/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.util.EnumMap;
import java.util.Map;

public final class Result {
    private final String text;
    private final byte[] rawBytes;
    private ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private Map<ResultMetadataType, Object> resultMetadata;
    private final long timestamp;

    public Result(String string, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat) {
        this(string, byArray, resultPointArray, barcodeFormat, System.currentTimeMillis());
    }

    public Result(String string, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat, long l) {
        this.text = string;
        this.rawBytes = byArray;
        this.resultPoints = resultPointArray;
        this.format = barcodeFormat;
        this.resultMetadata = null;
        this.timestamp = l;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public Map<ResultMetadataType, Object> getResultMetadata() {
        return this.resultMetadata;
    }

    public void putMetadata(ResultMetadataType resultMetadataType, Object object) {
        if (this.resultMetadata == null) {
            this.resultMetadata = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        }
        this.resultMetadata.put(resultMetadataType, object);
    }

    public void putAllMetadata(Map<ResultMetadataType, Object> map) {
        if (map != null) {
            if (this.resultMetadata == null) {
                this.resultMetadata = map;
            } else {
                this.resultMetadata.putAll(map);
            }
        }
    }

    public void addResultPoints(ResultPoint[] resultPointArray) {
        ResultPoint[] resultPointArray2 = this.resultPoints;
        if (resultPointArray2 == null) {
            this.resultPoints = resultPointArray;
        } else if (resultPointArray != null && resultPointArray.length > 0) {
            ResultPoint[] resultPointArray3 = new ResultPoint[resultPointArray2.length + resultPointArray.length];
            System.arraycopy(resultPointArray2, 0, resultPointArray3, 0, resultPointArray2.length);
            System.arraycopy(resultPointArray, 0, resultPointArray3, resultPointArray2.length, resultPointArray.length);
            this.resultPoints = resultPointArray3;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.text;
    }
}

