/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringsResourceTranslator {
    private static final String API_KEY = System.getProperty("translateAPI.key");
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<string name=\"([^\"]+)\".*>([^<]+)</string>");
    private static final Pattern STRINGS_FILE_NAME_PATTERN = Pattern.compile("values-(.+)");
    private static final Pattern TRANSLATE_RESPONSE_PATTERN = Pattern.compile("translatedText\":\\s*\"([^\"]+)\"");
    private static final Pattern VALUES_DIR_PATTERN = Pattern.compile("values-[a-z]{2}(-[a-zA-Z]{2,3})?");
    private static final String APACHE_2_LICENSE = "<!--\n Copyright (C) 2013 ZXing authors\n\n Licensed under the Apache License, Version 2.0 (the \"License\");\n you may not use this file except in compliance with the License.\n You may obtain a copy of the License at\n\n      http://www.apache.org/licenses/LICENSE-2.0\n\n Unless required by applicable law or agreed to in writing, software\n distributed under the License is distributed on an \"AS IS\" BASIS,\n WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n See the License for the specific language governing permissions and\n limitations under the License.\n -->\n";
    private static final Map<String, String> LANGUAGE_CODE_MASSAGINGS = new HashMap<String, String>(3);

    private StringsResourceTranslator() {
    }

    public static void main(String[] stringArray) throws IOException {
        File[] fileArray;
        File file = new File(stringArray[0]);
        File file2 = new File(file, "values");
        File file3 = new File(file2, "strings.xml");
        List<String> list = Arrays.asList(stringArray).subList(1, stringArray.length);
        for (File file4 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && VALUES_DIR_PATTERN.matcher(file.getName()).matches();
            }
        })) {
            File file5 = new File(file4, "strings.xml");
            StringsResourceTranslator.translate(file3, file5, list);
        }
    }

    private static void translate(File file, File file2, Collection<String> collection) throws IOException {
        SortedMap<String, String> sortedMap = StringsResourceTranslator.readLines(file);
        SortedMap<String, String> sortedMap2 = StringsResourceTranslator.readLines(file2);
        String string = file2.getParentFile().getName();
        Matcher matcher = STRINGS_FILE_NAME_PATTERN.matcher(string);
        matcher.find();
        String string2 = matcher.group(1);
        String string3 = LANGUAGE_CODE_MASSAGINGS.get(string2);
        if (string3 != null) {
            string2 = string3;
        }
        System.out.println("Translating " + string2);
        File file3 = File.createTempFile(string, ".xml");
        file3.deleteOnExit();
        boolean bl = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), UTF8));){
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bufferedWriter.write(APACHE_2_LICENSE);
            bufferedWriter.write("<resources>\n");
            for (Map.Entry entry : sortedMap.entrySet()) {
                String string4 = (String)entry.getKey();
                String string5 = (String)entry.getValue();
                bufferedWriter.write("  <string name=\"");
                bufferedWriter.write(string4);
                ((Writer)bufferedWriter).write(34);
                if (string5.contains("%s") || string5.contains("%f")) {
                    bufferedWriter.write(" formatted=\"false\"");
                }
                ((Writer)bufferedWriter).write(62);
                String string6 = (String)sortedMap2.get(string4);
                if (string6 == null || collection.contains(string4)) {
                    bl = true;
                    string6 = StringsResourceTranslator.translateString(string5, string2);
                }
                bufferedWriter.write(string6);
                bufferedWriter.write("</string>\n");
            }
            bufferedWriter.write("</resources>\n");
            ((Writer)bufferedWriter).flush();
        }
        if (bl) {
            System.out.println("  Writing translations");
            file2.delete();
            file3.renameTo(file2);
        } else {
            file3.delete();
        }
    }

    static String translateString(String string, String string2) throws IOException {
        if ("en".equals(string2)) {
            return string;
        }
        String string3 = LANGUAGE_CODE_MASSAGINGS.get(string2);
        if (string3 != null) {
            string2 = string3;
        }
        System.out.println("  Need translation for " + string);
        if (API_KEY == null) {
            throw new IllegalArgumentException("translateAPI.key is not specified");
        }
        URL uRL = new URL("https://www.googleapis.com/language/translate/v2?key=" + API_KEY + "&q=" + URLEncoder.encode(string, "UTF-8") + "&source=en&target=" + string2);
        CharSequence charSequence = StringsResourceTranslator.fetch(uRL);
        Matcher matcher = TRANSLATE_RESPONSE_PATTERN.matcher(charSequence);
        if (!matcher.find()) {
            System.err.println("No translate result");
            System.err.println(charSequence);
            return string;
        }
        String string4 = matcher.group(1);
        System.out.println("  Got translation " + string4);
        string4 = string4.replaceAll("\\\\u0026quot;", "\"");
        string4 = string4.replaceAll("\\\\u0026#39;", "'");
        string4 = string4.replaceAll("\\\\u200b", "");
        string4 = string4.replaceAll("&amp;quot;", "\"");
        string4 = string4.replaceAll("&amp;#39;", "'");
        return string4;
    }

    private static CharSequence fetch(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        StringBuilder stringBuilder = new StringBuilder(200);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), UTF8));){
            int n;
            char[] cArray = new char[1024];
            while ((n = bufferedReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        return stringBuilder;
    }

    private static SortedMap<String, String> readLines(File file) throws IOException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (!file.exists()) {
            return treeMap;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8));){
            Object object;
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                object = ENTRY_PATTERN.matcher(string);
                if (!((Matcher)object).find()) continue;
                String string2 = ((Matcher)object).group(1);
                String string3 = ((Matcher)object).group(2);
                treeMap.put(string2, string3);
            }
            object = treeMap;
            return object;
        }
    }

    static {
        LANGUAGE_CODE_MASSAGINGS.put("zh-rCN", "zh-cn");
        LANGUAGE_CODE_MASSAGINGS.put("zh-rTW", "zh-tw");
    }
}

