/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult ddata;

    public DecoderResult decode(AztecDetectorResult aztecDetectorResult) throws FormatException {
        this.ddata = aztecDetectorResult;
        BitMatrix bitMatrix = aztecDetectorResult.getBits();
        boolean[] blArray = this.extractBits(bitMatrix);
        boolean[] blArray2 = this.correctBits(blArray);
        String string = Decoder.getEncodedData(blArray2);
        return new DecoderResult(null, string, null, null);
    }

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.getEncodedData(blArray);
    }

    private static String getEncodedData(boolean[] blArray) {
        int n = blArray.length;
        Table table = Table.UPPER;
        Table table2 = Table.UPPER;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            if (table2 == Table.BINARY) {
                if (n - n2 < 5) break;
                n4 = Decoder.readCode(blArray, n2, 5);
                n2 += 5;
                if (n4 == 0) {
                    if (n - n2 < 11) break;
                    n4 = Decoder.readCode(blArray, n2, 11) + 31;
                    n2 += 11;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    if (n - n2 < 8) {
                        n2 = n;
                        break;
                    }
                    int n5 = Decoder.readCode(blArray, n2, 8);
                    stringBuilder.append((char)n5);
                    n2 += 8;
                }
                table2 = table;
                continue;
            }
            int n6 = n4 = table2 == Table.DIGIT ? 4 : 5;
            if (n - n2 < n4) break;
            n3 = Decoder.readCode(blArray, n2, n4);
            n2 += n4;
            String string = Decoder.getCharacter(table2, n3);
            if (string.startsWith("CTRL_")) {
                table2 = Decoder.getTable(string.charAt(5));
                if (string.charAt(6) != 'L') continue;
                table = table2;
                continue;
            }
            stringBuilder.append(string);
            table2 = table;
        }
        return stringBuilder.toString();
    }

    private static Table getTable(char c) {
        switch (c) {
            case 'L': {
                return Table.LOWER;
            }
            case 'P': {
                return Table.PUNCT;
            }
            case 'M': {
                return Table.MIXED;
            }
            case 'D': {
                return Table.DIGIT;
            }
            case 'B': {
                return Table.BINARY;
            }
        }
        return Table.UPPER;
    }

    private static String getCharacter(Table table, int n) {
        switch (table) {
            case UPPER: {
                return UPPER_TABLE[n];
            }
            case LOWER: {
                return LOWER_TABLE[n];
            }
            case MIXED: {
                return MIXED_TABLE[n];
            }
            case PUNCT: {
                return PUNCT_TABLE[n];
            }
            case DIGIT: {
                return DIGIT_TABLE[n];
            }
        }
        throw new IllegalStateException("Bad table");
    }

    private boolean[] correctBits(boolean[] blArray) throws FormatException {
        int n;
        GenericGF genericGF;
        int n2;
        if (this.ddata.getNbLayers() <= 2) {
            n2 = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            n2 = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            n2 = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            n2 = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n3 = this.ddata.getNbDatablocks();
        int n4 = blArray.length / n2;
        int n5 = blArray.length % n2;
        int n6 = n4 - n3;
        int[] nArray = new int[n4];
        int n7 = 0;
        while (n7 < n4) {
            nArray[n7] = Decoder.readCode(blArray, n5, n2);
            ++n7;
            n5 += n2;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(genericGF);
            reedSolomonDecoder.decode(nArray, n6);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw FormatException.getFormatInstance();
        }
        int n8 = (1 << n2) - 1;
        int n9 = 0;
        for (int i = 0; i < n3; ++i) {
            n = nArray[i];
            if (n == 0 || n == n8) {
                throw FormatException.getFormatInstance();
            }
            if (n != 1 && n != n8 - 1) continue;
            ++n9;
        }
        boolean[] blArray2 = new boolean[n3 * n2 - n9];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            int n10 = nArray[i];
            if (n10 == 1 || n10 == n8 - 1) {
                Arrays.fill(blArray2, n, n + n2 - 1, n10 > 1);
                n += n2 - 1;
                continue;
            }
            for (int j = n2 - 1; j >= 0; --j) {
                blArray2[n++] = (n10 & 1 << j) != 0;
            }
        }
        return blArray2;
    }

    boolean[] extractBits(BitMatrix bitMatrix) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = this.ddata.isCompact();
        int n6 = this.ddata.getNbLayers();
        int n7 = bl ? 11 + n6 * 4 : 14 + n6 * 4;
        int[] nArray = new int[n7];
        boolean[] blArray = new boolean[Decoder.totalBitsInLayer(n6, bl)];
        if (bl) {
            for (n5 = 0; n5 < nArray.length; ++n5) {
                nArray[n5] = n5;
            }
        } else {
            n5 = n7 + 1 + 2 * ((n7 / 2 - 1) / 15);
            n4 = n7 / 2;
            n3 = n5 / 2;
            for (n2 = 0; n2 < n4; ++n2) {
                n = n2 + n2 / 15;
                nArray[n4 - n2 - 1] = n3 - n - 1;
                nArray[n4 + n2] = n3 + n + 1;
            }
        }
        n4 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            n3 = bl ? (n6 - n5) * 4 + 9 : (n6 - n5) * 4 + 12;
            n2 = n5 * 2;
            n = n7 - 1 - n2;
            for (int i = 0; i < n3; ++i) {
                int n8 = i * 2;
                for (int j = 0; j < 2; ++j) {
                    blArray[n4 + n8 + j] = bitMatrix.get(nArray[n2 + j], nArray[n2 + i]);
                    blArray[n4 + 2 * n3 + n8 + j] = bitMatrix.get(nArray[n2 + i], nArray[n - j]);
                    blArray[n4 + 4 * n3 + n8 + j] = bitMatrix.get(nArray[n - j], nArray[n - i]);
                    blArray[n4 + 6 * n3 + n8 + j] = bitMatrix.get(nArray[n - i], nArray[n2 + j]);
                }
            }
            n4 += n3 * 8;
        }
        return blArray;
    }

    private static int readCode(boolean[] blArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 <<= 1;
            if (!blArray[i]) continue;
            ++n3;
        }
        return n3;
    }

    private static int totalBitsInLayer(int n, boolean bl) {
        return ((bl ? 88 : 112) + 16 * n) * n;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

