/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.aztec.encoder.Token;
import com.google.zxing.common.BitArray;
import java.util.LinkedList;

final class State {
    static final State INITIAL_STATE = new State(Token.EMPTY, 0, 0, 0);
    private final int mode;
    private final Token token;
    private final int binaryShiftByteCount;
    private final int bitCount;

    private State(Token token, int n, int n2, int n3) {
        this.token = token;
        this.mode = n;
        this.binaryShiftByteCount = n2;
        this.bitCount = n3;
    }

    int getMode() {
        return this.mode;
    }

    Token getToken() {
        return this.token;
    }

    int getBinaryShiftByteCount() {
        return this.binaryShiftByteCount;
    }

    int getBitCount() {
        return this.bitCount;
    }

    State latchAndAppend(int n, int n2) {
        int n3;
        int n4 = this.bitCount;
        Token token = this.token;
        if (n != this.mode) {
            n3 = HighLevelEncoder.LATCH_TABLE[this.mode][n];
            token = token.add(n3 & 0xFFFF, n3 >> 16);
            n4 += n3 >> 16;
        }
        n3 = n == 2 ? 4 : 5;
        token = token.add(n2, n3);
        return new State(token, n, 0, n4 + n3);
    }

    State shiftAndAppend(int n, int n2) {
        Token token = this.token;
        int n3 = this.mode == 2 ? 4 : 5;
        token = token.add(HighLevelEncoder.SHIFT_TABLE[this.mode][n], n3);
        token = token.add(n2, 5);
        return new State(token, this.mode, 0, this.bitCount + n3 + 5);
    }

    State addBinaryShiftChar(int n) {
        int n2;
        Token token = this.token;
        int n3 = this.mode;
        int n4 = this.bitCount;
        if (this.mode == 4 || this.mode == 2) {
            n2 = HighLevelEncoder.LATCH_TABLE[n3][0];
            token = token.add(n2 & 0xFFFF, n2 >> 16);
            n4 += n2 >> 16;
            n3 = 0;
        }
        n2 = this.binaryShiftByteCount == 0 || this.binaryShiftByteCount == 31 ? 18 : (this.binaryShiftByteCount == 62 ? 9 : 8);
        State state = new State(token, n3, this.binaryShiftByteCount + 1, n4 + n2);
        if (state.binaryShiftByteCount == 2078) {
            state = state.endBinaryShift(n + 1);
        }
        return state;
    }

    State endBinaryShift(int n) {
        if (this.binaryShiftByteCount == 0) {
            return this;
        }
        Token token = this.token;
        token = token.addBinaryShift(n - this.binaryShiftByteCount, this.binaryShiftByteCount);
        return new State(token, this.mode, 0, this.bitCount);
    }

    boolean isBetterThanOrEqualTo(State state) {
        int n = this.bitCount + (HighLevelEncoder.LATCH_TABLE[this.mode][state.mode] >> 16);
        if (state.binaryShiftByteCount > 0 && (this.binaryShiftByteCount == 0 || this.binaryShiftByteCount > state.binaryShiftByteCount)) {
            n += 10;
        }
        return n <= state.bitCount;
    }

    BitArray toBitArray(byte[] byArray) {
        Object object;
        LinkedList<Token> linkedList = new LinkedList<Token>();
        for (object = this.endBinaryShift((int)byArray.length).token; object != null; object = ((Token)object).getPrevious()) {
            linkedList.addFirst((Token)object);
        }
        object = new BitArray();
        for (Token token : linkedList) {
            token.appendTo((BitArray)object, byArray);
        }
        return object;
    }

    public String toString() {
        return String.format("%s bits=%d bytes=%d", HighLevelEncoder.MODE_NAMES[this.mode], this.bitCount, this.binaryShiftByteCount);
    }
}

