/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.LuminanceSource;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public final class BufferedImageLuminanceSource
extends LuminanceSource {
    private static final double MINUS_45_IN_RADIANS = -0.7853981633974483;
    private final BufferedImage image;
    private final int left;
    private final int top;
    private static final boolean EXPLICIT_LUMINANCE_CONVERSION;

    public BufferedImageLuminanceSource(BufferedImage bufferedImage) {
        this(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public BufferedImageLuminanceSource(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        super(n3, n4);
        if (bufferedImage.getType() == 10) {
            this.image = bufferedImage;
        } else {
            int n5 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            if (n + n3 > n5 || n2 + n4 > n6) {
                throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
            }
            this.image = new BufferedImage(n5, n6, 10);
            if (EXPLICIT_LUMINANCE_CONVERSION) {
                WritableRaster writableRaster = this.image.getRaster();
                int[] nArray = new int[n3];
                for (int i = n2; i < n2 + n4; ++i) {
                    bufferedImage.getRGB(n, i, n3, 1, nArray, 0, n5);
                    for (int j = 0; j < n3; ++j) {
                        int n7 = nArray[j];
                        if ((n7 & 0xFF000000) == 0) {
                            n7 = -1;
                        }
                        nArray[j] = 306 * (n7 >> 16 & 0xFF) + 601 * (n7 >> 8 & 0xFF) + 117 * (n7 & 0xFF) + 512 >> 10;
                    }
                    writableRaster.setPixels(n, i, n3, 1, nArray);
                }
            } else {
                if (bufferedImage.getAlphaRaster() != null) {
                    int[] nArray = new int[n3];
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, nArray, 0, n5);
                        boolean bl = false;
                        for (int j = 0; j < n3; ++j) {
                            if ((nArray[j] & 0xFF000000) != 0) continue;
                            nArray[j] = -1;
                            bl = true;
                        }
                        if (!bl) continue;
                        bufferedImage.setRGB(n, i, n3, 1, nArray, 0, n5);
                    }
                }
                this.image.getGraphics().drawImage(bufferedImage, 0, 0, null);
            }
        }
        this.left = n;
        this.top = n2;
    }

    @Override
    public byte[] getRow(int n, byte[] byArray) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n);
        }
        int n2 = this.getWidth();
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        this.image.getRaster().getDataElements(this.left, this.top + n, n2, 1, byArray);
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        this.image.getRaster().getDataElements(this.left, this.top, n, n2, byArray);
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n, int n2, int n3, int n4) {
        return new BufferedImageLuminanceSource(this.image, this.left + n, this.top + n2, n3, n4);
    }

    @Override
    public boolean isRotateSupported() {
        return true;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        AffineTransform affineTransform = new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, (double)n);
        BufferedImage bufferedImage = new BufferedImage(n2, n, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.image, affineTransform, null);
        graphics2D.dispose();
        int n3 = this.getWidth();
        return new BufferedImageLuminanceSource(bufferedImage, this.top, n - (this.left + n3), this.getHeight(), n3);
    }

    @Override
    public LuminanceSource rotateCounterClockwise45() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.left + n / 2;
        int n4 = this.top + n2 / 2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-0.7853981633974483, n3, n4);
        int n5 = Math.max(this.image.getWidth(), this.image.getHeight());
        BufferedImage bufferedImage = new BufferedImage(n5, n5, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.image, affineTransform, null);
        graphics2D.dispose();
        int n6 = Math.max(n, n2) / 2;
        int n7 = Math.max(0, n3 - n6);
        int n8 = Math.max(0, n4 - n6);
        int n9 = Math.min(n5 - 1, n3 + n6);
        int n10 = Math.min(n5 - 1, n4 + n6);
        return new BufferedImageLuminanceSource(bufferedImage, n7, n8, n9 - n7, n10 - n8);
    }

    static {
        String string = System.getProperty("explicitLuminanceConversion");
        if (string == null) {
            string = System.getenv("EXPLICIT_LUMINANCE_CONVERSION");
        }
        EXPLICIT_LUMINANCE_CONVERSION = Boolean.parseBoolean(string);
    }
}

