/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.File;
import java.util.Locale;

public final class CommandLineEncoder {
    private static final BarcodeFormat DEFAULT_BARCODE_FORMAT = BarcodeFormat.QR_CODE;
    private static final String DEFAULT_IMAGE_FORMAT = "PNG";
    private static final String DEFAULT_OUTPUT_FILE = "out";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;

    private CommandLineEncoder() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            CommandLineEncoder.printUsage();
            return;
        }
        BarcodeFormat barcodeFormat = DEFAULT_BARCODE_FORMAT;
        String string = DEFAULT_IMAGE_FORMAT;
        Object object = DEFAULT_OUTPUT_FILE;
        int n = 300;
        int n2 = 300;
        String string2 = null;
        block14: for (String string3 : stringArray) {
            String[] stringArray2 = string3.split("=");
            switch (stringArray2[0]) {
                case "--barcode_format": {
                    barcodeFormat = BarcodeFormat.valueOf(stringArray2[1]);
                    continue block14;
                }
                case "--image_format": {
                    string = stringArray2[1];
                    continue block14;
                }
                case "--output": {
                    object = stringArray2[1];
                    continue block14;
                }
                case "--width": {
                    n = Integer.parseInt(stringArray2[1]);
                    continue block14;
                }
                case "--height": {
                    n2 = Integer.parseInt(stringArray2[1]);
                    continue block14;
                }
                default: {
                    if (string3.startsWith("-")) {
                        System.err.println("Unknown command line option " + string3);
                        CommandLineEncoder.printUsage();
                        return;
                    }
                    string2 = string3;
                }
            }
        }
        if (string2 == null) {
            CommandLineEncoder.printUsage();
            return;
        }
        if (DEFAULT_OUTPUT_FILE.equals(object)) {
            object = (String)object + "." + string.toLowerCase(Locale.ENGLISH);
        }
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = multiFormatWriter.encode(string2, barcodeFormat, n, n2);
        MatrixToImageWriter.writeToFile(bitMatrix, string, new File((String)object));
    }

    private static void printUsage() {
        System.err.println("Encodes barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineEncoder [ options ] content_to_encode");
        System.err.println("  --barcode_format=format: Format to encode, from BarcodeFormat class. Not all formats are supported. Defaults to QR_CODE.");
        System.err.println("  --image_format=format: image output format, such as PNG, JPG, GIF. Defaults to PNG");
        System.err.println("  --output=filename: File to write to. Defaults to out.png");
        System.err.println("  --width=pixels: Image width. Defaults to 300");
        System.err.println("  --height=pixels: Image height. Defaults to 300");
    }
}

