/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AbstractDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressParsedResult;
import java.util.regex.Pattern;

public final class EmailDoCoMoResultParser
extends AbstractDoCoMoResultParser {
    private static final Pattern ATEXT_ALPHANUMERIC = Pattern.compile("[a-zA-Z0-9@.!#$%&'*+\\-/=?^_`{|}~]+");

    @Override
    public EmailAddressParsedResult parse(Result result) {
        String string = EmailDoCoMoResultParser.getMassagedText(result);
        if (!string.startsWith("MATMSG:")) {
            return null;
        }
        String[] stringArray = EmailDoCoMoResultParser.matchDoCoMoPrefixedField("TO:", string, true);
        if (stringArray == null) {
            return null;
        }
        String string2 = stringArray[0];
        if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress(string2)) {
            return null;
        }
        String string3 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("SUB:", string, false);
        String string4 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("BODY:", string, false);
        return new EmailAddressParsedResult(string2, string3, string4, "mailto:" + string2);
    }

    static boolean isBasicallyValidEmailAddress(String string) {
        return string != null && ATEXT_ALPHANUMERIC.matcher(string).matches() && string.indexOf(64) >= 0;
    }
}

