/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.GeoParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GeoResultParser
extends ResultParser {
    private static final Pattern GEO_URL_PATTERN = Pattern.compile("geo:([\\-0-9.]+),([\\-0-9.]+)(?:,([\\-0-9.]+))?(?:\\?(.*))?", 2);

    @Override
    public GeoParsedResult parse(Result result) {
        double d;
        double d2;
        double d3;
        String string = GeoResultParser.getMassagedText(result);
        Matcher matcher = GEO_URL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(4);
        try {
            d3 = Double.parseDouble(matcher.group(1));
            if (d3 > 90.0 || d3 < -90.0) {
                return null;
            }
            d2 = Double.parseDouble(matcher.group(2));
            if (d2 > 180.0 || d2 < -180.0) {
                return null;
            }
            if (matcher.group(3) == null) {
                d = 0.0;
            } else {
                d = Double.parseDouble(matcher.group(3));
                if (d < 0.0) {
                    return null;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new GeoParsedResult(d3, d2, d, string2);
    }
}

