/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class SMSParsedResult
extends ParsedResult {
    private final String[] numbers;
    private final String[] vias;
    private final String subject;
    private final String body;

    public SMSParsedResult(String string, String string2, String string3, String string4) {
        super(ParsedResultType.SMS);
        this.numbers = new String[]{string};
        this.vias = new String[]{string2};
        this.subject = string3;
        this.body = string4;
    }

    public SMSParsedResult(String[] stringArray, String[] stringArray2, String string, String string2) {
        super(ParsedResultType.SMS);
        this.numbers = stringArray;
        this.vias = stringArray2;
        this.subject = string;
        this.body = string2;
    }

    public String getSMSURI() {
        boolean bl;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sms:");
        boolean bl2 = true;
        for (n = 0; n < this.numbers.length; ++n) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.numbers[n]);
            if (this.vias == null || this.vias[n] == null) continue;
            stringBuilder.append(";via=");
            stringBuilder.append(this.vias[n]);
        }
        n = this.body != null ? 1 : 0;
        boolean bl3 = bl = this.subject != null;
        if (n != 0 || bl) {
            stringBuilder.append('?');
            if (n != 0) {
                stringBuilder.append("body=");
                stringBuilder.append(this.body);
            }
            if (bl) {
                if (n != 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("subject=");
                stringBuilder.append(this.subject);
            }
        }
        return stringBuilder.toString();
    }

    public String[] getNumbers() {
        return this.numbers;
    }

    public String[] getVias() {
        return this.vias;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(100);
        SMSParsedResult.maybeAppend(this.numbers, stringBuilder);
        SMSParsedResult.maybeAppend(this.subject, stringBuilder);
        SMSParsedResult.maybeAppend(this.body, stringBuilder);
        return stringBuilder.toString();
    }
}

